/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskResultImpl;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowContext;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowEventBus;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class StepResult {
    private static final String TASK_COUNTERS_TAG = "Task counters";
    private static final String TASK_MESSAGE_TAG = "Task message";
    private static final String TASK_DESCRIPTION_TAG = "Task description";
    private static final String TASK_COMMAND_LINE_TAG = "Task command line";
    private static final String TASK_NAME_TAG = "Task name";
    private static final String TASK_ID_TAG = "Task id";
    private static final String TASKS_TAG = "Tasks";
    private static final String COUNTERS_TAG = "Counters";
    private static final String STEP_PARAMETERS_TAG = "Step parameters";
    private static final String STEP_MESSAGE_TAG = "Step message";
    private static final String SUCCESS_TAG = "Success";
    private static final String START_TIME_TAG = "Start time";
    private static final String END_TIME_TAG = "End time";
    private static final String DURATION_TAG = "Duration";
    private static final String DURATION_IN_MILLISECONDS_TAG = "Duration in milliseconds";
    private static final String STEP_VERSION_TAG = "Step version";
    private static final String STEP_CLASS_TAG = "Step class";
    private static final String STEP_NAME_TAG = "Step name";
    private static final String STEP_ID_TAG = "Step id";
    private static final String JOB_ENVIRONMENT_TAG = "Job environment";
    private static final String JOB_DESCRIPTION_TAG = "Job description";
    private static final String JOB_UUID_TAG = "Job UUID";
    private static final String JOB_ID_TAG = "Job id";
    private static final String EXCEPTION_MESSAGE_TAG = "Exception message";
    private static final String EXCEPTION_TAG = "Exception";
    private String jobId;
    private String jobUUID;
    private String jobDescription;
    private String jobEnvironment;
    private String stepId;
    private String stepName;
    private String stepClass;
    private Version stepVersion;
    private Date startTime;
    private Date endTime;
    private long duration;
    private Set<Parameter> parameters;
    private final Map<Integer, String> taskNames = new HashMap<Integer, String>();
    private final Map<Integer, Map<String, Long>> taskCounters = new HashMap<Integer, Map<String, Long>>();
    private final Map<String, Map<String, Long>> counters = new HashMap<String, Map<String, Long>>();
    private final Map<Integer, String> taskDescriptions = new HashMap<Integer, String>();
    private final Map<Integer, String> taskMessages = new HashMap<Integer, String>();
    private final Map<Integer, String> taskCommandLines = new HashMap<Integer, String>();
    private final Map<String, Long> stepCounters = new HashMap<String, Long>();
    private String stepMessage;
    private boolean success = true;
    private Throwable exception;
    private String errorMessage;
    private boolean immutable;
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());

    public String getStepMessage() {
        return this.stepMessage;
    }

    public Map<String, Long> getStepCounters() {
        return Collections.unmodifiableMap(this.stepCounters);
    }

    public String getContextMessage(int contextId) {
        return this.taskMessages.get(contextId);
    }

    public Map<String, Long> getContextCounters(int contextId) {
        Map<String, Long> result = this.taskCounters.get(contextId);
        return Collections.unmodifiableMap(result);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setImmutable() {
        this.checkImmutableState();
        Preconditions.checkState((!this.taskNames.isEmpty() ? 1 : 0) != 0, (Object)("No context result has been added for step " + this.stepId));
        this.immutable = true;
    }

    public void addResult(TaskContextImpl context, TaskResultImpl result) {
        Objects.requireNonNull(context, "result cannot be null");
        Objects.requireNonNull(result, "result cannot be null");
        this.checkImmutableState();
        int contextId = context.getId();
        Preconditions.checkState((!this.taskNames.containsKey(contextId) ? 1 : 0) != 0, (Object)("Context #" + contextId + " has already been added to result of step " + this.stepId));
        if (this.taskNames.isEmpty()) {
            this.startTime = result.getStartTime();
            this.endTime = result.getEndTime();
        } else {
            if (result.getStartTime().before(this.startTime)) {
                this.startTime = result.getStartTime();
            }
            if (result.getEndTime().after(this.endTime)) {
                this.endTime = result.getEndTime();
            }
        }
        this.duration = this.endTime.getTime() - this.startTime.getTime();
        String taskName = context.getContextName();
        this.taskNames.put(contextId, taskName);
        this.taskCounters.put(contextId, result.getCounters());
        this.taskDescriptions.put(contextId, result.getDescription());
        this.taskCommandLines.put(contextId, result.getCommandLine());
        this.addCounters(taskName, result.getCounters());
        if (this.success && !result.isSuccess()) {
            this.success = false;
            this.errorMessage = result.getErrorMessage();
            if (this.exception == null && result.getException() != null) {
                this.exception = result.getException();
            }
            WorkflowEventBus.getInstance().postStepStateChange(context.getStep(), Step.StepState.FAILED);
        }
    }

    private void addCounters(String counterGroup, Map<String, Long> counters) {
        Map<Object, Object> map;
        if (!this.counters.containsKey(counterGroup)) {
            map = new LinkedHashMap();
            this.counters.put(counterGroup, map);
        } else {
            map = this.counters.get(counterGroup);
        }
        for (Map.Entry<String, Long> e : counters.entrySet()) {
            String key = e.getKey();
            if (map.containsKey(key)) {
                map.put(key, (Long)map.get(key) + e.getValue());
                continue;
            }
            map.put(key, e.getValue());
        }
    }

    private void checkImmutableState() {
        Preconditions.checkState((!this.immutable ? 1 : 0) != 0, (Object)("Step result has been already created for step " + this.stepId));
    }

    public String toJSON() {
        StringWriter writer = new StringWriter();
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        JsonGenerator jg = jgf.createGenerator((Writer)writer);
        jg.writeStartObject();
        jg.write(JOB_ID_TAG, this.jobId);
        jg.write(JOB_UUID_TAG, this.jobUUID);
        jg.write(JOB_DESCRIPTION_TAG, this.jobDescription);
        jg.write(JOB_ENVIRONMENT_TAG, this.jobEnvironment);
        jg.write(STEP_ID_TAG, this.stepId);
        jg.write(STEP_NAME_TAG, this.stepName);
        jg.write(STEP_CLASS_TAG, this.stepClass);
        jg.write(STEP_VERSION_TAG, this.stepVersion == null ? null : this.stepVersion.toString());
        jg.write(START_TIME_TAG, this.dateFormat.format(this.startTime));
        jg.write(END_TIME_TAG, this.dateFormat.format(this.endTime));
        jg.write(DURATION_TAG, StringUtils.toTimeHumanReadable((long)this.duration));
        jg.write(DURATION_IN_MILLISECONDS_TAG, this.duration);
        jg.write(SUCCESS_TAG, this.success);
        jg.write(STEP_MESSAGE_TAG, Strings.nullToEmpty((String)this.stepMessage));
        if (!this.success) {
            jg.write(EXCEPTION_TAG, this.exception == null ? "" : this.exception.getClass().getSimpleName());
            jg.write(EXCEPTION_MESSAGE_TAG);
        }
        jg.writeStartObject(STEP_PARAMETERS_TAG);
        for (Parameter parameter : this.parameters) {
            jg.write(parameter.getName(), parameter.getStringValue());
        }
        jg.writeEnd();
        jg.writeStartObject(COUNTERS_TAG);
        for (Map.Entry entry : this.counters.entrySet()) {
            jg.writeStartObject((String)entry.getKey());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                jg.write((String)entry2.getKey(), ((Long)entry2.getValue()).longValue());
            }
            jg.writeEnd();
        }
        jg.writeEnd();
        jg.writeStartArray(TASKS_TAG);
        Iterator<Object> iterator = this.taskNames.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!this.taskCounters.containsKey(n) && !this.taskMessages.containsKey(n)) continue;
            jg.writeStartObject();
            jg.write(TASK_ID_TAG, n);
            jg.write(TASK_NAME_TAG, this.taskNames.get(n));
            jg.write(TASK_DESCRIPTION_TAG, Strings.nullToEmpty((String)this.taskDescriptions.get(n)));
            jg.write(TASK_MESSAGE_TAG, Strings.nullToEmpty((String)this.taskMessages.get(n)));
            jg.write(TASK_COMMAND_LINE_TAG, Strings.nullToEmpty((String)this.taskCommandLines.get(n)));
            jg.writeStartObject(TASK_COUNTERS_TAG);
            for (Map.Entry<Object, Object> entry : this.taskCounters.get(n).entrySet()) {
                jg.write((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            jg.writeEnd();
            jg.writeEnd();
        }
        jg.writeEnd();
        jg.writeEnd();
        jg.close();
        return writer.toString();
    }

    public String toEoulsanLogV1() {
        StringBuilder sb = new StringBuilder();
        sb.append("Job Id: ");
        sb.append(this.jobId);
        sb.append(" [");
        sb.append(this.jobUUID);
        sb.append(']');
        sb.append("\nJob description: ");
        sb.append(this.jobDescription);
        sb.append("\nJob environment: ");
        sb.append(this.jobEnvironment);
        sb.append("\nStep: ");
        sb.append(this.stepId);
        sb.append(" [");
        sb.append(this.stepClass);
        sb.append("]");
        sb.append("\nParameters:\n");
        ArrayList parametersList = Lists.newArrayList(this.parameters);
        parametersList.sort(Comparator.comparing(Parameter::getName));
        for (Parameter p : parametersList) {
            sb.append('\t');
            sb.append(p.getName());
            sb.append(": ");
            sb.append(p.getStringValue());
            sb.append('\n');
        }
        sb.append("Start time: ");
        sb.append(this.startTime);
        sb.append("\nEnd time: ");
        sb.append(this.endTime);
        sb.append("\nDuration: ");
        sb.append(StringUtils.toTimeHumanReadable((long)this.duration));
        sb.append('\n');
        Iterator<Object> iterator = this.taskNames.keySet().iterator();
        while (iterator.hasNext()) {
            int contextId = (Integer)iterator.next();
            sb.append(this.taskDescriptions.get(contextId));
            sb.append('\n');
            if (!this.taskCounters.containsKey(contextId)) continue;
            for (Map.Entry<String, Long> counter : this.taskCounters.get(contextId).entrySet()) {
                sb.append('\t');
                sb.append(counter.getKey());
                sb.append('=');
                sb.append(counter.getValue());
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public void read(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file is null");
        this.read(file.open());
    }

    public void read(InputStream in) {
        Objects.requireNonNull(in);
        this.checkImmutableState();
        JsonReader reader = Json.createReader((Reader)new InputStreamReader(in));
        JsonObject obj = reader.readObject();
        this.jobId = obj.getString(JOB_ID_TAG);
        this.jobUUID = obj.getString(JOB_UUID_TAG);
        this.jobDescription = obj.getString(JOB_DESCRIPTION_TAG);
        this.jobEnvironment = obj.getString(JOB_ENVIRONMENT_TAG);
        this.stepId = obj.getString(STEP_ID_TAG);
        this.stepName = obj.getString(STEP_NAME_TAG);
        this.stepClass = obj.getString(STEP_CLASS_TAG);
        this.stepVersion = new Version(obj.getString(STEP_VERSION_TAG));
        this.startTime = this.parseDate(obj.getString(START_TIME_TAG));
        this.endTime = this.parseDate(obj.getString(END_TIME_TAG));
        this.duration = obj.getInt(DURATION_IN_MILLISECONDS_TAG);
        this.success = obj.getBoolean(SUCCESS_TAG);
        this.stepMessage = obj.getString(STEP_MESSAGE_TAG);
        this.parameters = new LinkedHashSet<Parameter>();
        JsonObject parametersObj = obj.getJsonObject(STEP_PARAMETERS_TAG);
        for (Object key : parametersObj.keySet()) {
            this.parameters.add(new Parameter((String)key, parametersObj.getString((String)key)));
        }
        JsonObject countersObj = obj.getJsonObject(COUNTERS_TAG);
        for (String group : countersObj.keySet()) {
            if (!this.counters.containsKey(group)) {
                this.counters.put(group, new HashMap());
            }
            Map<String, Long> map = this.counters.get(group);
            JsonObject groupObj = countersObj.getJsonObject(group);
            for (String counterName : groupObj.keySet()) {
                map.put(counterName, groupObj.getJsonNumber(counterName).longValue());
            }
        }
        JsonArray tasksArray = obj.getJsonArray(TASKS_TAG);
        for (JsonValue entry : tasksArray) {
            JsonObject entryObj = (JsonObject)entry;
            int taskId = entryObj.getInt(TASK_ID_TAG);
            this.taskNames.put(taskId, entryObj.getString(TASK_NAME_TAG));
            this.taskDescriptions.put(taskId, entryObj.getString(TASK_DESCRIPTION_TAG));
            this.taskMessages.put(taskId, entryObj.getString(TASK_MESSAGE_TAG));
            HashMap<String, Long> map = new HashMap<String, Long>();
            this.taskCounters.put(taskId, map);
            JsonObject taskCountersObj = entryObj.getJsonObject(TASK_COUNTERS_TAG);
            for (String counterName : taskCountersObj.keySet()) {
                map.put(counterName, taskCountersObj.getJsonNumber(counterName).longValue());
            }
        }
    }

    public void write(DataFile file, boolean oldFormat) throws IOException {
        Objects.requireNonNull(file, "file is null");
        this.write(file.create(), oldFormat);
    }

    public void write(OutputStream out, boolean oldFormat) throws IOException {
        Objects.requireNonNull(out, "output stream is null");
        Preconditions.checkState((boolean)this.immutable, (Object)"Cannot write non immutable object");
        BufferedWriter writer = FileUtils.createBufferedWriter((OutputStream)out);
        if (oldFormat) {
            writer.write(this.toEoulsanLogV1());
        } else {
            writer.write(this.toJSON());
        }
        writer.close();
    }

    private Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    StepResult() {
    }

    public StepResult(AbstractStep step) {
        Objects.requireNonNull(step, "step is null");
        WorkflowContext workflowContext = step.getAbstractWorkflow().getWorkflowContext();
        this.jobId = workflowContext.getJobId();
        this.jobUUID = workflowContext.getJobUUID();
        this.jobDescription = workflowContext.getJobDescription();
        this.jobEnvironment = workflowContext.getJobEnvironment();
        this.stepId = step.getId();
        this.stepName = step.getModuleName();
        this.stepClass = step.getModule() == null ? null : step.getModule().getClass().getName();
        this.stepVersion = step.getModule() == null ? null : step.getModule().getVersion();
        this.parameters = step.getParameters();
    }
}

