/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.core.InputPort;
import fr.ens.biologie.genomique.eoulsan.core.OutputPort;
import fr.ens.biologie.genomique.eoulsan.core.Port;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.Workflow;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractData;
import fr.ens.biologie.genomique.eoulsan.core.workflow.AbstractStep;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataUtils;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepInputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.StepOutputPort;
import fr.ens.biologie.genomique.eoulsan.core.workflow.UnmodifiableData;
import fr.ens.biologie.genomique.eoulsan.core.workflow.WorkflowContext;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.util.ClassLoaderObjectInputStream;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class TaskContextImpl
implements TaskContext,
Serializable {
    private static final long serialVersionUID = 8288158811122533646L;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private final int id;
    private final WorkflowContext workflowContext;
    private String contextName;
    private final AbstractStep step;
    private final Map<String, Data> inputData = new HashMap<String, Data>();
    private final Map<String, AbstractData> outputData = new HashMap<String, AbstractData>();

    public int getId() {
        return this.id;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    public DataFile getLocalWorkingPathname() {
        return this.workflowContext.getLocalWorkingDirectory();
    }

    public DataFile getHadoopWorkingPathname() {
        return this.workflowContext.getHadoopWorkingDirectory();
    }

    @Override
    public DataFile getJobDirectory() {
        return this.workflowContext.getJobDirectory();
    }

    public DataFile getTaskOutputDirectory() {
        return this.workflowContext.getTaskDirectory();
    }

    public DataFile getDataRepositoryDirectory() {
        return this.workflowContext.getDataRepositoryDirectory();
    }

    @Override
    public DataFile getOutputDirectory() {
        return this.workflowContext.getOutputDirectory();
    }

    @Override
    public DataFile getStepOutputDirectory() {
        return this.step.getStepOutputDirectory();
    }

    @Override
    public String getJobId() {
        return this.workflowContext.getJobId();
    }

    @Override
    public String getJobHost() {
        return this.workflowContext.getJobHost();
    }

    @Override
    public long getContextCreationTime() {
        return this.workflowContext.getContextCreationTime();
    }

    @Override
    public DataFile getDesignFile() {
        return this.workflowContext.getDesignFile();
    }

    @Override
    public DataFile getWorkflowFile() {
        return this.workflowContext.getWorkflowFile();
    }

    public DataFile getJarPathname() {
        return this.workflowContext.getJarFile();
    }

    @Override
    public String getJobUUID() {
        return this.workflowContext.getJobUUID();
    }

    @Override
    public String getJobDescription() {
        return this.workflowContext.getJobDescription();
    }

    @Override
    public String getJobEnvironment() {
        return this.workflowContext.getJobEnvironment();
    }

    @Override
    public String getCommandName() {
        return this.workflowContext.getCommandName();
    }

    @Override
    public String getCommandDescription() {
        return this.workflowContext.getCommandDescription();
    }

    @Override
    public String getCommandAuthor() {
        return this.workflowContext.getCommandAuthor();
    }

    @Override
    public Workflow getWorkflow() {
        return this.workflowContext.getWorkflow();
    }

    @Override
    public Step getCurrentStep() {
        return this.step;
    }

    AbstractStep getStep() {
        return this.step;
    }

    @Override
    public void setContextName(String contextName) {
        Objects.requireNonNull(contextName, "contextName argument cannot be null");
        this.contextName = contextName.trim();
    }

    @Override
    public AbstractEoulsanRuntime getRuntime() {
        return this.workflowContext.getRuntime();
    }

    @Override
    public Settings getSettings() {
        return this.workflowContext.getSettings();
    }

    @Override
    public Logger getLogger() {
        return this.workflowContext.getLogger();
    }

    @Override
    public GenericLogger getGenericLogger() {
        return EoulsanLogger.getGenericLogger();
    }

    @Override
    public Data getInputData(String portName) {
        Objects.requireNonNull(portName, "portName cannot be null");
        Preconditions.checkArgument((boolean)this.inputData.containsKey(portName), (Object)("unknown input port name: " + portName));
        return new UnmodifiableData(this.inputData.get(portName));
    }

    @Override
    public Data getInputData(DataFormat format) {
        return this.getInputData(this.getInputPortNameForFormat(format));
    }

    @Override
    public Data getOutputData(String portName, String dataName) {
        return this.getOutputData(portName, dataName, -1);
    }

    @Override
    public Data getOutputData(String portName, String dataName, int part) {
        Objects.requireNonNull(portName, "portName cannot be null");
        Preconditions.checkArgument((boolean)this.outputData.containsKey(portName), (Object)("unknown output port name: " + portName));
        AbstractData data = this.outputData.get(portName);
        data.setName(dataName, true);
        data.setPart(part);
        return data;
    }

    @Override
    public Data getOutputData(String portName, Data origin) {
        Objects.requireNonNull(origin, "origin cannot be null");
        Objects.requireNonNull(portName, "portName cannot be null");
        Preconditions.checkArgument((boolean)this.outputData.containsKey(portName), (Object)("unknown output port name: " + portName));
        AbstractData result = this.outputData.get(portName);
        AbstractData oriData = origin instanceof UnmodifiableData ? ((UnmodifiableData)origin).getData() : (AbstractData)origin;
        result.setName(oriData.getName(), oriData.isDefaultName());
        result.setPart(oriData.getPart());
        if (!result.isList() && !origin.isList()) {
            result.getMetadata().set(origin.getMetadata());
        }
        return result;
    }

    @Override
    public Data getOutputData(DataFormat format, String dataName) {
        return this.getOutputData(format, dataName, -1);
    }

    @Override
    public Data getOutputData(DataFormat format, String dataName, int part) {
        return this.getOutputData(this.getOutputPortNameForFormat(format), dataName);
    }

    @Override
    public Data getOutputData(DataFormat format, Data origin) {
        return this.getOutputData(this.getOutputPortNameForFormat(format), origin);
    }

    private void updateOutputData(Map<String, AbstractData> data) {
        Objects.requireNonNull(data, "data argument cannot be null");
        Preconditions.checkArgument((data.size() == this.outputData.size() ? 1 : 0) != 0, (Object)("Unexpected number of output data (" + this.outputData.size() + " was expected): " + data.size()));
        for (Map.Entry<String, AbstractData> e : data.entrySet()) {
            Preconditions.checkArgument((boolean)this.outputData.containsKey(e.getKey()), (Object)("Unknown port: " + e.getKey()));
            this.outputData.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public File getLocalTempDirectory() {
        return EoulsanRuntime.getRuntime().getTempDirectory();
    }

    public String getTaskFilePrefix() {
        return this.getStep().getId() + "_context#" + this.getId();
    }

    public Data getInputData(InputPort port) {
        Objects.requireNonNull(port, "port cannot be null");
        if (!this.inputData.containsKey(port.getName())) {
            throw new EoulsanRuntimeException("Unknown port: " + port.getName() + " for step " + this.step.getId());
        }
        return this.inputData.get(port.getName());
    }

    Data getOutputData(OutputPort port) {
        Objects.requireNonNull(port, "port cannot be null");
        if (!this.outputData.containsKey(port.getName())) {
            throw new EoulsanRuntimeException("Unknown port: " + port.getName() + " for step " + this.step.getId());
        }
        return this.outputData.get(port.getName());
    }

    AbstractStep getWorkflowStep() {
        return this.step;
    }

    private String getInputPortNameForFormat(DataFormat format) {
        Objects.requireNonNull(format, "The format is null");
        List ports = this.step.getWorkflowInputPorts().getPortsWithDataFormat(format);
        switch (ports.size()) {
            case 0: {
                throw new EoulsanRuntimeException("The step " + this.step.getId() + " do not provide an input port with format: " + format.getName());
            }
            case 1: {
                return ((StepInputPort)ports.get(0)).getName();
            }
        }
        throw new EoulsanRuntimeException("The step " + this.step.getId() + " provide more than one input port with format: " + format.getName());
    }

    private String getOutputPortNameForFormat(DataFormat format) {
        Objects.requireNonNull(format, "The format is null");
        List ports = this.step.getWorkflowOutputPorts().getPortsWithDataFormat(format);
        switch (ports.size()) {
            case 0: {
                throw new EoulsanRuntimeException("The step " + this.step.getId() + " do not provide an output port with format: " + format.getName());
            }
            case 1: {
                return ((StepOutputPort)ports.get(0)).getName();
            }
        }
        throw new EoulsanRuntimeException("The step " + this.step.getId() + " provide more than one output port with format: " + format.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("step", (Object)this.step.getId()).add("contextName", (Object)this.contextName).toString();
    }

    public void serialize(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        try (FileOutputStream out = new FileOutputStream(file);){
            this.serialize(out);
        }
    }

    public void serialize(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        try (OutputStream out = file.create();){
            this.serialize(out);
        }
    }

    public void serialize(OutputStream out) throws IOException {
        Objects.requireNonNull(out, "out argument cannot be null");
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(this);
            oos.writeObject(EoulsanRuntime.getSettings());
        }
    }

    public static TaskContextImpl deserialize(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        try (FileInputStream in = new FileInputStream(file);){
            TaskContextImpl taskContextImpl = TaskContextImpl.deserialize(in);
            return taskContextImpl;
        }
    }

    public static TaskContextImpl deserialize(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        try (InputStream in = file.open();){
            TaskContextImpl taskContextImpl = TaskContextImpl.deserialize(in);
            return taskContextImpl;
        }
    }

    public static TaskContextImpl deserialize(InputStream in) throws IOException {
        TaskContextImpl taskContextImpl;
        Objects.requireNonNull(in, "in argument cannot be null");
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(in);
        try {
            TaskContextImpl result = (TaskContextImpl)ois.readObject();
            Settings settings = (Settings)ois.readObject();
            EoulsanRuntime.getSettings().setSettings(settings);
            taskContextImpl = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new EoulsanRuntimeException(e);
            }
        }
        ois.close();
        return taskContextImpl;
    }

    public void serializeOutputData(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.serializeOutputData(new FileOutputStream(file));
    }

    public void serializeOutputData(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.serializeOutputData(file.create());
    }

    public void serializeOutputData(OutputStream out) throws IOException {
        Objects.requireNonNull(out, "out argument cannot be null");
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(this.outputData);
        oos.close();
    }

    public void deserializeOutputData(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.deserializeOutputData(file.open());
    }

    public void deserializeOutputData(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.deserializeOutputData(new FileInputStream(file));
    }

    public void deserializeOutputData(InputStream in) throws IOException {
        Objects.requireNonNull(in, "in argument cannot be null");
        try {
            ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(in);
            Map outputData = (Map)ois.readObject();
            ois.close();
            this.updateOutputData(outputData);
        }
        catch (ClassNotFoundException e) {
            throw new EoulsanRuntimeException(e);
        }
    }

    TaskContextImpl(WorkflowContext workflowContext, AbstractStep step, Map<InputPort, Data> inputData, Map<OutputPort, AbstractData> outputData) {
        Objects.requireNonNull(workflowContext, "workflow context cannot be null");
        Objects.requireNonNull(step, "step cannot be null");
        this.id = instanceCount.incrementAndGet();
        this.contextName = "context" + this.id;
        this.workflowContext = workflowContext;
        this.step = step;
        for (Map.Entry<InputPort, Data> entry : inputData.entrySet()) {
            this.inputData.put(entry.getKey().getName(), DataUtils.copy((AbstractData)entry.getValue()));
        }
        for (Map.Entry<Port, Data> entry : outputData.entrySet()) {
            this.outputData.put(((OutputPort)entry.getKey()).getName(), (AbstractData)entry.getValue());
        }
    }
}

