/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core.workflow;

import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskContextImpl;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.util.ClassLoaderObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TaskResultImpl
implements TaskResult,
Serializable {
    private static final long serialVersionUID = -1698693204391020077L;
    private final TaskContextImpl context;
    private final Date startTime;
    private final Date endTime;
    private final long duration;
    private final boolean success;
    private final Throwable exception;
    private final String errorMessage;
    private final Map<String, Long> counters = new HashMap<String, Long>();
    private final String taskMessage;
    private final String taskDescription;
    private final String taskCommandLine;

    TaskContextImpl getContext() {
        return this.context;
    }

    Date getStartTime() {
        return this.startTime;
    }

    Date getEndTime() {
        return this.endTime;
    }

    Map<String, Long> getCounters() {
        return Collections.unmodifiableMap(this.counters);
    }

    String getDescription() {
        return this.taskDescription;
    }

    String getCommandLine() {
        return this.taskCommandLine;
    }

    String getMessage() {
        return this.taskMessage;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void serialize(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.serialize(new FileOutputStream(file));
    }

    public void serialize(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.serialize(file.create());
    }

    public final void serialize(OutputStream out) throws IOException {
        Objects.requireNonNull(out, "out argument cannot be null");
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(this);
        oos.close();
    }

    public static TaskResultImpl deserialize(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        return TaskResultImpl.deserialize(new FileInputStream(file));
    }

    public static TaskResultImpl deserialize(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        return TaskResultImpl.deserialize(file.open());
    }

    public static TaskResultImpl deserialize(InputStream in) throws IOException {
        TaskResultImpl taskResultImpl;
        Objects.requireNonNull(in, "in argument cannot be null");
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(in);
        try {
            taskResultImpl = (TaskResultImpl)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new EoulsanRuntimeException(e);
            }
        }
        ois.close();
        return taskResultImpl;
    }

    TaskResultImpl(TaskContextImpl context, Date startTime, Date endTime, long duration, String contextMessage, String contextDescription, String contextCommandLine, Map<String, Long> counters, boolean success) {
        Objects.requireNonNull(context, "context argument cannot be null");
        Objects.requireNonNull(startTime, "startTime argument cannot be null");
        Objects.requireNonNull(endTime, "endTime argument cannot be null");
        Objects.requireNonNull(contextDescription, "contextDescription argument cannot be null");
        Objects.requireNonNull(contextCommandLine, "contextCommandLine argument cannot be null");
        Objects.requireNonNull(counters, "counter argument cannot be null");
        this.context = context;
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.success = success;
        this.taskMessage = contextMessage;
        this.taskDescription = contextDescription;
        this.taskCommandLine = contextCommandLine;
        this.counters.putAll(counters);
        this.exception = null;
        this.errorMessage = null;
    }

    public TaskResultImpl(TaskContextImpl context, Date startTime, Date endTime, long duration, Throwable exception, String errorMessage) {
        Objects.requireNonNull(context, "context argument cannot be null");
        this.context = context;
        this.startTime = startTime == null ? null : new Date(startTime.getTime());
        this.endTime = endTime == null ? null : new Date(endTime.getTime());
        this.duration = duration;
        this.success = false;
        this.taskMessage = null;
        this.taskDescription = null;
        this.taskCommandLine = null;
        this.exception = exception;
        this.errorMessage = errorMessage;
    }
}

