/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocol;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class DataFiles {
    public static void copy(DataFile input, DataFile output) throws IOException {
        Objects.requireNonNull(input, "input file cannot be null");
        Objects.requireNonNull(output, "output file cannot be null");
        if (input.getCompressionType() == output.getCompressionType()) {
            DataFiles.rawCopy(input, output);
        } else {
            FileUtils.copy((InputStream)input.open(), (OutputStream)output.create());
        }
    }

    public static void rawCopy(DataFile input, DataFile output) throws IOException {
        Objects.requireNonNull(input, "input file cannot be null");
        Objects.requireNonNull(output, "output file cannot be null");
        FileUtils.copy((InputStream)input.rawOpen(), (OutputStream)output.rawCreate());
    }

    public static void symlinkOrCopy(DataFile input, DataFile output) throws IOException {
        DataFiles.symlinkOrCopy(input, output, false);
    }

    public static void symlinkOrCopy(DataFile input, DataFile output, boolean relativize) throws IOException {
        Objects.requireNonNull(input, "input file cannot be null");
        Objects.requireNonNull(output, "output file cannot be null");
        if (input.getCompressionType() != output.getCompressionType()) {
            DataFiles.copy(input, output);
        } else {
            DataProtocol outProtocol;
            DataProtocol inProtocol = input.getProtocol();
            if (inProtocol.equals(outProtocol = output.getProtocol()) && inProtocol.canSymlink()) {
                input.symlink(output, relativize);
            } else {
                DataFiles.copy(input, output);
            }
        }
    }
}

