/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data;

import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqWriter;
import fr.ens.biologie.genomique.kenetre.bio.io.TFQReader;
import fr.ens.biologie.genomique.kenetre.bio.io.TFQWriter;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataFormatConverter {
    private final DataFormat inFormat;
    private final DataFormat outFormat;
    final DataFile inFile;
    final DataFile outFile;
    final OutputStream os;

    public void convert() throws IOException {
        OutputStream destOs;
        if (this.outFormat == null) {
            OutputStream destOs2 = this.os == null ? this.outFile.create() : this.os;
            FileUtils.copy((InputStream)this.inFile.rawOpen(), (OutputStream)destOs2);
            return;
        }
        CompressionType srcCT = CompressionType.getCompressionTypeByContentEncoding((String)this.inFile.getMetaData().getContentEncoding());
        CompressionType destCT = CompressionType.getCompressionTypeByFilename((String)this.outFile.getName());
        EoulsanLogger.getLogger().fine("Convert " + this.inFile + " (" + this.inFormat + "/" + srcCT + ") to " + this.outFile + " (" + this.outFormat + "/" + destCT + ").");
        if (this.inFormat.equals(this.outFormat) && srcCT.equals((Object)destCT)) {
            this.inFile.copyTo(this.outFile);
            return;
        }
        OutputStream outputStream = destOs = this.os == null ? this.outFile.create() : this.os;
        if (this.inFormat.equals(this.outFormat)) {
            InputStream is = this.inFile.open();
            OutputStream os = destCT.createOutputStream(destOs);
            FileUtils.copy((InputStream)is, (OutputStream)os);
            return;
        }
        if (!(this.inFormat != DataFormats.READS_FASTQ && this.inFormat != DataFormats.READS_TFQ || this.outFormat != DataFormats.READS_FASTQ && this.outFormat != DataFormats.READS_TFQ)) {
            Object reader = this.inFormat == DataFormats.READS_FASTQ ? new FastqReader(this.inFile.open()) : new TFQReader(this.inFile.open());
            OutputStream os = destCT.createOutputStream(destOs);
            Object writer = this.outFormat == DataFormats.READS_FASTQ ? new FastqWriter(os) : new TFQWriter(os);
            try {
                for (ReadSequence read : reader) {
                    writer.write(read);
                }
                reader.throwException();
            }
            catch (BadBioEntryException e) {
                throw new IOException("Bad read sequence entry: " + e.getEntry());
            }
            finally {
                reader.close();
                writer.close();
            }
            return;
        }
        destOs.close();
        throw new IOException("This copy case is not implemented");
    }

    public DataFormatConverter(DataFile inFile, DataFile outFile, OutputStream os) throws IOException {
        this(inFile, outFile, outFile == null ? null : DataFormatRegistry.getInstance().getDataFormatFromFilename(outFile.getName()), os);
    }

    public DataFormatConverter(DataFile inFile, DataFile outFile) throws IOException {
        this(inFile, outFile, null);
    }

    public DataFormatConverter(DataFile inFile, DataFile outFile, DataFormat outFormat, OutputStream os) throws IOException {
        if (inFile == null) {
            throw new NullPointerException("The input file is null");
        }
        this.inFile = inFile;
        this.inFormat = inFile.getMetaData().getDataFormat();
        if (this.inFormat == null && outFormat != null) {
            throw new NullPointerException("The input file format is null");
        }
        if (outFile == null) {
            throw new NullPointerException("The output file format is null");
        }
        this.outFile = outFile;
        this.outFormat = outFormat;
        this.os = os;
    }
}

