/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.XMLDataFormat;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.util.ClassPathResourceLoader;
import fr.ens.biologie.genomique.eoulsan.util.FileResourceLoader;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;

public class DataFormatRegistry {
    private static final String RESOURCE_PREFIX = "META-INF/services/xmldataformats/";
    private static final String FORMAT_SUBDIR = "formats";
    private final Set<DataFormat> formats = new HashSet<DataFormat>();
    private final Map<String, DataFormat> mapFormats = new HashMap<String, DataFormat>();
    private boolean xmlServicesCurrentlyLoading;
    private final Map<String, DataFormat> mapDesignMetadataKeyDataFormat = new HashMap<String, DataFormat>();
    private final Map<String, DataFormat> mapSampleMetadataKeyDataFormat = new HashMap<String, DataFormat>();
    private static DataFormatRegistry instance;

    public void register(DataFormat df) throws EoulsanException {
        this.register(df, false);
    }

    private void register(DataFormat df, boolean callFromConstructor) throws EoulsanException {
        if (df == null || this.formats.contains(df)) {
            return;
        }
        this.check(df, callFromConstructor);
        for (String suffix : df.getExtensions()) {
            String prefix = df.getPrefix();
            String key = prefix + "\t" + suffix;
            this.formats.add(df);
            this.mapFormats.put(key, df);
        }
    }

    public void register(DataFormat[] array) throws EoulsanException {
        if (array == null) {
            return;
        }
        for (DataFormat df : array) {
            this.register(df);
        }
    }

    private void check(DataFormat df, boolean callFromConstructor) throws EoulsanException {
        if (df.getName() == null) {
            throw new EoulsanException("The DataFormat " + df.getClass().getName() + " as no name.");
        }
        if (!df.getName().toLowerCase().trim().equals(df.getName())) {
            throw new EoulsanException("The DataFormat name can't contains upper case character" + df.getClass().getName() + " as no name.");
        }
        for (DataFormat format : this.formats) {
            if (!format.getName().equals(df.getName())) continue;
            throw new EoulsanException("A DataFormat named " + df.getName() + " is already registered.");
        }
        String prefix = df.getPrefix();
        if (prefix == null || "".equals(prefix)) {
            throw new EoulsanException("The prefix of a DataFormat can't be null or empty (" + df.getName() + ")");
        }
        if (prefix.indexOf(9) != -1) {
            throw new EoulsanException("The prefix of a DataFormat can't contains tab character: " + prefix);
        }
        List<String> extensions = df.getExtensions();
        if (extensions == null || extensions.size() == 0) {
            throw new EoulsanException("The extensions of a DataFormat can't be null or empty.");
        }
        if (df.getDefaultExtension() == null) {
            throw new EoulsanException("The no default extension is provided for DataFormat: " + df.getName());
        }
        boolean defaultExtensionFound = false;
        for (String suffix : df.getExtensions()) {
            String key;
            if (suffix == null) {
                throw new EoulsanException("The extension of a DataFormat can't be null");
            }
            if (suffix.indexOf(9) != -1) {
                throw new EoulsanException("The extension of a DataFormat can't contains tab character: " + suffix);
            }
            if (suffix.equals(df.getDefaultExtension())) {
                defaultExtensionFound = true;
            }
            if (this.mapFormats.containsKey(key = prefix + "\t" + suffix)) {
                throw new EoulsanException("The DataFormat registry already contains entry for prefix \"" + prefix + "\" and extension \"" + suffix + "\"");
            }
            if (!callFromConstructor) {
                throw new EoulsanException("This DataFormat " + df.getName() + " is not registered as a spi service. Cannot register it.");
            }
            if (df.getSampleMetadataKeyName() != null) {
                this.mapSampleMetadataKeyDataFormat.put(df.getSampleMetadataKeyName(), df);
            }
            if (df.getDesignMetadataKeyName() != null) {
                this.mapDesignMetadataKeyDataFormat.put(df.getDesignMetadataKeyName(), df);
            }
            this.formats.add(df);
            this.mapFormats.put(key, df);
        }
        if (!defaultExtensionFound) {
            throw new EoulsanException("The default extension of DataFormat \"" + df.getName() + "\" is not in the list of extensions.");
        }
    }

    public DataFormat getDataFormatFromFilename(String prefix, String extension) {
        if (prefix == null) {
            throw new NullPointerException("The prefix is null");
        }
        if (extension == null) {
            throw new NullPointerException("The extension is null");
        }
        String key = prefix + "\t" + extension;
        return this.mapFormats.get(key);
    }

    public DataFormat getDataFormatFromFilename(String filename) {
        String prefix;
        DataFormat df2;
        if (filename == null) {
            throw new NullPointerException("The filename is null");
        }
        String f = StringUtils.filenameWithoutCompressionExtension((String)filename.trim());
        int dotPos = f.lastIndexOf(46);
        if (dotPos == -1) {
            return null;
        }
        String ext = f.substring(dotPos);
        int underscorePos = f.lastIndexOf(95, dotPos);
        if (underscorePos != -1 && (df2 = this.getDataFormatFromFilename(prefix = f.substring(0, underscorePos + 1), ext)) != null) {
            return df2;
        }
        for (DataFormat df2 : this.formats) {
            if (!df2.isDataFormatFromDesignFile()) continue;
            for (String dfExt : df2.getExtensions()) {
                if (!dfExt.equals(ext)) continue;
                return df2;
            }
        }
        return null;
    }

    public DataFormat getDataFormatFromName(String dataFormatName) {
        if (dataFormatName == null) {
            return null;
        }
        for (DataFormat df : this.formats) {
            if (!df.getName().equals(dataFormatName)) continue;
            return df;
        }
        return null;
    }

    public DataFormat getDataFormatFromAlias(String dataFormatAlias) {
        if (dataFormatAlias == null) {
            return null;
        }
        for (DataFormat df : this.formats) {
            String alias = df.getAlias();
            if (!dataFormatAlias.toLowerCase().equals(alias)) continue;
            return df;
        }
        return null;
    }

    public DataFormat getDataFormatFromGalaxyFormatName(String formatName) {
        if (formatName == null || formatName.isEmpty()) {
            return null;
        }
        for (DataFormat df : this.formats) {
            for (String galaxyFormatName : df.getGalaxyFormatNames()) {
                if (!formatName.toLowerCase(Globals.DEFAULT_LOCALE).equals(galaxyFormatName)) continue;
                return df;
            }
        }
        return null;
    }

    public DataFormat getDataFormatFromNameOrAlias(String name) {
        DataFormat result = this.getDataFormatFromName(name);
        return result != null ? result : this.getDataFormatFromAlias(name);
    }

    public DataFormat getDataFormatFromGalaxyFormatNameOrNameOrAlias(String name) {
        DataFormat result = this.getDataFormatFromGalaxyFormatName(name);
        return result != null ? result : this.getDataFormatFromNameOrAlias(name);
    }

    public Set<DataFormat> getDataFormatsFromExtension(String extension) {
        if (extension == null) {
            return Collections.emptySet();
        }
        HashSet<DataFormat> result = new HashSet<DataFormat>();
        for (DataFormat df : this.formats) {
            for (String ext : df.getExtensions()) {
                if (!extension.equals(ext)) continue;
                result.add(df);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<DataFormat> getAllFormats() {
        return Collections.unmodifiableSet(this.formats);
    }

    public DataFormat getDataFormatForDesignMetadata(String key) {
        if (key == null) {
            return null;
        }
        return this.mapDesignMetadataKeyDataFormat.get(key);
    }

    public DataFormat getDataFormatForSampleMetadata(String key) {
        if (key == null) {
            return null;
        }
        return this.mapSampleMetadataKeyDataFormat.get(key);
    }

    public String getDesignMetadataKeyForDataFormat(Design design, DataFormat dataformat) {
        if (design == null || dataformat == null) {
            return null;
        }
        for (String fieldname : design.getMetadata().keySet()) {
            DataFormat df = this.getDataFormatForDesignMetadata(fieldname);
            if (!dataformat.equals(df)) continue;
            return fieldname;
        }
        return null;
    }

    public String getSampleMetadataKeyForDataFormat(Sample sample, DataFormat dataformat) {
        if (sample == null || dataformat == null) {
            return null;
        }
        for (String fieldname : sample.getMetadata().keySet()) {
            DataFormat df = this.getDataFormatForSampleMetadata(fieldname);
            if (!dataformat.equals(df)) continue;
            return fieldname;
        }
        return null;
    }

    private void registerAllClassServices() {
        Iterator<DataFormat> it = ServiceLoader.load(DataFormat.class).iterator();
        for (DataFormat df : Utils.newIterable(it)) {
            try {
                EoulsanLogger.getLogger().fine("try to register format: " + df);
                this.register(df, true);
            }
            catch (EoulsanException e) {
                EoulsanLogger.getLogger().warning("Cannot register " + df.getName() + ": " + e.getMessage());
            }
        }
    }

    private void registerAllXMLServices() {
        try {
            DataFormatClassPathLoader formatClassLoader = new DataFormatClassPathLoader();
            formatClassLoader.reload();
            ArrayList formats = new ArrayList(formatClassLoader.loadAllResources());
            DataFormatFileResourceLoader formatFileLoader = new DataFormatFileResourceLoader(EoulsanRuntime.getSettings().getDataFormatPaths());
            formatFileLoader.reload();
            formats.addAll(formatFileLoader.loadAllResources());
            for (DataFormat format : formats) {
                this.register(format, true);
            }
        }
        catch (EoulsanException e) {
            EoulsanLogger.getLogger().severe("Cannot register XML data format: " + e.getMessage());
        }
    }

    public void reload() {
        this.registerAllClassServices();
        if (!this.xmlServicesCurrentlyLoading) {
            this.xmlServicesCurrentlyLoading = true;
            this.registerAllXMLServices();
            this.xmlServicesCurrentlyLoading = false;
        }
    }

    public static synchronized DataFormatRegistry getInstance() {
        if (instance == null) {
            instance = new DataFormatRegistry();
            instance.reload();
        }
        return instance;
    }

    private DataFormatRegistry() {
    }

    private static final class DataFormatClassPathLoader
    extends ClassPathResourceLoader<XMLDataFormat> {
        @Override
        protected String getResourceName(XMLDataFormat resource) {
            Objects.requireNonNull(resource, "resource argument cannot be null");
            return resource.getName();
        }

        @Override
        protected XMLDataFormat load(InputStream in, String source) throws IOException, EoulsanException {
            if (in == null) {
                throw new NullPointerException("The input stream of the XML DataFormat source is null: " + source);
            }
            return new XMLDataFormat(in, source);
        }

        public DataFormatClassPathLoader() {
            super(XMLDataFormat.class, DataFormatRegistry.RESOURCE_PREFIX);
        }
    }

    private static final class DataFormatFileResourceLoader
    extends FileResourceLoader<XMLDataFormat> {
        @Override
        protected String getExtension() {
            return ".xml";
        }

        @Override
        protected String getResourceName(XMLDataFormat resource) {
            Objects.requireNonNull(resource, "resource argument cannot be null");
            return resource.getName();
        }

        @Override
        protected XMLDataFormat load(InputStream in, String source) throws IOException, EoulsanException {
            return new XMLDataFormat(in, source);
        }

        private static DataFile getDefaultFormatDirectory() {
            Main main = Main.getInstance();
            if (main == null) {
                return new DataFile(DataFormatRegistry.FORMAT_SUBDIR);
            }
            return new DataFile(new File(main.getEoulsanDirectory(), DataFormatRegistry.FORMAT_SUBDIR));
        }

        public DataFormatFileResourceLoader(List<String> resourcePaths) {
            super(XMLDataFormat.class, DataFormatFileResourceLoader.getDefaultFormatDirectory());
            if (resourcePaths != null) {
                this.addResourcePaths(resourcePaths);
            }
        }
    }
}

