/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data;

import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.AbstractDataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Merger;
import fr.ens.biologie.genomique.eoulsan.splitermergers.Splitter;
import fr.ens.biologie.genomique.kenetre.util.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class XMLDataFormat
extends AbstractDataFormat
implements Serializable {
    private static final long serialVersionUID = -6926659317643003910L;
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static final int DEFAULT_MAX_FILES_COUNT = 1;
    private String name;
    private String description;
    private String alias;
    private String prefix;
    private boolean oneFilePerAnalysis;
    private boolean dataFormatFromDesignFile;
    private String designMetadataKeyName;
    private String sampleMetadataKeyName;
    private String contentType = "text/plain";
    private final List<String> extensions = new ArrayList<String>();
    private final List<String> galaxyFormatNames = new ArrayList<String>();
    private String generatorClassName;
    private final Set<Parameter> generatorParameters = new LinkedHashSet<Parameter>();
    private String checkerClassName;
    private String splitterClassName;
    private String mergerClassName;
    private int maxFilesCount;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isOneFilePerAnalysis() {
        return this.oneFilePerAnalysis;
    }

    @Override
    public boolean isDataFormatFromDesignFile() {
        return this.dataFormatFromDesignFile;
    }

    @Override
    public String getDesignMetadataKeyName() {
        return this.designMetadataKeyName;
    }

    @Override
    public String getSampleMetadataKeyName() {
        return this.sampleMetadataKeyName;
    }

    @Override
    public String getDefaultExtension() {
        return this.extensions.get(0);
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<String> getGalaxyFormatNames() {
        return this.galaxyFormatNames;
    }

    @Override
    public boolean isGenerator() {
        return this.generatorClassName != null;
    }

    @Override
    public boolean isChecker() {
        return this.checkerClassName != null;
    }

    @Override
    public boolean isSplitter() {
        return this.splitterClassName != null;
    }

    @Override
    public boolean isMerger() {
        return this.mergerClassName != null;
    }

    @Override
    public Module getGenerator() {
        Module generator = (Module)this.loadClass(this.generatorClassName, Module.class);
        if (generator == null) {
            return null;
        }
        try {
            generator.configure(null, this.generatorParameters);
            return generator;
        }
        catch (EoulsanException e) {
            EoulsanLogger.getLogger().severe("Cannot create generator: " + e.getMessage());
            return null;
        }
    }

    @Override
    public Checker getChecker() {
        return (Checker)this.loadClass(this.checkerClassName, Checker.class);
    }

    @Override
    public Splitter getSplitter() {
        return (Splitter)this.loadClass(this.splitterClassName, Splitter.class);
    }

    @Override
    public Merger getMerger() {
        return (Merger)this.loadClass(this.mergerClassName, Merger.class);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public int getMaxFilesCount() {
        return this.maxFilesCount;
    }

    private Object loadClass(String className, Class<?> interf) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> result = this.getClass().getClassLoader().loadClass(className);
            if (result == null) {
                return null;
            }
            Object o = result.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (interf.isInstance(o)) {
                return o;
            }
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    private void parse(InputStream is, String source) throws ParserConfigurationException, SAXException, IOException, EoulsanException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        this.parse(doc, source);
        is.close();
    }

    private void parse(Document document, String source) throws EoulsanException {
        for (Element e : XMLUtils.getElementsByTagName((Document)document, (String)"dataformat")) {
            this.name = XMLUtils.getTagValue((Element)e, (String)"name");
            this.description = XMLUtils.getTagValue((Element)e, (String)"description");
            this.alias = XMLUtils.getTagValue((Element)e, (String)"alias");
            this.prefix = XMLUtils.getTagValue((Element)e, (String)"prefix");
            this.oneFilePerAnalysis = Boolean.parseBoolean(XMLUtils.getTagValue((Element)e, (String)"onefileperanalysis"));
            this.designMetadataKeyName = XMLUtils.getTagValue((Element)e, (String)"designmetadatakey");
            this.sampleMetadataKeyName = XMLUtils.getTagValue((Element)e, (String)"samplemetadatakey");
            this.contentType = XMLUtils.getTagValue((Element)e, (String)"content-type");
            this.generatorClassName = XMLUtils.getTagValue((Element)e, (String)"generator");
            this.checkerClassName = XMLUtils.getTagValue((Element)e, (String)"checker");
            this.splitterClassName = XMLUtils.getTagValue((Element)e, (String)"splitter");
            this.mergerClassName = XMLUtils.getTagValue((Element)e, (String)"merger");
            if (this.name == null) {
                throw new EoulsanException("The name of the dataformat is null (source: " + source + ")");
            }
            this.name = this.name.trim().toLowerCase();
            if (this.name.isEmpty()) {
                throw new EoulsanException("The name of the dataformat is empty (source: " + source + ")");
            }
            if (this.designMetadataKeyName != null || this.sampleMetadataKeyName != null) {
                this.dataFormatFromDesignFile = true;
            }
            if (this.designMetadataKeyName != null && this.sampleMetadataKeyName != null) {
                throw new EoulsanException("A DataFormat cannot be provided by a design metadata entry and a sample metadata entry. (format name: " + this.name + ", source: " + source + ")");
            }
            for (Element generatorElement : XMLUtils.getElementsByTagName((Element)e, (String)"generator")) {
                List attributeNames = XMLUtils.getAttributeNames((Element)generatorElement);
                for (String attributeName : attributeNames) {
                    this.generatorParameters.add(new Parameter(attributeName, generatorElement.getAttribute(attributeName)));
                }
            }
            String maxFiles = XMLUtils.getTagValue((Element)e, (String)"maxfilescount");
            try {
                this.maxFilesCount = maxFiles == null ? 1 : Integer.parseInt(maxFiles);
            }
            catch (NumberFormatException exp) {
                throw new EoulsanException("Invalid maximal files count for data format " + this.name + ": " + maxFiles + " (format name: " + this.name + ", source: " + source + ")", exp);
            }
            for (Element e2 : XMLUtils.getElementsByTagName((Document)document, (String)"extensions")) {
                for (Element e3 : XMLUtils.getElementsByTagName((Element)e2, (String)"extension")) {
                    String defaultAttribute = e3.getAttribute("default");
                    if (defaultAttribute != null && "true".equals(defaultAttribute.trim().toLowerCase())) {
                        this.extensions.add(0, e3.getTextContent().trim());
                        continue;
                    }
                    this.extensions.add(e3.getTextContent().trim());
                }
            }
        }
        for (Element toolshed : XMLUtils.getElementsByTagName((Document)document, (String)"toolshedgalaxy")) {
            for (Element ext : XMLUtils.getElementsByTagName((Element)toolshed, (String)"extension")) {
                this.galaxyFormatNames.add(ext.getTextContent().trim());
            }
        }
        for (Element toolshed : XMLUtils.getElementsByTagName((Document)document, (String)"galaxy")) {
            for (Element ext : XMLUtils.getElementsByTagName((Element)toolshed, (String)"formatname")) {
                this.galaxyFormatNames.add(ext.getTextContent().trim());
            }
        }
        if (!FileNaming.isFormatPrefixValid(this.prefix)) {
            throw new EoulsanException("The prefix of the dataformat is invalid (only ascii letters and digits are allowed): " + this.prefix + " (format name: " + this.name + ", source: " + source + ")");
        }
        if (this.description != null) {
            this.description = this.description.trim();
        }
        if (this.alias != null) {
            this.alias = this.alias.trim().toLowerCase();
        }
        if (this.contentType == null || "".equals(this.contentType.trim())) {
            this.contentType = DEFAULT_CONTENT_TYPE;
        }
        if (this.generatorClassName != null && "".equals(this.generatorClassName.trim())) {
            this.generatorClassName = null;
        }
        if (this.checkerClassName != null && "".equals(this.checkerClassName.trim())) {
            this.checkerClassName = null;
        }
        if (this.splitterClassName != null && "".equals(this.splitterClassName.trim())) {
            this.splitterClassName = null;
        }
        if (this.mergerClassName != null && "".equals(this.mergerClassName.trim())) {
            this.mergerClassName = null;
        }
        if (this.maxFilesCount < 1 || this.maxFilesCount > 2) {
            throw new EoulsanException("Invalid maximal files count for data format: " + this.maxFilesCount + " (format name: " + this.name + ", source: " + source + ")");
        }
        if (this.extensions.size() == 0) {
            throw new EoulsanException("No extension define for the data format. (format name: " + this.name + ", source: " + source + ")");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataFormat)) {
            return false;
        }
        if (!(o instanceof XMLDataFormat)) {
            return super.equals(o);
        }
        XMLDataFormat that = (XMLDataFormat)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.alias, that.alias) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.oneFilePerAnalysis, that.oneFilePerAnalysis) && Objects.equals(this.dataFormatFromDesignFile, that.dataFormatFromDesignFile) && Objects.equals(this.designMetadataKeyName, that.designMetadataKeyName) && Objects.equals(this.sampleMetadataKeyName, that.sampleMetadataKeyName) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.extensions, that.extensions) && Objects.equals(this.galaxyFormatNames, that.galaxyFormatNames) && Objects.equals(this.generatorClassName, that.generatorClassName) && Objects.equals(this.checkerClassName, that.checkerClassName) && Objects.equals(this.splitterClassName, that.splitterClassName) && Objects.equals(this.mergerClassName, that.mergerClassName) && Objects.equals(this.maxFilesCount, that.maxFilesCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.description, this.alias, this.prefix, this.oneFilePerAnalysis, this.dataFormatFromDesignFile, this.designMetadataKeyName, this.sampleMetadataKeyName, this.contentType, this.extensions, this.galaxyFormatNames, this.generatorClassName, this.checkerClassName, this.splitterClassName, this.mergerClassName, this.maxFilesCount);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("alias", (Object)this.alias).add("prefix", (Object)this.prefix).add("contentType", (Object)this.contentType).add("defaultExtension", (Object)this.extensions.get(0)).add("extensions", this.extensions).add("galaxyToolExtensions", this.galaxyFormatNames).add("generatorClassName", (Object)this.generatorClassName).add("generatorParameters", this.generatorParameters).add("checkerClassName", (Object)this.checkerClassName).add("splitterClassName", (Object)this.splitterClassName).add("mergerClassName", (Object)this.mergerClassName).add("maxFilesCount", this.maxFilesCount).toString();
    }

    public XMLDataFormat(InputStream is, String source) throws EoulsanException {
        if (is == null) {
            throw new NullPointerException("The input stream is null");
        }
        try {
            this.parse(is, source == null || source.trim().isEmpty() ? "unknown source" : source);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new EoulsanException(e);
        }
    }
}

