/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.protocols;

import fr.ens.biologie.genomique.eoulsan.annotations.HadoopCompatible;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.protocols.AbstractDataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.protocols.SimpleDataFileMetadata;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@HadoopCompatible
public class FileDataProtocol
extends AbstractDataProtocol {
    public static final String PROTOCOL_NAME = "file";

    @Override
    public String getName() {
        return PROTOCOL_NAME;
    }

    @Override
    public File getSourceAsFile(DataFile dataFile) {
        if (dataFile == null || dataFile.getSource() == null) {
            throw new NullPointerException("The source is null.");
        }
        String protocolName = dataFile.getProtocolPrefixInSource();
        if (protocolName == null) {
            return new File(dataFile.getSource());
        }
        return new File(dataFile.getSource().substring(protocolName.length() + 1));
    }

    @Override
    public InputStream getData(DataFile src) throws IOException {
        return FileUtils.createInputStream((File)this.getSourceAsFile(src));
    }

    @Override
    public OutputStream putData(DataFile src) throws IOException {
        return FileUtils.createOutputStream((File)this.getSourceAsFile(src));
    }

    @Override
    public DataFileMetadata getMetadata(DataFile src) throws IOException {
        if (!this.exists(src, true)) {
            if (this.exists(src, false)) {
                SimpleDataFileMetadata result = new SimpleDataFileMetadata();
                FileDataProtocol.setLinkTargetInMetadata(result, this.getSourceAsFile(src).toPath());
                return result;
            }
            throw new FileNotFoundException("File not found: " + src);
        }
        File f = this.getSourceAsFile(src);
        SimpleDataFileMetadata result = new SimpleDataFileMetadata();
        result.setContentLength(f.length());
        result.setLastModified(f.lastModified());
        DataFormat format = DataFormatRegistry.getInstance().getDataFormatFromFilename(src.getName());
        result.setDataFormat(format);
        if (format != null) {
            result.setContentType(format.getContentType());
        } else {
            result.setContentType(StringUtils.getCommonContentTypeFromExtension((String)StringUtils.extensionWithoutCompressionExtension((String)src.getName())));
        }
        CompressionType ct = CompressionType.getCompressionTypeByFilename((String)src.getSource());
        if (ct != null) {
            result.setContentEncoding(ct.getContentEncoding());
        }
        if (f.isDirectory()) {
            result.setDirectory(true);
        }
        if (Files.isSymbolicLink(f.toPath())) {
            FileDataProtocol.setLinkTargetInMetadata(result, f.toPath());
        }
        return result;
    }

    private static void setLinkTargetInMetadata(SimpleDataFileMetadata result, Path link) throws IOException {
        try {
            result.setSymbolicLink(new DataFile(Files.readSymbolicLink(link)));
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    @Override
    public boolean exists(DataFile src, boolean followLink) {
        Path path = this.getSourceAsFile(src).toPath();
        return followLink ? Files.exists(path, new LinkOption[0]) : Files.exists(path, LinkOption.NOFOLLOW_LINKS);
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void mkdir(DataFile dir) throws IOException {
        File file = this.getSourceAsFile(dir);
        if (!file.mkdir()) {
            throw new IOException("Unable to create the directory: " + dir);
        }
    }

    @Override
    public void mkdirs(DataFile dir) throws IOException {
        File file = this.getSourceAsFile(dir);
        if (!file.mkdirs()) {
            throw new IOException("Unable to create the directory: " + dir);
        }
    }

    @Override
    public boolean canMkdir() {
        return true;
    }

    @Override
    public void symlink(DataFile target, DataFile link) throws IOException {
        if (target == null) {
            throw new NullPointerException("target argument is null");
        }
        if (link == null) {
            throw new NullPointerException("link argument is null");
        }
        if (link.exists()) {
            throw new IOException("the symlink already exists");
        }
        if (target.getProtocol() != this) {
            throw new IOException("the protocol of the target is not " + this.getName() + " protocol: " + target);
        }
        if (link.getProtocol() != this) {
            throw new IOException("the protocol of the link is not " + this.getName() + " protocol: " + link);
        }
        Path targetPath = target.toFile().toPath();
        Path linkPath = link.toFile().toPath();
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
    }

    @Override
    public boolean canSymlink() {
        return true;
    }

    @Override
    public void delete(DataFile file, boolean recursive) throws IOException {
        Path path = this.getSourceAsFile(file).toPath();
        if (new File("/").toPath().equals(path.normalize().toAbsolutePath())) {
            throw new IOException("Cannot remove /: " + file);
        }
        if (!recursive || !Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            Files.delete(path);
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                throw new IOException("Cannot remove file: " + file);
            }
        });
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public List<DataFile> list(DataFile file) throws IOException {
        File directoryFile = this.getSourceAsFile(file);
        if (!directoryFile.exists()) {
            throw new FileNotFoundException("File not found: " + file);
        }
        if (!directoryFile.isDirectory()) {
            throw new IOException("The file is not a directory: " + file);
        }
        File[] files = directoryFile.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<DataFile> result = new ArrayList<DataFile>(files.length);
        for (File f : files) {
            result.add(new DataFile(f));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean canList() {
        return true;
    }

    @Override
    public void rename(DataFile src, DataFile dest) throws IOException {
        File destFile;
        if (dest == null) {
            throw new NullPointerException("dest argument is null");
        }
        if (dest.getProtocol() != this) {
            throw new IOException("the protocol of the dest is not " + this.getName() + " protocol: " + dest);
        }
        File file = this.getSourceAsFile(src);
        if (!file.renameTo(destFile = this.getSourceAsFile(dest))) {
            throw new IOException("Cannot rename " + src + " to " + dest);
        }
    }

    @Override
    public boolean canRename() {
        return true;
    }
}

