/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.data.storages;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.storages.DataFileDataPath;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.storage.AbstractFileGenomeDescStorage;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import fr.ens.biologie.genomique.kenetre.storage.GenomeDescStorage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class DataFileGenomeDescStorage
extends AbstractFileGenomeDescStorage {
    protected DataPath newDataPath(String source) {
        return new DataFileDataPath(source);
    }

    protected DataPath newDataPath(DataPath parent, String filename) {
        return new DataFileDataPath(parent, filename);
    }

    protected String computeMD5Sum(DataPath genomeFile) throws IOException {
        DataFile df = ((DataFileDataPath)genomeFile).getDataFile();
        DataFileMetadata md = null;
        try {
            md = df.getMetaData();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (md != null && genomeFile.equals(this.lastGenomeFile) && this.lastGenomeFileModified == md.getLastModified() && this.lastMD5Computed != null) {
            return this.lastMD5Computed;
        }
        String md5Sum = FileUtils.computeMD5Sum((InputStream)genomeFile.rawOpen());
        if (md != null && md5Sum != null) {
            this.lastGenomeFile = genomeFile;
            this.lastGenomeFileModified = md.getLastModified();
            this.lastMD5Computed = md5Sum;
        }
        return md5Sum;
    }

    public static GenomeDescStorage getInstance(DataFile dir, GenericLogger logger) {
        Objects.requireNonNull(dir);
        try {
            return new DataFileGenomeDescStorage(new DataFileDataPath(dir), logger);
        }
        catch (IOException | NullPointerException e) {
            return null;
        }
    }

    protected DataFileGenomeDescStorage(DataPath dir, GenericLogger logger) throws IOException {
        super(dir, logger);
    }
}

