/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFileMetadata;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignFactory;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.SampleMetadata;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.IlluminaReadId;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetCSVReader;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesignBuilder {
    private static final int MAX_FASTQ_ENTRIES_TO_READ = 10000;
    private static final Pattern ILLUMINA_FASTQ_FILENAME_PATTERN = Pattern.compile("^(.+)_\\w+_L\\d\\d\\d_R\\d_\\d\\d\\d$");
    private final DataFormatRegistry dfr = DataFormatRegistry.getInstance();
    private final Map<String, List<FastqEntry>> fastqMap = new LinkedHashMap<String, List<FastqEntry>>();
    private final Map<String, String> prefixMap = new HashMap<String, String>();
    private DataFile genomeFile;
    private DataFile gffFile;
    private DataFile gtfFile;
    private DataFile additionalAnnotationFile;

    public void addFile(DataFile file) throws EoulsanException {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new EoulsanException("File " + file + " does not exist or is not a regular file.");
        }
        String extension = StringUtils.extensionWithoutCompressionExtension((String)file.getName());
        DataFileMetadata md = null;
        try {
            md = file.getMetaData();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.isDataFormatExtension(DataFormats.READS_FASTQ, extension, md)) {
            List<Object> sampleEntries;
            String sampleId;
            FastqEntry entry;
            try {
                entry = new FastqEntry(file);
            }
            catch (EmptyFastqException e) {
                EoulsanLogger.getLogger().warning(e.getMessage());
                return;
            }
            if (this.prefixMap.containsKey(entry.prefix)) {
                sampleId = this.prefixMap.get(entry.prefix);
            } else {
                sampleId = entry.sampleId;
                this.prefixMap.put(entry.prefix, sampleId);
            }
            if (!this.fastqMap.containsKey(sampleId)) {
                sampleEntries = new ArrayList();
                this.fastqMap.put(sampleId, sampleEntries);
            } else {
                sampleEntries = this.fastqMap.get(sampleId);
            }
            if (!sampleEntries.contains(entry)) {
                sampleEntries.add(entry);
            }
        } else if (this.isDataFormatExtension(DataFormats.GENOME_FASTA, extension, md)) {
            this.genomeFile = file;
        } else if (this.isDataFormatExtension(DataFormats.ANNOTATION_GFF, extension, md)) {
            this.gffFile = file;
        } else if (this.isDataFormatExtension(DataFormats.ANNOTATION_GTF, extension, md)) {
            this.gtfFile = file;
        } else if (this.isDataFormatExtension(DataFormats.ADDITIONAL_ANNOTATION_TSV, extension, md)) {
            this.additionalAnnotationFile = file;
        } else {
            throw new EoulsanException("Unknown file type: " + file);
        }
    }

    public void addFile(String filename) throws EoulsanException {
        if (filename == null) {
            return;
        }
        EoulsanLogger.getLogger().info("Add file " + filename + " to design.");
        this.addFile(new DataFile(filename));
    }

    public void addFiles(String[] filenames) throws EoulsanException {
        if (filenames == null) {
            return;
        }
        for (String filename : filenames) {
            this.addFile(filename);
        }
    }

    public void addFiles(List<String> filenames) throws EoulsanException {
        if (filenames == null) {
            return;
        }
        for (String filename : filenames) {
            this.addFile(filename);
        }
    }

    public void addBcl2FastqSamplesheetProject(SampleSheet samplesheet, String projectName, File bcl2fastqOutputDir) throws EoulsanException {
        if (samplesheet == null || bcl2fastqOutputDir == null) {
            return;
        }
        if (!bcl2fastqOutputDir.exists() || !bcl2fastqOutputDir.isDirectory()) {
            throw new EoulsanException("The Bcl2fastq output directory does not exists: " + bcl2fastqOutputDir);
        }
        boolean Bcl2Fastq1 = new File(bcl2fastqOutputDir.getPath() + "/Project_" + projectName).isDirectory();
        for (fr.ens.biologie.genomique.kenetre.illumina.samplesheet.Sample sample : samplesheet) {
            File dataDir;
            String samplePrefix;
            String sampleProject = sample.getSampleProject();
            String sampleId = sample.getSampleId();
            String sampleName = sample.getSampleName();
            String sampleDesc = sample.getDescription();
            String sampleOperator = sample.get("Operator");
            int sampleLane = sample.getLane();
            if (sampleId == null) {
                throw new EoulsanException("No sample Id field found for sample: " + sample);
            }
            String string = samplePrefix = sampleName == null ? sampleId : sampleName;
            if (projectName != null && !projectName.equals(sampleProject)) continue;
            if (Bcl2Fastq1) {
                dataDir = new File(bcl2fastqOutputDir.getPath() + "/Project_" + sampleProject + "/Sample_" + sampleId);
            } else {
                dataDir = new File(bcl2fastqOutputDir.getPath() + "/" + sampleProject);
                String subdir = DesignBuilder.defineSampleSubDirName(sampleId, sampleName);
                if (!"".equals(subdir)) {
                    dataDir = new File(dataDir, subdir);
                }
            }
            if (!dataDir.exists() || !dataDir.isDirectory()) continue;
            String laneKey = sampleLane == -1 ? "_L" : String.format("_L%03d_", sampleLane);
            Object[] files = dataDir.listFiles(f -> {
                String filename = StringUtils.filenameWithoutCompressionExtension((String)f.getName());
                return (filename.endsWith(".fastq") || filename.endsWith(".fq")) && filename.contains(laneKey) && samplePrefix.equals(DesignBuilder.parseSampleNameFromFilename(filename));
            });
            Arrays.sort(files);
            for (Object fastqFile : files) {
                List<Object> list;
                String normalizedSampleId = Naming.toValidName(sampleId);
                if (this.fastqMap.containsKey(normalizedSampleId)) {
                    list = this.fastqMap.get(normalizedSampleId);
                } else {
                    list = new ArrayList();
                    this.fastqMap.put(normalizedSampleId, list);
                }
                try {
                    list.add(new FastqEntry(new DataFile((File)fastqFile), normalizedSampleId, samplePrefix, sampleDesc, sampleOperator));
                }
                catch (EmptyFastqException e) {
                    EoulsanLogger.getLogger().warning(e.getMessage());
                }
            }
        }
    }

    public void addBcl2FastqSamplesheetProject(File samplesheetFile, String projectName) throws EoulsanException {
        File file;
        File baseDir;
        if (samplesheetFile == null) {
            return;
        }
        EoulsanLogger.getLogger().info("Add Bcl2fastq samplesheet file " + samplesheetFile + " to design with " + (String)(projectName == null ? "no project filter." : projectName + " project filter."));
        if (!samplesheetFile.exists()) {
            throw new EoulsanException("The Bcl2fastq samplesheet file does not exists: " + samplesheetFile);
        }
        if (samplesheetFile.isDirectory()) {
            baseDir = samplesheetFile;
            File[] files = baseDir.listFiles((dir, filename) -> filename.endsWith(".csv"));
            if (files == null || files.length == 0) {
                throw new EoulsanException("No Bcl2fastq samplesheet file found in directory: " + baseDir);
            }
            if (files.length > 1) {
                throw new EoulsanException("More than one Bcl2fastq samplesheet found in directory: " + baseDir);
            }
            file = files[0];
        } else {
            baseDir = samplesheetFile.getParentFile();
            file = samplesheetFile;
        }
        try (SampleSheetCSVReader reader = new SampleSheetCSVReader(file);){
            this.addBcl2FastqSamplesheetProject(reader.read(), projectName, baseDir);
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
    }

    public Design getDesign(boolean pairedEndMode) throws EoulsanException {
        Design result = DesignFactory.createEmptyDesign();
        result.addExperiment("exp1");
        FastqFormat defaultFastqFormat = EoulsanRuntime.getSettings().getDefaultFastqFormat();
        for (Map.Entry<String, List<FastqEntry>> e : this.fastqMap.entrySet()) {
            String sampleId = e.getKey();
            List<List<FastqEntry>> files = this.findPairedEndFiles(e.getValue());
            int count = 0;
            for (List<FastqEntry> fes : files) {
                String sampleName = fes.get((int)0).sampleName;
                String desc = fes.get((int)0).sampleDesc;
                String date = fes.get((int)0).sampleDate;
                String operator = fes.get((int)0).sampleOperator;
                String condition = fes.get((int)0).sampleName;
                if (pairedEndMode) {
                    String finalSampleId = files.size() == 1 ? sampleId : sampleId + StringUtils.toLetter((int)count);
                    String finalSampleName = files.size() == 1 ? sampleName : sampleName + StringUtils.toLetter((int)count);
                    ArrayList<String> filenames = new ArrayList<String>();
                    for (FastqEntry fe : fes) {
                        filenames.add(fe.path.getSource());
                    }
                    this.addSample(result, finalSampleId, finalSampleName, desc, condition, date, operator, defaultFastqFormat, filenames, fes.get((int)0).path);
                    ++count;
                    continue;
                }
                for (FastqEntry fe : fes) {
                    String finalSampleId = e.getValue().size() == 1 ? sampleId : sampleId + StringUtils.toLetter((int)count);
                    String finalSampleName = e.getValue().size() == 1 ? sampleName : sampleName + StringUtils.toLetter((int)count);
                    this.addSample(result, finalSampleId, finalSampleName, desc, condition, date, operator, defaultFastqFormat, Collections.singletonList(fe.path.getSource()), fe.path);
                    ++count;
                }
            }
        }
        return result;
    }

    private void addSample(Design design, String sampleId, String sampleName, String desc, String condition, String date, String operator, FastqFormat defaultFastqFormat, List<String> filenames, DataFile fileToCheck) throws EoulsanException {
        if (design == null) {
            return;
        }
        design.addSample(sampleId);
        Sample s = design.getSample(sampleId);
        if (sampleName != null) {
            s.setName(sampleName);
        }
        SampleMetadata smd = s.getMetadata();
        smd.setReads(filenames);
        if (desc != null) {
            smd.setDescription(desc);
        } else if (s.getMetadata().containsDescription()) {
            smd.setDescription("no description");
        }
        if (date != null) {
            smd.setDate(date);
        }
        if (operator != null) {
            smd.setOperator(operator);
        } else if (s.getMetadata().containsOperator()) {
            smd.setOperator("unknown operator");
        }
        if (this.genomeFile != null) {
            design.getMetadata().setGenomeFile(this.genomeFile.toString());
        }
        if (this.gffFile != null) {
            design.getMetadata().setGffFile(this.gffFile.toString());
        }
        if (this.gtfFile != null) {
            design.getMetadata().setGtfFile(this.gtfFile.toString());
        }
        if (this.additionalAnnotationFile != null) {
            design.getMetadata().setAdditionalAnnotationFile(this.additionalAnnotationFile.toString());
        }
        FastqFormat format = null;
        try {
            EoulsanLogger.getLogger().info("Check fastq format for " + fileToCheck);
            format = FastqFormat.identifyFormat((InputStream)fileToCheck.open(), (int)10000);
        }
        catch (BadBioEntryException | IOException e) {
            throw new EoulsanException(e);
        }
        smd.setFastqFormat(format == null ? defaultFastqFormat : format);
        smd.setRepTechGroup(condition);
        smd.setUUID(UUID.randomUUID().toString());
        Experiment exp = design.getExperiments().get(0);
        ExperimentSample es = exp.addSample(s);
        es.getMetadata().setCondition(condition);
        es.getMetadata().setReference(false);
    }

    private boolean isDataFormatExtension(DataFormat dataFormat, String extension, DataFileMetadata md) {
        if (md != null && md.getDataFormat() != null) {
            return dataFormat.equals(md.getDataFormat());
        }
        for (DataFormat df : this.dfr.getDataFormatsFromExtension(extension)) {
            if (df != dataFormat) continue;
            return true;
        }
        return false;
    }

    private List<List<FastqEntry>> findPairedEndFiles(List<FastqEntry> files) throws EoulsanException {
        HashMap mapPrefix = new HashMap();
        HashMap<FastqEntry, Integer> mapPaired = new HashMap<FastqEntry, Integer>();
        ArrayList<List<FastqEntry>> result = new ArrayList<List<FastqEntry>>();
        for (FastqEntry fastqEntry : files) {
            List<FastqEntry> list;
            mapPaired.put(fastqEntry, fastqEntry.pairMember);
            if (mapPrefix.containsKey(fastqEntry.prefix)) {
                list = (List)mapPrefix.get(fastqEntry.prefix);
            } else {
                list = new ArrayList();
                mapPrefix.put(fastqEntry.prefix, list);
                result.add(list);
            }
            list.add(fastqEntry);
        }
        for (List list : result) {
            int member2;
            if (list.size() > 2) {
                throw new EoulsanException("Found more than 2 files for a sample in paired-end mode: " + list);
            }
            if (list.size() != 2) continue;
            int member1 = (Integer)mapPaired.get(list.get(0));
            if (member1 == (member2 = ((Integer)mapPaired.get(list.get(1))).intValue())) {
                throw new EoulsanException("Found two files with the same pair member: " + list);
            }
            if (member1 < 1 || member1 > 2) {
                throw new EoulsanException("Invalid pair member for file: " + list.get(0));
            }
            if (member2 < 1 || member2 > 2) {
                throw new EoulsanException("Invalid pair member for file: " + list.get(1));
            }
            if (member1 != 2 || member2 != 1) continue;
            FastqEntry tmp = (FastqEntry)list.get(0);
            list.set(0, (FastqEntry)list.get(1));
            list.set(1, tmp);
        }
        return result;
    }

    private static String parseSampleNameFromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(filename.split("_")));
        int size = list.size();
        if (size < 5) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String field : list.subList(0, size - 4)) {
            if (first) {
                first = false;
            } else {
                sb.append('_');
            }
            sb.append(field);
        }
        return sb.toString();
    }

    public static String defineSampleSubDirName(String sampleId, String sampleName) {
        if (sampleId != null && !"".equals(sampleId.trim()) && sampleName != null && !"".equals(sampleName.trim())) {
            return sampleId.trim();
        }
        return "";
    }

    public DesignBuilder() {
    }

    public DesignBuilder(String[] filenames) throws EoulsanException {
        this.addFiles(filenames);
    }

    private static class FastqEntry {
        private static final String DATE_FORMAT = "yyyy-MM-dd";
        private final DataFile path;
        private final String sampleId;
        private final String sampleName;
        private final String sampleDesc;
        private final String sampleOperator;
        private final String sampleDate;
        private final String firstReadId;
        private final String prefix;
        private final int pairMember;

        private static String getDate(DataFile file) {
            try {
                long last = file.getMetaData().getLastModified();
                return new SimpleDateFormat(DATE_FORMAT).format(new Date(last));
            }
            catch (IOException e) {
                return null;
            }
        }

        private static String getFirstReadSeqId(DataFile f) throws EoulsanException {
            try {
                FastqReader reader = new FastqReader(f.open());
                if (!reader.hasNext()) {
                    reader.close();
                    reader.throwException();
                    throw new EmptyFastqException("Fastq file is empty: " + f.getSource());
                }
                reader.close();
                reader.throwException();
                return reader.next().getName();
            }
            catch (BadBioEntryException | IOException e) {
                throw new EoulsanException(e);
            }
        }

        private Object[] initPairedEnd() {
            Object prefix = this.firstReadId;
            int pairMember = -1;
            try {
                IlluminaReadId irid = new IlluminaReadId(this.firstReadId);
                prefix = irid.getInstrumentId() + "\t" + irid.getFlowCellLane() + "\t" + irid.getTileNumberInFlowCellLane() + "\t" + irid.getXClusterCoordinateInTile() + "\t" + irid.getYClusterCoordinateInTile();
                pairMember = irid.getPairMember();
            }
            catch (KenetreException e) {
                if (this.firstReadId.endsWith("/1")) {
                    prefix = this.firstReadId.substring(0, this.firstReadId.length() - 3);
                    pairMember = 1;
                }
                if (this.firstReadId.endsWith("/2")) {
                    prefix = this.firstReadId.substring(0, this.firstReadId.length() - 3);
                    pairMember = 2;
                }
                pairMember = 1;
            }
            return new Object[]{prefix, pairMember};
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FastqEntry)) {
                return false;
            }
            FastqEntry that = (FastqEntry)obj;
            return this.path.equals(that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FastqEntry(Sample: ");
            sb.append(this.sampleId);
            if (this.sampleDesc != null) {
                sb.append(", Description: ");
                sb.append(this.sampleDesc);
            }
            if (this.sampleOperator != null) {
                sb.append(", Operator: ");
                sb.append(this.sampleOperator);
            }
            sb.append(", Path: ");
            sb.append(this.path);
            sb.append(")");
            return sb.toString();
        }

        private static String defineSampleName(DataFile path) {
            String basename = StringUtils.basename((String)path.getName());
            Matcher matcher = ILLUMINA_FASTQ_FILENAME_PATTERN.matcher(basename);
            if (matcher.matches()) {
                basename = matcher.group(1);
            }
            return basename;
        }

        public FastqEntry(DataFile path) throws EoulsanException {
            this.path = path;
            this.sampleName = FastqEntry.defineSampleName(path);
            this.sampleId = Naming.toValidName(this.sampleName);
            this.sampleDesc = null;
            this.sampleOperator = null;
            this.sampleDate = FastqEntry.getDate(path);
            this.firstReadId = FastqEntry.getFirstReadSeqId(path);
            Object[] array = this.initPairedEnd();
            this.prefix = (String)array[0];
            this.pairMember = (Integer)array[1];
        }

        public FastqEntry(DataFile path, String sampleId, String sampleName, String sampleDesc, String sampleOperator) throws EoulsanException {
            this.path = path;
            this.sampleId = sampleId;
            this.sampleName = sampleName;
            this.sampleDesc = sampleDesc;
            this.sampleOperator = sampleOperator;
            this.sampleDate = FastqEntry.getDate(path);
            this.firstReadId = FastqEntry.getFirstReadSeqId(path);
            Object[] array = this.initPairedEnd();
            this.prefix = (String)array[0];
            this.pairMember = (Integer)array[1];
        }
    }

    private static class EmptyFastqException
    extends EoulsanException {
        private static final long serialVersionUID = 5672764893232380662L;

        public EmptyFastqException(String msg) {
            super(msg);
        }
    }
}

