/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignMetadata;
import fr.ens.biologie.genomique.eoulsan.design.DesignMetadataImpl;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentImpl;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.SampleImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

class DesignImpl
implements Serializable,
Design {
    private static final long serialVersionUID = 7250832351983922161L;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private final int designNumber = instanceCount.incrementAndGet();
    private String designName = "Design" + this.designNumber;
    private final Map<String, Sample> samples = new LinkedHashMap<String, Sample>();
    private final Map<String, Experiment> experiments = new LinkedHashMap<String, Experiment>();
    private final DesignMetadata designMetadata = new DesignMetadataImpl();

    @Override
    public void setName(String newDesignName) {
        Objects.requireNonNull(newDesignName, "newDesignName argument cannot be null");
        this.designName = newDesignName.trim();
    }

    @Override
    public Sample getSample(String sampleId) {
        Objects.requireNonNull(sampleId, "sampleId argument cannot be null");
        String id = sampleId.trim();
        Preconditions.checkArgument((boolean)this.samples.containsKey(id), (Object)("The sample does not exists in the design: " + id));
        return this.samples.get(id);
    }

    @Override
    public List<Sample> getSamples() {
        return Collections.unmodifiableList(new ArrayList<Sample>(this.samples.values()));
    }

    @Override
    public Experiment getExperiment(String experimentId) {
        Objects.requireNonNull(experimentId, "experimentId argument cannot be null");
        String id = experimentId.trim();
        Preconditions.checkArgument((boolean)this.experiments.containsKey(id), (Object)("The experiment does not exists in the design: " + id));
        return this.experiments.get(id);
    }

    @Override
    public List<Experiment> getExperiments() {
        return Collections.unmodifiableList(new ArrayList<Experiment>(this.experiments.values()));
    }

    @Override
    public DesignMetadata getMetadata() {
        return this.designMetadata;
    }

    @Override
    public int getNumber() {
        return this.designNumber;
    }

    @Override
    public String getName() {
        return this.designName;
    }

    @Override
    public void removeSample(String sampleId) {
        Objects.requireNonNull(sampleId, "sampleId argument cannot be null");
        Preconditions.checkArgument((boolean)this.samples.containsKey(sampleId), (Object)("The sample does not exists in the design: " + sampleId));
        this.samples.remove(sampleId.trim());
    }

    @Override
    public void removeExperiment(String experimentId) {
        Objects.requireNonNull(experimentId, "experimentId argument cannot be null");
        Preconditions.checkArgument((boolean)this.experiments.containsKey(experimentId.trim()), (Object)("The experiment does not exists in the design: " + experimentId));
        this.experiments.remove(experimentId.trim());
    }

    @Override
    public boolean containsSample(String sampleId) {
        return this.samples.containsKey(sampleId.trim());
    }

    @Override
    public boolean containsExperiment(String experimentId) {
        return this.experiments.containsKey(experimentId.trim());
    }

    @Override
    public boolean containsSampleName(String sampleName) {
        Objects.requireNonNull(sampleName, "sampleName argument cannot be null");
        String name = sampleName.trim();
        for (Sample sample : this.samples.values()) {
            if (!name.equals(sample.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsExperimentName(String experimentName) {
        Objects.requireNonNull(experimentName, "sampleName argument cannot be null");
        String name = experimentName.trim();
        for (Experiment experiment : this.experiments.values()) {
            if (!name.equals(experiment.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public SampleImpl addSample(String sampleId) {
        Objects.requireNonNull(sampleId, "sampleId argument cannot be null");
        String id = sampleId.trim();
        Preconditions.checkArgument((!this.samples.containsKey(id) ? 1 : 0) != 0, (Object)("The sample already exists in the design: " + id));
        Preconditions.checkArgument((boolean)FileNaming.isDataNameValid(sampleId), (Object)("The id of a sample can only contains letters and digit: " + sampleId));
        SampleImpl newSample = new SampleImpl(this, id);
        this.samples.put(id, newSample);
        return newSample;
    }

    @Override
    public Experiment addExperiment(String experimentId) {
        Objects.requireNonNull(experimentId, "experimentId argument cannot be null");
        String id = experimentId.trim();
        Preconditions.checkArgument((!this.experiments.containsKey(id) ? 1 : 0) != 0, (Object)("The experiment already exists in the design: " + id));
        Preconditions.checkArgument((boolean)FileNaming.isDataNameValid(experimentId), (Object)("The id of an experiment can only contains letters and digit: " + experimentId));
        ExperimentImpl newExperiment = new ExperimentImpl(this, id);
        this.experiments.put(id, newExperiment);
        return newExperiment;
    }

    @Override
    public List<Experiment> getExperimentsUsingASample(Sample sample) {
        Objects.requireNonNull(sample, "sample argument cannot be null");
        ArrayList<Experiment> result = new ArrayList<Experiment>();
        for (Experiment e : this.getExperiments()) {
            if (!e.containsSample(sample)) continue;
            result.add(e);
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("designNumber", this.designNumber).add("designName", (Object)this.designName).add("samples", this.samples).add("experiments", this.experiments).add("designMetadata", (Object)this.designMetadata).toString();
    }

    public int hashCode() {
        return Objects.hash(this.designNumber, this.designName, this.samples, this.experiments, this.designMetadata);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DesignImpl)) {
            return false;
        }
        DesignImpl that = (DesignImpl)o;
        return Objects.equals(this.designName, that.designName) && Objects.equals(this.samples, that.samples) && Objects.equals(this.experiments, that.experiments) && Objects.equals(this.designMetadata, that.designMetadata);
    }

    DesignImpl() {
    }
}

