/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentMetadata;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSampleMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.SampleMetadata;
import fr.ens.biologie.genomique.eoulsan.design.io.DefaultDesignReader;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class DesignUtils {
    public static void showDesign(Design design) {
        Objects.requireNonNull(design, "design argument cannot be null");
        StringBuilder sb = new StringBuilder();
        sb.append("Design: ");
        sb.append(design.getName());
        sb.append(" (");
        sb.append(design.getNumber());
        sb.append(")\n");
        sb.append("Design metadata:\n");
        for (Map.Entry<String, String> entry : design.getMetadata().entrySet()) {
            sb.append('\t');
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
            sb.append('\n');
        }
        sb.append('\n');
        sb.append("Experiments:\n");
        for (Experiment experiment : design.getExperiments()) {
            String expId = experiment.getId();
            sb.append(expId);
            sb.append("\n ExperimentMetadata:\n");
            for (Map.Entry<String, String> m : experiment.getMetadata().entrySet()) {
                sb.append('\t');
                sb.append("Exp.");
                sb.append(expId);
                sb.append(".");
                sb.append(m.getKey());
                sb.append('=');
                sb.append(m.getValue());
                sb.append('\n');
            }
            sb.append('\n');
        }
        sb.append('\n');
        sb.append("SampleId");
        sb.append('\t');
        sb.append("SampleNumber");
        sb.append('\t');
        sb.append("SampleName");
        List<String> sampleMDKeys = DesignUtils.getAllSamplesMetadataKeys(design);
        for (String key : sampleMDKeys) {
            sb.append('\t');
            sb.append(key);
        }
        for (Experiment experiment : design.getExperiments()) {
            String prefix = "Exp." + experiment.getId() + ".";
            List<String> experimentMDKeys = DesignUtils.getExperimentSampleAllMetadataKeys(experiment);
            for (String key : experimentMDKeys) {
                sb.append('\t');
                sb.append(prefix);
                sb.append(key);
            }
        }
        sb.append('\n');
        for (Sample sample : design.getSamples()) {
            sb.append(sample.getId());
            sb.append('\t');
            sb.append(sample.getNumber());
            sb.append('\t');
            sb.append(sample.getName());
            SampleMetadata smd = sample.getMetadata();
            for (String key : sampleMDKeys) {
                sb.append('\t');
                if (!smd.contains(key)) continue;
                sb.append(smd.get(key));
            }
            for (Experiment experiment : design.getExperiments()) {
                ExperimentSampleMetadata expSampleMetadata = experiment.getExperimentSample(sample).getMetadata();
                List<String> experimentMDKeys = DesignUtils.getExperimentSampleAllMetadataKeys(experiment);
                for (String key : experimentMDKeys) {
                    sb.append('\t');
                    if (!expSampleMetadata.contains(key)) continue;
                    sb.append(expSampleMetadata.get(key));
                }
            }
            sb.append('\n');
        }
        System.out.println(sb.toString());
    }

    public static List<String> getAllSamplesMetadataKeys(Design design) {
        Objects.requireNonNull(design, "design argument cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> keys = new HashSet<String>();
        for (Sample sample : design.getSamples()) {
            for (String key : sample.getMetadata().keySet()) {
                if (keys.contains(key)) continue;
                keys.add(key);
                result.add(key);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static List<String> getExperimentSampleAllMetadataKeys(Experiment experiment) {
        Objects.requireNonNull(experiment, "design argument cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> keys = new HashSet<String>();
        for (ExperimentSample sample : experiment.getExperimentSamples()) {
            for (String key : sample.getMetadata().keySet()) {
                if (keys.contains(key)) continue;
                keys.add(key);
                result.add(key);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private DesignUtils() {
    }

    public static boolean checkSamples(Design design) {
        HashSet<String> samplesSources = new HashSet<String>();
        for (Sample s : design.getSamples()) {
            for (String fileSource : s.getMetadata().getReads()) {
                if (samplesSources.contains(fileSource)) {
                    return false;
                }
                samplesSources.add(fileSource);
            }
        }
        return true;
    }

    private static boolean checkSamplesWithException(Design design) throws EoulsanException {
        HashSet<String> samplesSources = new HashSet<String>();
        for (Sample s : design.getSamples()) {
            for (String fileSource : s.getMetadata().getReads()) {
                if (samplesSources.contains(fileSource)) {
                    throw new EoulsanException("Error: The design contains one or more duplicate sample sources: " + fileSource + " (sample " + s.getId() + ")");
                }
                samplesSources.add(fileSource);
            }
        }
        return true;
    }

    public static boolean checkGenomes(Design design) {
        return design.getMetadata().containsGenomeFile();
    }

    public static boolean checkAnnotations(Design design) {
        return design.getMetadata().containsGffFile();
    }

    public static Design readAndCheckDesign(InputStream is) throws EoulsanException {
        try {
            DefaultDesignReader dr = new DefaultDesignReader(is);
            Design design = dr.read();
            DesignUtils.checkSamplesWithException(design);
            if (!DesignUtils.checkGenomes(design)) {
                throw new EoulsanException("Warning: The design contains more than one genome file.");
            }
            if (!DesignUtils.checkAnnotations(design)) {
                throw new EoulsanException("Warning: The design contains more than one annotation file.");
            }
            return design;
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
    }

    public static void obfuscate(Design design, boolean removeReplicateInformation) {
        if (design == null) {
            return;
        }
        DesignUtils.removeSampleMedataIfExists(design, "Comment");
        DesignUtils.removeSampleMedataIfExists(design, "Date");
        DesignUtils.removeSampleMedataIfExists(design, "Operator");
        if (removeReplicateInformation) {
            DesignUtils.removeExperimentSampleMedataIfExists(design, "Condition");
            DesignUtils.removeExperimentSampleMedataIfExists(design, "RepTechGroup");
            DesignUtils.removeExperimentSampleMedataIfExists(design, "Reference");
        }
        HashMap<Experiment, Integer> mapExperiment = new HashMap<Experiment, Integer>();
        HashMap<String, Integer> mapCondition = new HashMap<String, Integer>();
        HashMap<String, Integer> mapRepTechGroup = new HashMap<String, Integer>();
        int countExperiment = 0;
        int countCondition = 0;
        int countRepTechGroup = 0;
        for (Experiment exp : design.getExperiments()) {
            if (!mapExperiment.containsKey(exp)) {
                mapExperiment.put(exp, ++countExperiment);
            }
            exp.setName("e" + mapExperiment.get(exp));
            for (ExperimentSample es : exp.getExperimentSamples()) {
                ExperimentSampleMetadata esmd = es.getMetadata();
                if (esmd.containsCondition()) {
                    String condition = esmd.getCondition();
                    if (!mapCondition.containsKey(condition)) {
                        mapCondition.put(condition, ++countCondition);
                    }
                    esmd.setCondition("c" + mapCondition.get(condition));
                }
                if (!esmd.containsRepTechGroup()) continue;
                String rtg = esmd.getRepTechGroup();
                if (!mapRepTechGroup.containsKey(rtg)) {
                    mapRepTechGroup.put(rtg, ++countRepTechGroup);
                }
                esmd.setRepTechGroup("g" + mapRepTechGroup.get(rtg));
            }
        }
        for (Sample s : design.getSamples()) {
            String newSampleName = "s" + s.getId();
            if (newSampleName.equals(s.getName())) continue;
            s.setName(newSampleName);
        }
    }

    private static void removeSampleMedataIfExists(Design design, String fieldName) {
        if (design == null || fieldName == null) {
            return;
        }
        for (Sample sample : design.getSamples()) {
            SampleMetadata smd = sample.getMetadata();
            if (!smd.contains(fieldName)) continue;
            smd.remove(fieldName);
        }
    }

    private static void removeExperimentSampleMedataIfExists(Design design, String fieldName) {
        if (design == null || fieldName == null) {
            return;
        }
        for (Experiment experiment : design.getExperiments()) {
            for (ExperimentSample expSample : experiment.getExperimentSamples()) {
                ExperimentSampleMetadata esmd = expSample.getMetadata();
                if (!esmd.contains(fieldName)) continue;
                esmd.remove(fieldName);
            }
        }
    }

    public static void replaceLocalPathBySymlinks(Design design, DataFile symlinksDir) throws IOException {
        if (design == null) {
            return;
        }
        DataFormatRegistry registry = DataFormatRegistry.getInstance();
        HashSet<String> createdLinks = new HashSet<String>();
        ArrayList<String> designKeysToModify = new ArrayList<String>();
        for (String string : design.getMetadata().keySet()) {
            if (registry.getDataFormatForDesignMetadata(string) == null) continue;
            designKeysToModify.add(string);
        }
        DesignMetadata dmd = design.getMetadata();
        for (String string : designKeysToModify) {
            dmd.set(string, DesignUtils.replaceLocalPathBySymlinks(dmd.getAsList(string), symlinksDir, createdLinks));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Sample s : design.getSamples()) {
            for (String field : s.getMetadata().keySet()) {
                if (registry.getDataFormatForSampleMetadata(field) == null) continue;
                hashSet.add(field);
            }
        }
        for (Sample s : design.getSamples()) {
            SampleMetadata smd = s.getMetadata();
            for (String field : hashSet) {
                smd.set(field, DesignUtils.replaceLocalPathBySymlinks(smd.getAsList(field), symlinksDir, createdLinks));
            }
        }
    }

    private static List<String> replaceLocalPathBySymlinks(List<String> values, DataFile symlinksDir, Set<String> createdLinks) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (String inputPath : values) {
            DataFile inFile = new DataFile(inputPath);
            if (inFile.isLocalFile()) {
                String linkName = DesignUtils.findLinkFilename(createdLinks, inFile.getName());
                DataFile outFile = new DataFile(symlinksDir, linkName);
                if (!inFile.exists()) {
                    throw new IOException("File not exists: " + inFile);
                }
                if (outFile.exists()) {
                    throw new IOException("The symlink to create, already exists: " + outFile);
                }
                try {
                    inFile.symlink(outFile);
                }
                catch (IOException e) {
                    throw new IOException("Cannot create symlink: " + outFile, e);
                }
                createdLinks.add(linkName);
                result.add(outFile.getName());
                continue;
            }
            result.add(inputPath);
        }
        return result;
    }

    private static String findLinkFilename(Set<String> createdLinks, String filename) {
        String newName;
        if (!createdLinks.contains(filename)) {
            return filename;
        }
        String compressionExtension = StringUtils.compressionExtension((String)filename);
        String extension = StringUtils.extensionWithoutCompressionExtension((String)filename);
        String basename = filename.substring(0, filename.length() - compressionExtension.length() - extension.length());
        int count = 1;
        while (createdLinks.contains(newName = basename + "_" + ++count + extension + compressionExtension)) {
        }
        return newName;
    }

    public static String getCondition(Experiment experiment, Sample sample) {
        Objects.requireNonNull(experiment, "experiment argument cannot be null");
        Objects.requireNonNull(sample, "sample argument cannot be null");
        ExperimentSample es = experiment.getExperimentSample(sample);
        return DesignUtils.getCondition(es);
    }

    public static String getCondition(ExperimentSample experimentSample) {
        Objects.requireNonNull(experimentSample, "experimentSample argument cannot be null");
        ExperimentSampleMetadata esm = experimentSample.getMetadata();
        if (esm.containsCondition()) {
            return esm.getCondition();
        }
        SampleMetadata sm = experimentSample.getSample().getMetadata();
        String result = sm.getCondition();
        return result == null ? null : result.trim();
    }

    public static String getRepTechGroup(Experiment experiment, Sample sample) {
        Objects.requireNonNull(experiment, "experiment argument cannot be null");
        Objects.requireNonNull(sample, "sample argument cannot be null");
        ExperimentSample es = experiment.getExperimentSample(sample);
        return DesignUtils.getRepTechGroup(es);
    }

    public static String getRepTechGroup(ExperimentSample experimentSample) {
        Objects.requireNonNull(experimentSample, "experimentSample argument cannot be null");
        ExperimentSampleMetadata esm = experimentSample.getMetadata();
        if (esm.containsRepTechGroup()) {
            return esm.getRepTechGroup();
        }
        SampleMetadata sm = experimentSample.getSample().getMetadata();
        String result = sm.getRepTechGroup();
        return result == null ? null : result.trim();
    }

    public static String getMetadata(Experiment experiment, Sample sample, String key) {
        Objects.requireNonNull(experiment, "experiment argument cannot be null");
        Objects.requireNonNull(sample, "sample argument cannot be null");
        ExperimentSample es = experiment.getExperimentSample(sample);
        return DesignUtils.getMetadata(es, key);
    }

    public static String getMetadata(ExperimentSample experimentSample, String key) {
        Objects.requireNonNull(experimentSample, "experimentSample argument cannot be null");
        Objects.requireNonNull(key, "key argument cannot be null");
        ExperimentSampleMetadata esm = experimentSample.getMetadata();
        if (esm.contains(key)) {
            return esm.get(key);
        }
        SampleMetadata sm = experimentSample.getSample().getMetadata();
        String result = sm.get(key);
        return result == null ? null : result.trim();
    }

    public static boolean isSkipped(Experiment experiment) {
        Objects.requireNonNull(experiment, "experiment argument cannot be null");
        ExperimentMetadata emd = experiment.getMetadata();
        return emd.containsSkip() && emd.isSkip();
    }

    public static boolean containsReferenceField(Experiment experiment) {
        Objects.requireNonNull(experiment, "experiment argument cannot be null");
        for (ExperimentSample es : experiment.getExperimentSamples()) {
            ExperimentSampleMetadata esmd = es.getMetadata();
            if (esmd.containsReference()) {
                return true;
            }
            SampleMetadata smd = es.getSample().getMetadata();
            if (!smd.containsReference()) continue;
            return true;
        }
        return false;
    }

    public static String getReference(Experiment experiment, Sample sample) {
        Objects.requireNonNull(experiment, "experiment argument cannot be null");
        Objects.requireNonNull(sample, "sample argument cannot be null");
        ExperimentSample es = experiment.getExperimentSample(sample);
        return DesignUtils.getReference(es);
    }

    public static String getReference(ExperimentSample experimentSample) {
        Objects.requireNonNull(experimentSample, "experimentSample argument cannot be null");
        ExperimentSampleMetadata esmd = experimentSample.getMetadata();
        if (esmd.containsReference()) {
            return esmd.getReference();
        }
        SampleMetadata smd = experimentSample.getSample().getMetadata();
        if (smd.containsReference()) {
            return smd.getReference();
        }
        return null;
    }

    public static int referenceValueToInt(String value, String experiementReference) {
        if (value == null) {
            return 0;
        }
        String s = value.trim();
        if (s.equals(experiementReference)) {
            return 1;
        }
        switch (s.toLowerCase()) {
            case "t": 
            case "true": 
            case "y": 
            case "yes": {
                return 1;
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Set<String> getModelColumns(Experiment experiment) {
        Objects.requireNonNull(experiment, "experiment argument cannot be null");
        HashSet<String> result = new HashSet<String>();
        ExperimentMetadata em = experiment.getMetadata();
        if (!em.isContrast()) {
            return result;
        }
        String model = em.getModel();
        if (model == null) {
            return result;
        }
        for (String s : Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"~+: ")).omitEmptyStrings().split((CharSequence)em.getModel())) {
            result.add(s);
        }
        return result;
    }
}

