/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentMetadataImpl;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSampleImpl;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ExperimentImpl
implements Serializable,
Experiment {
    private static final long serialVersionUID = -2644491674956956116L;
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private final Design design;
    private final String experimentId;
    private final int experimentNumber = instanceCount.incrementAndGet();
    private String experimentName = "Experiment" + this.experimentNumber;
    private final ExperimentMetadataImpl metadata = new ExperimentMetadataImpl();
    private final List<ExperimentSample> samples = new ArrayList<ExperimentSample>();
    private final Set<String> sampleNames = new HashSet<String>();

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public String getId() {
        return this.experimentId;
    }

    @Override
    public String getName() {
        return this.experimentName;
    }

    @Override
    public int getNumber() {
        return this.experimentNumber;
    }

    @Override
    public ExperimentMetadataImpl getMetadata() {
        return this.metadata;
    }

    @Override
    public List<Sample> getSamples() {
        ArrayList<Sample> result = new ArrayList<Sample>();
        for (ExperimentSample es : this.getExperimentSamples()) {
            result.add(es.getSample());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<ExperimentSample> getExperimentSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    @Override
    public ExperimentSample getExperimentSample(Sample sample) {
        if (sample == null) {
            return null;
        }
        for (ExperimentSample eSample : this.samples) {
            if (!eSample.getSample().getId().equals(sample.getId())) continue;
            return eSample;
        }
        return null;
    }

    @Override
    public void setName(String newExperimentName) {
        Objects.requireNonNull(newExperimentName, "newExperimentName argument cannot be null");
        String name = newExperimentName.trim();
        if (name.equals(this.experimentName)) {
            return;
        }
        Preconditions.checkArgument((!this.design.containsExperimentName(name) ? 1 : 0) != 0, (Object)("The experiment name already exists in the design: " + name));
        this.experimentName = name;
    }

    @Override
    public ExperimentSample addSample(Sample sample) {
        Objects.requireNonNull(sample, "sample argument cannot be null");
        Preconditions.checkArgument((!this.sampleNames.contains(sample.getId()) ? 1 : 0) != 0, (Object)("The sample already exists in the experiment: " + sample.getId()));
        Preconditions.checkArgument((sample.getDesign() == this.design ? 1 : 0) != 0, (Object)("The sample to add to the experiment is not a sample of the design: " + sample.getId()));
        ExperimentSampleImpl newExperimentSample = new ExperimentSampleImpl(sample);
        this.samples.add(newExperimentSample);
        this.sampleNames.add(sample.getId());
        return newExperimentSample;
    }

    @Override
    public void removeSample(Sample sample) {
        Objects.requireNonNull(sample, "sample argument cannot be null");
        Preconditions.checkArgument((boolean)this.sampleNames.contains(sample.getId()), (Object)("The sample does not exists in the experiment: " + sample.getId()));
        Preconditions.checkArgument((sample.getDesign() == this.design ? 1 : 0) != 0, (Object)("The sample to remove to the experiment is not a sample of the design: " + sample.getId()));
        this.samples.remove(this.getExperimentSample(sample));
        this.sampleNames.remove(sample.getId());
    }

    @Override
    public boolean containsSample(Sample sample) {
        Objects.requireNonNull(sample, "sample argument cannot be null");
        return this.sampleNames.contains(sample.getId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("experimentId", (Object)this.experimentId).add("experimentNumber", this.experimentNumber).add("experimentName", (Object)this.experimentName).add("experimentMetadata", (Object)this.metadata).add("experimentSamples", this.samples).toString();
    }

    public int hashCode() {
        return Objects.hash(this.experimentId, this.experimentNumber, this.experimentName, this.metadata, this.samples);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExperimentImpl)) {
            return false;
        }
        ExperimentImpl that = (ExperimentImpl)o;
        return Objects.equals(this.experimentId, that.experimentId) && Objects.equals(this.experimentName, that.experimentName) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.samples, that.samples);
    }

    ExperimentImpl(Design design, String experimentId) {
        Objects.requireNonNull(design, "design argument cannot be null");
        Objects.requireNonNull(experimentId, "sampleId argument cannot be null");
        Preconditions.checkArgument((boolean)FileNaming.isDataNameValid(experimentId), (Object)("The id of an experiment can only contains letters and digit: " + experimentId));
        this.design = design;
        this.experimentId = experimentId.trim();
    }
}

