/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design.io;

import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.SampleMetadata;
import fr.ens.biologie.genomique.eoulsan.design.io.DesignWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Objects;

public class Eoulsan1DesignWriter
implements DesignWriter {
    private final OutputStream out;
    private static final String SEPARATOR = "\t";
    private static final String NEWLINE = "\r\n";
    private boolean writeScanLabelsSettings = true;

    @Override
    public void write(Design design) throws IOException {
        List<String> esmdk;
        if (design == null) {
            throw new NullPointerException("Design is null");
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.out, Globals.DEFAULT_CHARSET));
        bw.append("SampleNumber");
        bw.append(SEPARATOR);
        bw.append("Name");
        List<String> sampleMDKeys = DesignUtils.getAllSamplesMetadataKeys(design);
        for (String key : sampleMDKeys) {
            if ("UUID".equals(key)) continue;
            bw.append(SEPARATOR);
            bw.append(key);
        }
        if (design.getMetadata().containsGenomeFile()) {
            bw.append(SEPARATOR);
            bw.append("Genome");
        }
        if (design.getMetadata().containsGffFile()) {
            bw.append(SEPARATOR);
            bw.append("Annotation");
        }
        if (design.getMetadata().containsGtfFile()) {
            bw.append(SEPARATOR);
            bw.append("GffFile");
        }
        if (design.getMetadata().containsAdditionalAnnotationFile()) {
            bw.append(SEPARATOR);
            bw.append("AdditionalAnnotation");
        }
        Experiment exp = design.getExperiments().isEmpty() ? null : design.getExperiments().get(0);
        List<String> list = esmdk = exp == null ? null : DesignUtils.getExperimentSampleAllMetadataKeys(exp);
        if (exp != null) {
            bw.append(SEPARATOR);
            bw.append("Experiment");
            if (esmdk.contains("Condition")) {
                bw.append(SEPARATOR);
                bw.append("Condition");
            }
            if (esmdk.contains("RepTechGroup")) {
                bw.append(SEPARATOR);
                bw.append("RepTechGroup");
            }
            if (esmdk.contains("Reference")) {
                bw.append(SEPARATOR);
                bw.append("Reference");
            }
        }
        if (sampleMDKeys.contains("UUID")) {
            bw.append('\t');
            bw.append("UUID");
        }
        bw.append(NEWLINE);
        for (Sample sample : design.getSamples()) {
            bw.append(Integer.toString(sample.getNumber()));
            bw.append(SEPARATOR);
            bw.append(sample.getId());
            SampleMetadata smd = sample.getMetadata();
            for (String key : sampleMDKeys) {
                if ("UUID".equals(key)) continue;
                bw.append(SEPARATOR);
                if (!smd.contains(key)) continue;
                bw.append(smd.get(key));
            }
            if (design.getMetadata().containsGenomeFile()) {
                bw.append(SEPARATOR);
                bw.append(design.getMetadata().getGenomeFile());
            }
            if (design.getMetadata().containsGffFile()) {
                bw.append(SEPARATOR);
                bw.append(design.getMetadata().getGffFile());
            }
            if (design.getMetadata().containsGtfFile()) {
                bw.append(SEPARATOR);
                bw.append(design.getMetadata().getGtfFile());
            }
            if (design.getMetadata().containsAdditionalAnnotationFile()) {
                bw.append(SEPARATOR);
                bw.append(design.getMetadata().getAdditionalAnnotationFile());
            }
            if (exp != null) {
                bw.append(SEPARATOR);
                bw.append(exp.getId());
                ExperimentSample es = exp.getExperimentSample(sample);
                if (esmdk.contains("Condition")) {
                    bw.append(SEPARATOR);
                    if (es.getMetadata().containsCondition()) {
                        bw.append(es.getMetadata().getCondition());
                    }
                }
                if (esmdk.contains("RepTechGroup")) {
                    bw.append(SEPARATOR);
                    if (es.getMetadata().containsRepTechGroup()) {
                        bw.append(es.getMetadata().getRepTechGroup());
                    }
                }
                if (esmdk.contains("Reference")) {
                    bw.append(SEPARATOR);
                    if (es.getMetadata().containsReference()) {
                        bw.append(es.getMetadata().getReference());
                    }
                }
            }
            if (sampleMDKeys.contains("UUID")) {
                bw.append('\t');
                bw.append(smd.get("UUID"));
            }
            bw.append(NEWLINE);
        }
        bw.close();
    }

    boolean isWriteScanLabelsSettings() {
        return this.writeScanLabelsSettings;
    }

    void setWriteScanLabelsSettings(boolean writeScanLabelsSettings) {
        this.writeScanLabelsSettings = writeScanLabelsSettings;
    }

    public Eoulsan1DesignWriter(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.out = new FileOutputStream(file);
    }

    public Eoulsan1DesignWriter(DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.out = file.create();
    }

    public Eoulsan1DesignWriter(OutputStream out) throws IOException {
        Objects.requireNonNull(out, "out argument cannot be null");
        this.out = out;
    }

    public Eoulsan1DesignWriter(String filename) throws FileNotFoundException {
        Objects.requireNonNull(filename, "filename argument cannot be null");
        this.out = new FileOutputStream(filename);
    }
}

