/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.design.io;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignFactory;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSampleMetadata;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.design.SampleImpl;
import fr.ens.biologie.genomique.eoulsan.design.io.DesignReader;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Eoulsan2DesignReader
implements DesignReader {
    static final String SAMPLE_ID_FIELDNAME = "SampleId";
    static final String SAMPLE_NAME_FIELDNAME = "SampleName";
    static final String EXPERIMENT_FIELD_PREFIX = "Exp.";
    static final String EXPERIMENT_NAME_SUFFIX = "name";
    static final String DESIGN_FORMAT_VERSION_METADATA_KEY = "DesignFormatVersion";
    static final String FORMAT_VERSION = "2";
    static final char EQUAL_SEPARATOR = '=';
    static final char TAB_SEPARATOR = '\t';
    static final char DOT_SEPARATOR = '.';
    private final InputStream is;
    private final Splitter trimTabSplitter = Splitter.on((char)'\t').omitEmptyStrings();
    private final Splitter tabSplitter = Splitter.on((char)'\t').trimResults();
    private final Splitter dotSplitter = Splitter.on((char)'.').trimResults();

    private void parseHeader(Design design, String line) throws IOException {
        int equalPos = line.indexOf(61);
        if (equalPos == -1) {
            throw new IOException("Found a field with two values in the design file header in line: " + line);
        }
        String key = line.substring(0, equalPos).trim();
        String value = line.substring(equalPos + 1).trim();
        if ("".equals(key)) {
            throw new IOException("Found an empty field name in design file header in line: " + line);
        }
        if ("".equals(value)) {
            throw new IOException("Found an empty field value in design file header in line: " + line);
        }
        if (key.startsWith(EXPERIMENT_FIELD_PREFIX)) {
            this.readExpMetadata(key, value, design);
        } else {
            this.readDesignMetadata(key, value, design);
        }
    }

    private void readExpMetadata(String key, String value, Design design) throws IOException {
        List expField = GuavaCompatibility.splitToList((Splitter)this.dotSplitter, (CharSequence)key);
        if (expField.size() != 3) {
            throw new IOException("The experiment key is invalid.");
        }
        String expId = (String)expField.get(1);
        String expKey = (String)expField.get(2);
        if (!design.containsExperiment(expId)) {
            design.addExperiment(expId);
        }
        if (EXPERIMENT_NAME_SUFFIX.equals(expKey)) {
            design.getExperiment(expId).setName(value);
        } else {
            if (design.getExperiment(expId).getMetadata().contains(key)) {
                throw new IOException("There is two or more metadata with the same key \"" + key + "\" in the experiment: " + expId + " file header.");
            }
            design.getExperiment(expId).getMetadata().set(expKey, value);
        }
    }

    private void readDesignMetadata(String key, String value, Design design) throws IOException {
        if (DESIGN_FORMAT_VERSION_METADATA_KEY.equals(key)) {
            if (!FORMAT_VERSION.equals(value.trim())) {
                throw new IOException("Unsupported design format version: " + value);
            }
            return;
        }
        if (design.getMetadata().contains(key)) {
            throw new IOException("There is two or more metadata with the same key \"" + key + "\" in design file header.");
        }
        design.getMetadata().set(key, value);
    }

    private void parseColumns(Design design, List<String> columnNames, String line, boolean firstLine) throws IOException {
        List splitLine = GuavaCompatibility.splitToList((Splitter)this.tabSplitter, (CharSequence)line);
        if (firstLine) {
            columnNames.addAll(splitLine);
            int sampleIdPos = columnNames.indexOf(SAMPLE_ID_FIELDNAME);
            if (sampleIdPos == -1) {
                throw new IOException("Invalid file format: No \"SampleId\" field found.");
            }
            if (sampleIdPos != 0) {
                throw new IOException("Invalid file format: The \"SampleId\" field is not the first field.");
            }
            int sampleNamePos = columnNames.indexOf(SAMPLE_NAME_FIELDNAME);
            if (sampleNamePos == -1) {
                throw new IOException("Invalid file format: No \"SampleName\" field found.");
            }
            if (sampleNamePos != 1) {
                throw new IOException("Invalid file format: The \"SampleName\" field is not the second field.");
            }
        } else {
            if (splitLine.size() != columnNames.size()) {
                throw new IOException("Invalid file format: Found " + splitLine.size() + " fields whereas " + columnNames.size() + " are required in line: " + line);
            }
            String sampleId = (String)splitLine.get(0);
            String sampleName = (String)splitLine.get(1);
            SampleImpl sample = design.addSample(sampleId);
            sample.setName(sampleName);
            for (Experiment e : design.getExperiments()) {
                e.addSample(sample);
            }
            Iterator<String> nameIterator = columnNames.iterator();
            Iterator valueIterator = splitLine.iterator();
            while (nameIterator.hasNext() && valueIterator.hasNext()) {
                String columnName = nameIterator.next();
                String columnValue = (String)valueIterator.next();
                if (SAMPLE_ID_FIELDNAME.equals(columnName) || SAMPLE_NAME_FIELDNAME.equals(columnName)) continue;
                if (columnName.startsWith(EXPERIMENT_FIELD_PREFIX)) {
                    this.readExperimentSampleMetadata(columnName, columnValue, design, sample);
                    continue;
                }
                this.readSampleMetadata(columnName, columnValue, design, sample);
            }
        }
    }

    private void readSampleMetadata(String columnName, String columnValue, Design design, Sample sample) throws IOException {
        if (sample.getMetadata().contains(columnName)) {
            throw new IOException("There is two or more metadata with the same key \"" + columnName + "\" in design file header.");
        }
        sample.getMetadata().set(columnName, columnValue);
    }

    private void readExperimentSampleMetadata(String columnName, String columnValue, Design design, Sample sample) throws IOException {
        ExperimentSample experimentSample;
        ExperimentSampleMetadata experimentSampleMetadata;
        List expField = GuavaCompatibility.splitToList((Splitter)this.dotSplitter, (CharSequence)columnName);
        if (expField.size() != 3) {
            throw new IOException("The experiment key is invalid.");
        }
        String expId = (String)expField.get(1);
        String expKey = (String)expField.get(2);
        if (!design.containsExperiment(expId)) {
            throw new IOException("The experiment" + expId + "doesn't exist.");
        }
        Experiment experiment = design.getExperiment(expId);
        if (!experiment.containsSample(sample)) {
            experiment.addSample(sample);
        }
        if ((experimentSampleMetadata = (experimentSample = experiment.getExperimentSample(sample)).getMetadata()).contains(expKey)) {
            throw new IOException("There is two or more metadata with the same key \"" + expKey + "\" in design file header.");
        }
        experimentSampleMetadata.set(expKey, columnValue);
    }

    @Override
    public Design read() throws IOException {
        Design design = DesignFactory.createEmptyDesign();
        boolean header = true;
        boolean firstLine = true;
        ArrayList<String> columnNames = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.is, Globals.DEFAULT_CHARSET));
        StringBuilder lineBuffer = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            List fields;
            if (header && (fields = GuavaCompatibility.splitToList((Splitter)this.trimTabSplitter, (CharSequence)line)).size() == 1) {
                line = (String)fields.get(0);
            }
            if (header && line.endsWith("\\")) {
                lineBuffer.append(line, 0, line.length() - 1);
                continue;
            }
            lineBuffer.append(line);
            line = lineBuffer.toString();
            String trimmedLine = line.trim();
            lineBuffer.setLength(0);
            if ("".equals(trimmedLine) || trimmedLine.startsWith("#") || trimmedLine.startsWith("[")) continue;
            if (header && line.indexOf(9) != -1) {
                header = false;
            }
            if (header) {
                this.parseHeader(design, line);
                continue;
            }
            this.parseColumns(design, columnNames, line, firstLine);
            if (!firstLine) continue;
            firstLine = false;
        }
        br.close();
        return design;
    }

    public Eoulsan2DesignReader(File file) throws FileNotFoundException {
        Objects.requireNonNull(file, "the file argument cannot be null");
        this.is = new FileInputStream(file);
    }

    public Eoulsan2DesignReader(DataFile file) throws IOException {
        Objects.requireNonNull(file, "the file argument cannot be null");
        this.is = file.open();
    }

    public Eoulsan2DesignReader(InputStream is) throws IOException {
        Objects.requireNonNull(is, "the is argument cannot be null");
        this.is = is;
    }

    public Eoulsan2DesignReader(String filename) throws FileNotFoundException {
        Objects.requireNonNull(filename, "the filename argument cannot be null");
        this.is = new FileInputStream(filename);
    }
}

