/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.elements;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.galaxytools.GalaxyToolXMLParserUtils;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.AbstractParameterToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.EmptyToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.SelectParameterToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.ToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.ToolElementFactory;
import fr.ens.biologie.genomique.kenetre.util.XMLUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ConditionalToolElement
implements ToolElement {
    public static final String TYPE = "boolean";
    private final String nameSpace;
    private final ToolElement toolElementSelected;
    private final Multimap<String, ToolElement> actionsRelatedOptions;
    private final Map<String, ToolElement> toolElementResult;
    private String value;
    private boolean set;

    @Override
    public String getName() {
        return this.nameSpace;
    }

    @Override
    public String getShortName() {
        return this.nameSpace;
    }

    @Override
    public String getValidatedName() {
        throw new EoulsanRuntimeException("Name tool conditional can not be change.");
    }

    public ToolElement getToolElementSelected() {
        return this.toolElementSelected;
    }

    public Map<String, ToolElement> getToolElementsResult() {
        if (this.toolElementResult.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.toolElementResult;
    }

    public boolean isSet() {
        return this.set;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
    }

    public void setValues(Map<String, Parameter> stepParameters) throws EoulsanException {
        GalaxyToolXMLParserUtils.setElementValue(this.toolElementSelected, stepParameters);
        Collection toolParameters = this.actionsRelatedOptions.get((Object)this.toolElementSelected.getValue());
        for (ToolElement toolParameter : toolParameters) {
            GalaxyToolXMLParserUtils.setElementValue(toolParameter, stepParameters);
            this.toolElementResult.put(toolParameter.getName(), toolParameter);
        }
        this.set = true;
    }

    private Multimap<String, ToolElement> parseActionsRelatedOptions(ToolInfo toolInfo, Element element) throws EoulsanException {
        ArrayListMultimap result = ArrayListMultimap.create();
        List whenElement = XMLUtils.getElementsByTagName((Element)element, (String)"when");
        for (Element e : whenElement) {
            String whenName = e.getAttribute("value");
            ArrayList paramElement = new ArrayList();
            paramElement.addAll(XMLUtils.getElementsByTagName((Element)e, (String)"param"));
            paramElement.addAll(XMLUtils.getElementsByTagName((Element)e, (String)"data"));
            if (paramElement == null || paramElement.isEmpty()) {
                result.put((Object)whenName, (Object)new EmptyToolElement());
                continue;
            }
            for (Element elem : paramElement) {
                ToolElement toolParameter = ToolElementFactory.newToolElement(toolInfo, elem, this.nameSpace);
                if (toolParameter == null) continue;
                result.put((Object)whenName, (Object)toolParameter);
            }
        }
        return result;
    }

    public String toString() {
        return "ToolConditionalElement [name=" + this.nameSpace + ", toolParameterSelect=" + this.toolElementSelected + ", options=" + this.actionsRelatedOptions + ", parameterEoulsan=" + this.getValue() + "]";
    }

    public ConditionalToolElement(ToolInfo toolInfo, Element element) throws EoulsanException {
        this.nameSpace = element.getAttribute("name");
        List<Element> param = GalaxyToolXMLParserUtils.extractChildElementsByTagName(element, "param");
        if (param.isEmpty() || param.size() != 1) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, this.getName(), "no valid parameter element found. Only 1 element must be found in conditional element (found:  " + param.size() + ")");
        }
        if (!param.get(0).getAttribute("type").equals("select")) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, this.getName(), "no parameter with \"select\" type found in conditional element");
        }
        this.toolElementSelected = new SelectParameterToolElement(toolInfo, param.get(0), this.nameSpace);
        if (this.toolElementSelected instanceof AbstractParameterToolElement && ((AbstractParameterToolElement)this.toolElementSelected).isSet()) {
            this.value = this.toolElementSelected.getValue();
        }
        this.actionsRelatedOptions = this.parseActionsRelatedOptions(toolInfo, element);
        this.toolElementResult = new HashMap<String, ToolElement>();
    }
}

