/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.elements;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.galaxytools.GalaxyToolXMLParserUtils;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.AbstractToolElement;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.util.List;
import org.w3c.dom.Element;

public class DataToolElement
extends AbstractToolElement {
    public static final String TAG_NAME = "data";
    public static final String TYPE = "data";
    private final List<String> formats;
    private final DataFormat dataFormat;
    private String value = "";

    @Override
    public String getValue() {
        return this.value;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public DataToolElement(ToolInfo toolInfo, Element param, String nameSpace) throws EoulsanException {
        super(param, nameSpace);
        this.formats = GuavaCompatibility.splitToList((Splitter)COMMA, (CharSequence)param.getAttribute("format"));
        if (this.formats.size() > 1) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, this.getName(), "more one format data found (" + Joiner.on((String)",").join(this.formats) + ")");
        }
        if (this.formats.isEmpty()) {
            this.dataFormat = null;
            throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, this.getName(), "no format found");
        }
        String format = this.formats.get(0);
        this.dataFormat = DataFormatRegistry.getInstance().getDataFormatFromGalaxyFormatNameOrNameOrAlias(format);
        if (this.dataFormat == null) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, this.getName(), "unknown format: " + format);
        }
    }
}

