/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.elements;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.galaxytools.GalaxyToolXMLParserUtils;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.TextParameterToolElement;
import org.w3c.dom.Element;

public class IntegerParameterToolElement
extends TextParameterToolElement {
    public static final String TYPE = "integer";
    private static final String ATT_MIN_KEY = "min";
    private static final String ATT_MAX_KEY = "max";
    private final int min;
    private final int max;
    private final ToolInfo toolInfo;

    @Override
    public boolean isParameterValueValid() {
        int v;
        try {
            v = Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return v >= this.min && v <= this.max;
    }

    @Override
    public void setValue(String value) throws EoulsanException {
        super.setValue(value);
        if (!this.isParameterValueValid()) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(this.toolInfo, this.getName(), "invalid value for parameter: " + this.getValue() + " (the value must be in interval [" + this.min + " - " + this.max + "])");
        }
    }

    @Override
    public String toString() {
        return "ToolParameterInteger [min=" + this.min + ", max=" + this.max + ", value=" + this.getValue() + "]";
    }

    public IntegerParameterToolElement(ToolInfo toolInfo, Element param) throws EoulsanException {
        this(toolInfo, param, null);
    }

    public IntegerParameterToolElement(ToolInfo toolInfo, Element param, String nameSpace) throws EoulsanException {
        super(toolInfo, param, nameSpace);
        this.toolInfo = toolInfo;
        String value = param.getAttribute(ATT_MIN_KEY);
        try {
            this.min = value.isEmpty() ? Integer.MIN_VALUE : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, this.getName(), "Failed to extract min value: " + value);
        }
        value = param.getAttribute(ATT_MAX_KEY);
        try {
            this.max = value.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, this.getName(), "Failed to extract max value: " + value);
        }
    }
}

