/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.elements;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.galaxytools.GalaxyToolXMLParserUtils;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.AbstractParameterToolElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class SelectParameterToolElement
extends AbstractParameterToolElement {
    public static final String TYPE = "select";
    private static final String ATT_SELECTED_KEY = "selected";
    private static final String ATT_VALUE_KEY = "value";
    private final List<String> optionsValue;
    private final List<Element> optionsElement;
    private String value = "";
    private boolean set;
    private final ToolInfo toolInfo;

    @Override
    public boolean isParameterValueValid() {
        return this.optionsValue.contains(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isSet() {
        return this.set;
    }

    @Override
    public void setValue(String value) throws EoulsanException {
        this.value = value;
        this.set = true;
        if (!this.isParameterValueValid()) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(this.toolInfo, this.getName(), "The \"" + this.value + "\" value is invalid. Available values are: " + Joiner.on((String)",").join(this.optionsValue));
        }
    }

    private List<String> extractAllOptions() throws EoulsanException {
        ArrayList<String> options = new ArrayList<String>();
        for (Element e : this.optionsElement) {
            options.add(e.getAttribute(ATT_VALUE_KEY));
            String attributeSelected = e.getAttribute(ATT_SELECTED_KEY);
            if (attributeSelected.isEmpty()) continue;
            this.value = e.getAttribute(ATT_VALUE_KEY);
            this.set = true;
        }
        if (options.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(options);
    }

    @Override
    public String toString() {
        return "ToolParameterSelect [" + super.toString() + "]";
    }

    public SelectParameterToolElement(ToolInfo toolInfo, Element param) throws EoulsanException {
        this(toolInfo, param, null);
    }

    public SelectParameterToolElement(ToolInfo toolInfo, Element param, String nameSpace) throws EoulsanException {
        super(param, nameSpace);
        this.toolInfo = toolInfo;
        this.optionsElement = GalaxyToolXMLParserUtils.extractChildElementsByTagName(param, "option");
        this.optionsValue = this.extractAllOptions();
    }
}

