/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.elements;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.galaxytools.GalaxyToolXMLParserUtils;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolInfo;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.AbstractToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.BooleanParameterToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.DataToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.FloatParameterToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.IntegerParameterToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.SelectParameterToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.TextParameterToolElement;
import fr.ens.biologie.genomique.eoulsan.galaxytools.elements.ToolElement;
import org.w3c.dom.Element;

public class ToolElementFactory {
    public static ToolElement newToolElement(ToolInfo toolInfo, Element param) throws EoulsanException {
        return ToolElementFactory.newToolElement(toolInfo, param, null);
    }

    public static ToolElement newToolElement(ToolInfo toolInfo, Element tag, String nameSpace) throws EoulsanException {
        AbstractToolElement toolElement;
        String type;
        if (tag == null) {
            throw GalaxyToolXMLParserUtils.newEoulsanException(toolInfo, "no element found to instantiate a tool element");
        }
        String tagName = tag.getTagName();
        if (tagName.equals("data")) {
            return new DataToolElement(toolInfo, tag, nameSpace);
        }
        switch (type = tag.getAttribute("type").toLowerCase(Globals.DEFAULT_LOCALE)) {
            case "boolean": {
                toolElement = new BooleanParameterToolElement(toolInfo, tag, nameSpace);
                break;
            }
            case "integer": {
                toolElement = new IntegerParameterToolElement(toolInfo, tag, nameSpace);
                break;
            }
            case "float": {
                toolElement = new FloatParameterToolElement(toolInfo, tag, nameSpace);
                break;
            }
            case "select": {
                toolElement = new SelectParameterToolElement(toolInfo, tag, nameSpace);
                break;
            }
            case "text": {
                toolElement = new TextParameterToolElement(toolInfo, tag, nameSpace);
                break;
            }
            case "data": {
                toolElement = new DataToolElement(toolInfo, tag, nameSpace);
                break;
            }
            default: {
                throw new EoulsanException("Unknown parameter type:" + type);
            }
        }
        return toolElement;
    }
}

