/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.galaxytools.ToolExecutorResult;
import fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters.ExecutorInterpreter;
import fr.ens.biologie.genomique.kenetre.util.process.SimpleProcess;
import fr.ens.biologie.genomique.kenetre.util.process.SystemSimpleProcess;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public abstract class AbstractExecutorInterpreter
implements ExecutorInterpreter {
    protected SimpleProcess newSimpleProcess() throws IOException {
        return new SystemSimpleProcess();
    }

    @Override
    public ToolExecutorResult execute(List<String> commandLine, File executionDirectory, File temporaryDirectory, File stdoutFile, File stderrFile, File ... filesUsed) throws IOException {
        Objects.requireNonNull(commandLine, "commandLine argument cannot be null");
        Objects.requireNonNull(executionDirectory, "executionDirectory argument cannot be null");
        Objects.requireNonNull(stdoutFile, "stdoutFile argument cannot be null");
        Objects.requireNonNull(stderrFile, "stderrFile argument cannot be null");
        Preconditions.checkArgument((!commandLine.isEmpty() ? 1 : 0) != 0, (Object)"commandLine argument cannot be empty");
        Preconditions.checkArgument((boolean)executionDirectory.isDirectory(), (Object)("execution directory does not exists or is not a directory: " + executionDirectory.getAbsolutePath()));
        int exitValue = this.newSimpleProcess().execute(commandLine, executionDirectory, temporaryDirectory, stdoutFile, stderrFile, filesUsed);
        return new ToolExecutorResult(commandLine, exitValue);
    }
}

