/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters;

import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.galaxytools.executorinterpreters.AbstractExecutorInterpreter;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GenericExecutorInterpreter
extends AbstractExecutorInterpreter {
    private static final String GALAXY_TOOL_INTERPRETER_SETTING_PREFIX = "main.galaxy.tool.interpreter.";
    private final String name;
    private final File path;

    @Override
    public String getName() {
        return this.name;
    }

    protected File getInterpreterPath() {
        return this.path;
    }

    @Override
    public List<String> createCommandLine(String arguments) {
        Objects.requireNonNull(arguments, "arguments argument cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getInterpreterPath().getAbsolutePath());
        result.addAll(StringUtils.splitShellCommandLine((String)arguments));
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("path", (Object)this.path).toString();
    }

    private static File getInterpreterPathFromConfiguration(String interpreterName) {
        String value = EoulsanRuntime.getSettings().getSetting(GALAXY_TOOL_INTERPRETER_SETTING_PREFIX + interpreterName);
        return value != null ? new File(value) : null;
    }

    public GenericExecutorInterpreter(String interpreterName) {
        Objects.requireNonNull(interpreterName, "interpreterName argument cannot be null");
        this.name = interpreterName;
        File path = GenericExecutorInterpreter.getInterpreterPathFromConfiguration(interpreterName);
        if (path == null) {
            path = SystemUtils.searchExecutableInPATH((String)interpreterName);
        }
        if (path == null) {
            path = new File("/usr/bin/" + interpreterName);
        }
        this.path = path;
    }
}

