/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.io;

import java.io.IOException;
import java.io.InputStream;

public class MaxByteInputStream
extends InputStream {
    private final InputStream in;
    private final long max;
    private long nRead = 0L;

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        if (this.nRead == this.max) {
            return -1;
        }
        int c = this.in.read();
        if (c >= 0) {
            ++this.nRead;
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.nRead == this.max) {
            return -1;
        }
        int l = this.nRead + (long)len > this.max ? (int)(this.max - this.nRead) : len;
        int nr = this.in.read(b, off, l);
        if (nr > 0) {
            this.nRead += (long)nr;
        }
        return nr;
    }

    public MaxByteInputStream(InputStream in, long max) {
        if (in == null) {
            throw new NullPointerException("InputStream is null");
        }
        if (max < 1L) {
            throw new IllegalArgumentException("Max length cannot be lower than 1: " + max);
        }
        this.in = in;
        this.max = max;
    }
}

