/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.io;

import fr.ens.biologie.genomique.eoulsan.io.AbstractConcatInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class PathConcatInputStream
extends AbstractConcatInputStream {
    private final Iterator<Path> it;
    private final Configuration conf;

    @Override
    protected boolean hasNextInputStream() {
        return this.it.hasNext();
    }

    @Override
    protected InputStream nextInputStream() throws IOException {
        Path path = this.it.next();
        if (path == null) {
            throw new IOException("path is null");
        }
        FileSystem fs = path.getFileSystem(this.conf);
        return fs.open(path);
    }

    public PathConcatInputStream(List<Path> paths, Configuration conf) {
        Objects.requireNonNull(paths, "paths is null");
        Objects.requireNonNull(conf, "conf is null");
        this.it = paths.iterator();
        this.conf = conf;
    }
}

