/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hadoop.mapreduce.Counter;

public final class ProgressCounterOutputStream
extends OutputStream {
    private static final int MAX = 0x6400000;
    private final OutputStream out;
    private final Counter counter;
    private int sum;

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incrementCounter(len);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.out.write(b);
        this.incrementCounter(b.length);
    }

    @Override
    public final void write(int b) throws IOException {
        this.out.write(b);
        this.incrementCounter(1);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public final void close() throws IOException {
        this.out.flush();
        this.out.close();
        this.counter.increment((long)this.sum);
    }

    private void incrementCounter(int bytes) {
        this.sum += bytes;
        if (this.sum > 0x6400000) {
            this.counter.increment((long)this.sum);
            this.sum = 0;
        }
    }

    public ProgressCounterOutputStream(OutputStream os, Counter counter) {
        Objects.requireNonNull(os, "OutputStream is null");
        Objects.requireNonNull(counter, "The counter to use is null.");
        this.out = os;
        this.counter = counter;
    }
}

