/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.checkers.CheckStore;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.DataUtils;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPort;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@LocalOnly
@ReuseModuleInstance
public class CheckerModule
extends AbstractModule {
    public static final String MODULE_NAME = "checker";
    private static CheckerModule instance;
    private final Map<DataFormat, Checker> checkers = new HashMap<DataFormat, Checker>();
    private final Map<DataFormat, Set<Parameter>> checkerConfiguration = new HashMap<DataFormat, Set<Parameter>>();
    private InputPorts inputPorts = InputPortsBuilder.noInputPort();
    private boolean inputPortsConfigured;

    void configureInputPorts(OutputPorts designOutputPorts) {
        Preconditions.checkState((!this.inputPortsConfigured ? 1 : 0) != 0, (Object)"inputPorts has been already configured");
        InputPortsBuilder builder = new InputPortsBuilder();
        for (OutputPort port : designOutputPorts) {
            String portName = port.getName();
            DataFormat format = port.getFormat();
            if (!format.isChecker() || this.checkers.containsKey(format)) continue;
            builder.addPort(portName, true, format);
            this.checkers.put(format, format.getChecker());
        }
        this.inputPorts = builder.create();
        this.inputPortsConfigured = true;
    }

    public static void configureChecker(DataFormat format, Set<Parameter> parameters) {
        Objects.requireNonNull(format, "format argument cannot be null");
        Objects.requireNonNull(parameters, "parameter argument cannot be null");
        Preconditions.checkArgument((boolean)format.isChecker(), (Object)("No checker exists for format: " + format.getName()));
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Instance of CheckerModule has not been yet created");
        CheckerModule.instance.checkerConfiguration.put(format, Sets.newHashSet(parameters));
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return this.inputPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        CheckStore checkStore = CheckStore.getCheckStore();
        checkStore.add("design", context.getWorkflow().getDesign());
        int count = 0;
        try {
            List<Checker> checkerList = this.createDependenciesList(context.getWorkflow().getSteps());
            for (Checker checker : checkerList) {
                if (checker.isDesignChecker()) {
                    context.getLogger().info("Start checker " + checker.getName());
                    checker.check(null, checkStore);
                    context.getLogger().info("End of checker " + checker.getName());
                } else {
                    DataFormat format = checker.getFormat();
                    if (this.checkerConfiguration.containsKey(format)) {
                        checker.configure(this.checkerConfiguration.get(format));
                    }
                    for (Data data : context.getInputData(format).getListElements()) {
                        context.getLogger().info("Start checker " + checker.getName() + " to check: " + DataUtils.getDataFiles(data));
                        checker.check(data, checkStore);
                        context.getLogger().info("End of checker " + checker.getName() + " to check: " + DataUtils.getDataFiles(data));
                    }
                }
                status.setProgress((double)(++count) / (double)checkerList.size());
            }
        }
        catch (EoulsanException e) {
            TaskResult taskResult = status.createTaskResult(e);
            return taskResult;
        }
        finally {
            this.checkers.clear();
            this.checkerConfiguration.clear();
        }
        return status.createTaskResult();
    }

    private List<Checker> createDependenciesList(Set<Step> steps) throws EoulsanException {
        ArrayList list = Lists.newArrayList(this.checkers.values());
        ArrayList<Checker> result = new ArrayList<Checker>();
        HashMap dependencies = new HashMap();
        HashSet<Checker> added = new HashSet<Checker>();
        for (Step s : steps) {
            Checker checker = s.getChecker();
            if (checker == null) continue;
            list.add(checker);
        }
        for (Checker c : list) {
            if (c == null) continue;
            HashSet<Checker> deps = new HashSet<Checker>();
            if (!c.isDesignChecker()) {
                for (DataFormat format : c.getCheckersRequired()) {
                    if (!this.checkers.containsKey(format)) continue;
                    deps.add(this.checkers.get(format));
                }
            }
            if (deps.size() == 0) {
                result.add(c);
                added.add(c);
                continue;
            }
            dependencies.put(c, deps);
        }
        while (result.size() != list.size()) {
            HashSet<Checker> toRemove = new HashSet<Checker>();
            for (Map.Entry e : dependencies.entrySet()) {
                ((Set)e.getValue()).removeAll(added);
                if (((Set)e.getValue()).size() != 0) continue;
                toRemove.add((Checker)e.getKey());
            }
            if (toRemove.size() == 0) {
                throw new EoulsanException("Unable to resolve checker dependencies");
            }
            for (Checker c : toRemove) {
                dependencies.remove(c);
                result.add(c);
                added.add(c);
            }
        }
        return result;
    }

    public CheckerModule() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Instance of CheckerModule has been already created");
        instance = this;
    }
}

