/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.NoLog;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.core.DataUtils;
import fr.ens.biologie.genomique.eoulsan.core.FileNaming;
import fr.ens.biologie.genomique.eoulsan.core.FileNamingParsingRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.core.workflow.DataMetadataStorage;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@LocalOnly
@ReuseModuleInstance
@NoLog
public class ImportModule
extends AbstractModule {
    public static final String MODULE_NAME = "import";
    private Set<DataFile> files;
    private OutputPorts outputPorts;
    private boolean copy;
    private DataFormat format;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public OutputPorts getOutputPorts() {
        return this.outputPorts;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        DataFile baseDir = context.getOutputDirectory();
        String pattern = "";
        block14: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "files": {
                    pattern = p.getStringValue();
                    continue block14;
                }
                case "directory": {
                    Modules.deprecatedParameter(context, p, true);
                    continue block14;
                }
                case "copy": {
                    this.copy = p.getBooleanValue();
                    continue block14;
                }
                case "format": {
                    this.format = DataFormatRegistry.getInstance().getDataFormatFromGalaxyFormatNameOrNameOrAlias(p.getValue());
                    if (this.format != null) continue block14;
                    Modules.badParameterValue(context, p, "Unknown format");
                    continue block14;
                }
            }
            Modules.unknownParameter(context, p);
        }
        try {
            Map<DataFormat, CompressionType> formats;
            if (!baseDir.exists() || !baseDir.getMetaData().isDir()) {
                Modules.invalidConfiguration(context, "The directory does not exists: " + baseDir);
            }
            this.files = ImportModule.findFiles(baseDir, pattern);
            if (this.files.isEmpty()) {
                Modules.invalidConfiguration(context, "No input file found in the " + this.getName() + " step");
            }
            if ((formats = ImportModule.listDataFormatFromFileList(this.files, this.format)).isEmpty()) {
                Modules.invalidConfiguration(context, "No format found for the files matching to the pattern");
            }
            if (formats.size() > 1) {
                Modules.invalidConfiguration(context, "More than one file format found for the files matching to the pattern");
            }
            OutputPortsBuilder builder = new OutputPortsBuilder();
            for (Map.Entry entry : formats.entrySet()) {
                builder.addPort("output", true, (DataFormat)entry.getKey(), (CompressionType)entry.getValue());
            }
            this.outputPorts = builder.create();
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        DataFormatRegistry registry = DataFormatRegistry.getInstance();
        HashMap<String, Sample> samples = new HashMap<String, Sample>();
        for (Sample sample : context.getWorkflow().getDesign().getSamples()) {
            samples.put(Naming.toValidName(sample.getId()), sample);
        }
        try {
            ArrayList<DataFile> sortedFiles = new ArrayList<DataFile>(this.files);
            Collections.sort(sortedFiles);
            Set<List<DataFile>> groupedFiles = ImportModule.groupFiles(registry, this.files);
            for (List<DataFile> inputFiles : groupedFiles) {
                Data data = null;
                for (DataFile inputFile : inputFiles) {
                    DataFormat format = this.format == null ? ImportModule.fileFormat(registry, inputFile) : this.format;
                    FileNaming fileNaming = ImportModule.fileNaming(inputFile);
                    if (data == null) {
                        if (fileNaming != null) {
                            data = context.getOutputData(format, format.getPrefix()).addDataToList(fileNaming.getDataName(), fileNaming.getPart());
                            boolean isMetadataSet = DataMetadataStorage.getInstance(context.getOutputDirectory()).loadMetadata(data, Collections.singletonList(inputFile));
                            if (!isMetadataSet && samples.containsKey(data.getName())) {
                                DataUtils.setDataMetaData(data, (Sample)samples.get(data.getName()));
                            }
                        } else {
                            String dataName = Naming.toValidName(inputFile.getBasename());
                            data = context.getOutputData(format, format.getPrefix()).addDataToList(dataName);
                        }
                    }
                    DataFile outputFile = format.getMaxFilesCount() > 1 ? (fileNaming != null ? data.getDataFile(fileNaming.getFileIndex()) : data.getDataFile(0)) : data.getDataFile();
                    if (this.copy) {
                        DataFiles.copy(inputFile, outputFile);
                        continue;
                    }
                    DataFiles.symlinkOrCopy(inputFile, outputFile, true);
                }
                DataMetadataStorage.getInstance(context.getOutputDirectory()).loadMetadata(data, inputFiles);
            }
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }

    private static Path getMinExistingPath(String path) {
        Path p;
        File f;
        File result = new File("/");
        Iterator<Path> iterator = new File(path).toPath().iterator();
        while (iterator.hasNext() && (f = new File(result, (p = iterator.next()).toString())).exists()) {
            result = f;
        }
        return result.toPath();
    }

    private static Set<DataFile> findFiles(DataFile workingDirectory, String pattern) throws IOException {
        Objects.requireNonNull(workingDirectory, "workingDirectory argument cannot be null");
        Objects.requireNonNull(pattern, "pattern argument cannot be null");
        File dir = workingDirectory.toFile();
        String finalPattern = pattern;
        String dirSuffix = ImportModule.patternPrefix(pattern);
        if (!dirSuffix.isEmpty()) {
            dir = new File(dir, dirSuffix);
            finalPattern = finalPattern.substring(dirSuffix.length() + 1);
        }
        Finder finder = new Finder(dir, finalPattern);
        Path baseDir = finalPattern.startsWith("/") ? ImportModule.getMinExistingPath(finalPattern) : dir.toPath();
        Files.walkFileTree(baseDir, finder);
        return finder.getFiles();
    }

    private static Map<DataFormat, CompressionType> listDataFormatFromFileList(Set<DataFile> files, DataFormat format) throws EoulsanException {
        if (files == null) {
            return Collections.emptyMap();
        }
        HashMap<DataFormat, CompressionType> result = new HashMap<DataFormat, CompressionType>();
        DataFormatRegistry registry = DataFormatRegistry.getInstance();
        for (DataFile file : files) {
            DataFormat fileFormat = format == null ? ImportModule.fileFormat(registry, file) : format;
            CompressionType compression = file.getCompressionType();
            CompressionType previous = (CompressionType)result.get(fileFormat);
            if (previous != null && previous != CompressionType.NONE) continue;
            result.put(fileFormat, compression);
        }
        return Collections.unmodifiableMap(result);
    }

    private static DataFormat fileFormat(DataFormatRegistry registry, DataFile file) throws EoulsanException {
        try {
            FileNaming name = FileNaming.parse(file);
            return name.getFormat();
        }
        catch (FileNamingParsingRuntimeException e) {
            String extension = file.getExtension();
            Set<DataFormat> formats = registry.getDataFormatsFromExtension(extension);
            if (formats.isEmpty()) {
                throw new EoulsanException("No format found for file: " + file);
            }
            if (formats.size() > 1) {
                throw new EoulsanException("More than one format found for file: " + file);
            }
            return formats.iterator().next();
        }
    }

    private static FileNaming fileNaming(DataFile file) {
        try {
            return FileNaming.parse(file);
        }
        catch (FileNamingParsingRuntimeException e) {
            return null;
        }
    }

    private static Set<List<DataFile>> groupFiles(DataFormatRegistry registry, Set<DataFile> files) {
        HashSet result = new HashSet();
        ArrayList<DataFile> group = new ArrayList<DataFile>();
        DataFile previous = null;
        ArrayList<DataFile> sortedFiles = new ArrayList<DataFile>(files);
        Collections.sort(sortedFiles);
        for (DataFile file : sortedFiles) {
            if (group.isEmpty() || FileNaming.dataEquals(previous, file)) {
                group.add(file);
            } else {
                result.add(group);
                group = new ArrayList();
                group.add(file);
            }
            previous = file;
        }
        if (!group.isEmpty()) {
            result.add(group);
        }
        return Collections.unmodifiableSet(result);
    }

    private static String patternPrefix(String pattern) {
        if (pattern == null || pattern.startsWith("/")) {
            return "";
        }
        List<String> elements = Arrays.asList(pattern.split("/"));
        int index = elements.lastIndexOf("..");
        if (index == -1) {
            return "";
        }
        return String.join((CharSequence)"/", elements.subList(0, index + 1));
    }

    private static class Finder
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher;
        private final Set<File> files = new HashSet<File>();

        private void find(Path file) {
            if (this.matcher.matches(file.toAbsolutePath())) {
                this.files.add(file.toFile());
            }
        }

        Set<DataFile> getFiles() {
            HashSet<DataFile> result = new HashSet<DataFile>();
            for (File f : this.files) {
                result.add(new DataFile(f));
            }
            return result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            this.find(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            this.find(dir);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        Finder(File workingDirectory, String pattern) {
            String finalPattern = !pattern.startsWith("/") ? workingDirectory.getAbsolutePath() + "/" + pattern : pattern;
            this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + finalPattern);
        }
    }
}

