/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.NoOutputDirectory;
import fr.ens.biologie.genomique.eoulsan.annotations.RequiresAllPreviousSteps;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.Set;

@LocalOnly
@RequiresAllPreviousSteps
@NoOutputDirectory
public class ShellModule
extends AbstractModule {
    private static final String MODULE_NAME = "shell";
    private String command;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "This module allow to execute shell commands";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block6: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "command": {
                    this.command = p.getValue();
                    continue block6;
                }
            }
            Modules.unknownParameter(context, p);
        }
        if (this.command == null || this.command.trim().isEmpty()) {
            Modules.invalidConfiguration(context, "No command defined");
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            String shellInterpreter = System.getenv("SHELL");
            if (shellInterpreter == null) {
                shellInterpreter = "/bin/sh";
            }
            EoulsanLogger.getLogger().info("Execute: " + this.command);
            EoulsanLogger.getLogger().info("Shell interpreter: " + shellInterpreter);
            ProcessBuilder pb = new ProcessBuilder(shellInterpreter, "-c", this.command);
            status.setCommandLine(String.join((CharSequence)" ", pb.command()));
            int exitCode = pb.start().waitFor();
            if (exitCode != 0) {
                throw new IOException("Finish process with exit code: " + exitCode);
            }
            return status.createTaskResult();
        }
        catch (IOException | InterruptedException e) {
            return status.createTaskResult(e, "Error while running command (" + this.command + "): " + e.getMessage());
        }
    }
}

