/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import picard.sam.MergeSamFiles;

@LocalOnly
public class MergeInputRepLocalModule
extends AbstractModule {
    private static final String STEP_NAME = "mergeinput";

    @Override
    public String getName() {
        return STEP_NAME;
    }

    @Override
    public String getDescription() {
        return "This step merges Input files for each experiment. It uses Picard's MergeSamFiles.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("input", true, DataFormats.MAPPER_RESULTS_SAM);
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        OutputPortsBuilder builder = new OutputPortsBuilder();
        builder.addPort("output", true, DataFormats.MAPPER_RESULTS_SAM);
        return builder.create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        Iterator<Parameter> iterator = stepParameters.iterator();
        if (iterator.hasNext()) {
            Parameter p = iterator.next();
            EoulsanLogger.getLogger().info("MergeInputRep parameter: " + p.getName() + " : " + p.getStringValue());
            throw new EoulsanException("Unknown parameter for " + this.getName() + " step: " + p.getName());
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data outputData;
        Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
        Data outputDataList = context.getOutputData(DataFormats.MAPPER_RESULTS_SAM, "mergedinput");
        HashMap referenceSamples = new HashMap();
        for (Data anInputData : inData.getListElements()) {
            EoulsanLogger.getLogger().finest("Input file. ref : " + anInputData.getMetadata().get("Reference") + "| exp : " + anInputData.getMetadata().get("Experiment") + "| rep : " + anInputData.getMetadata().get("RepTechGroup"));
            boolean isReference = anInputData.getMetadata().get("Reference").toLowerCase().equals("true");
            if (isReference) {
                String experimentName = anInputData.getMetadata().get("Experiment");
                if (referenceSamples.containsKey(experimentName) && referenceSamples.get(experimentName) != null) {
                    ((List)referenceSamples.get(experimentName)).add(anInputData);
                    continue;
                }
                ArrayList<Data> tmpList = new ArrayList<Data>();
                tmpList.add(anInputData);
                referenceSamples.put(experimentName, tmpList);
                continue;
            }
            outputData = outputDataList.addDataToList(anInputData.getMetadata().get("Name").replaceAll("[^a-zA-Z0-9]", ""));
            outputData.getMetadata().set(anInputData.getMetadata());
            try {
                anInputData.getDataFile().symlink(outputData.getDataFile());
            }
            catch (IOException ioe) {
                EoulsanLogger.getLogger().severe("Could not create symlink from " + anInputData.getDataFile() + " to " + outputData.getDataFile());
                return status.createTaskResult();
            }
        }
        for (String experimentName : referenceSamples.keySet()) {
            List expData = (List)referenceSamples.get(experimentName);
            if (expData.size() == 1) {
                Data inputData = (Data)expData.get(0);
                Data outputData2 = outputDataList.addDataToList(inputData.getMetadata().get("Name").replaceAll("[^a-zA-Z0-9]", ""));
                outputData2.getMetadata().set(inputData.getMetadata());
                try {
                    inputData.getDataFile().symlink(outputData2.getDataFile());
                }
                catch (IOException ioe) {
                    EoulsanLogger.getLogger().severe("Could not create symlink from " + inputData.getDataFile() + " to " + outputData2.getDataFile());
                    return status.createTaskResult();
                }
            }
            if (expData.size() <= 2) continue;
            EoulsanLogger.getLogger().info("Running Picard's MergeSamFiles for experiment  " + experimentName);
            outputData = outputDataList.addDataToList(((Data)expData.get(0)).getMetadata().get("Name").replaceAll("[^a-zA-Z0-9]", ""));
            outputData.getMetadata().set(((Data)expData.get(0)).getMetadata());
            String[] arguments = new String[expData.size() + 2];
            arguments[0] = "OUTPUT=" + outputData.getDataFile();
            arguments[1] = "QUIET=true";
            int startPos = 2;
            for (Data anInputData : expData) {
                arguments[startPos++] = "INPUT=" + anInputData.getDataFile();
            }
            new MergeSamFiles().instanceMain(arguments);
        }
        return status.createTaskResult();
    }
}

