/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import picard.sam.SortSam;
import picard.sam.markduplicates.MarkDuplicates;

@LocalOnly
public class RmDupLocalModule
extends AbstractModule {
    private static final String STEP_NAME = "rmdup";
    protected static final String COUNTER_GROUP = "rmdup";
    private boolean delete = true;
    private boolean sort = true;

    @Override
    public String getName() {
        return "rmdup";
    }

    @Override
    public String getDescription() {
        return "This step removes PCR duplicates from a SAM file. It uses Picard's MarkDuplicates to either mark or remove them.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block8: for (Parameter p : stepParameters) {
            switch (p.getName().toLowerCase()) {
                case "remove.marked": {
                    this.delete = p.getBooleanValue();
                    continue block8;
                }
                case "sort": {
                    this.sort = p.getBooleanValue();
                    continue block8;
                }
            }
            Modules.unknownParameter(context, p);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
        Data outData = context.getOutputData(DataFormats.MAPPER_RESULTS_SAM, inData);
        DataFile samFile = inData.getDataFile();
        DataFile outputFile = outData.getDataFile();
        File inputFile = samFile.toFile();
        if (this.sort) {
            try {
                File tmpSortFile = FileUtils.createTempFile((File)context.getRuntime().getSettings().getTempDirectoryFile(), (String)"rmdupsort", (String)".sam");
                EoulsanLogger.getLogger().info("Running Picard's SortSam on " + inputFile + " with output " + tmpSortFile);
                String[] sortArguments = new String[]{"INPUT=" + inputFile, "OUTPUT=" + tmpSortFile, "SORT_ORDER=coordinate", "QUIET=true"};
                new SortSam().instanceMain(sortArguments);
                inputFile = tmpSortFile;
            }
            catch (IOException ioe) {
                return status.createTaskResult();
            }
        }
        EoulsanLogger.getLogger().info("Running Picard's MarkDuplicates on " + inputFile + " with output " + outputFile);
        String[] arguments = new String[]{"INPUT=" + inputFile, "OUTPUT=" + outputFile, "REMOVE_DUPLICATES=" + this.delete, "ASSUME_SORTED=true", "METRICS_FILE=" + outputFile + ".picard_metrics", "QUIET=true"};
        new MarkDuplicates().instanceMain(arguments);
        if (this.sort) {
            inputFile.delete();
        }
        return status.createTaskResult();
    }
}

