/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@LocalOnly
public class TrackHubModule
extends AbstractModule {
    private String shortLabel = "shortLabel";
    private String longLabel = "longLabel";
    private String email = "email";
    private String genome = "genome";
    private String server = "http://server/";
    private String bigDataUrl = "URLPath";
    private boolean multiWIG = false;

    @Override
    public String getName() {
        return "trackhub";
    }

    @Override
    public String getDescription() {
        return "This step construct trackhub based on the experimental design.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("inputbigwig", true, DataFormats.BIGWIG);
        builder.addPort("inputbigbed", true, DataFormats.BIGBED);
        return builder.create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block17: for (Parameter p : stepParameters) {
            switch (p.getLowerStringValue()) {
                case "shortlabel.name": {
                    this.shortLabel = p.getStringValue();
                    continue block17;
                }
                case "longlabel.name": {
                    this.longLabel = p.getStringValue();
                    continue block17;
                }
                case "e.mail": 
                case "email": {
                    this.email = p.getStringValue();
                    continue block17;
                }
                case "data.path": {
                    this.bigDataUrl = p.getStringValue();
                    continue block17;
                }
                case "multi.wig": {
                    this.multiWIG = p.getBooleanValue();
                    continue block17;
                }
                case "server.name": {
                    this.server = p.getStringValue();
                    continue block17;
                }
            }
            Modules.unknownParameter(context, p);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Design design = context.getWorkflow().getDesign();
        String date = new SimpleDateFormat("yyyy_MM_dd").format(new Date());
        Data BigWigData = context.getInputData(DataFormats.BIGWIG);
        Data BigBedData = context.getInputData(DataFormats.BIGBED);
        HashMap<String, Data> nameMapBigWig = new HashMap<String, Data>();
        for (Data data : BigWigData.getListElements()) {
            String name = data.getMetadata().getSampleName();
            nameMapBigWig.put(name, data);
        }
        HashMap<String, Data> nameMapBIGBED = new HashMap<String, Data>();
        for (Data anInputData : BigBedData.getListElements()) {
            String name = anInputData.getMetadata().getSampleName();
            nameMapBIGBED.put(name, anInputData);
        }
        File file = new File(date + "_" + this.shortLabel);
        try {
            this.createTrack(file, design, date, nameMapBigWig, nameMapBIGBED);
        }
        catch (IOException e) {
            status.createTaskResult(e);
        }
        return status.createTaskResult();
    }

    private void createTrack(File dir, Design design, String date, Map<String, Data> nameMapBigWig, Map<String, Data> nameMapBigBed) throws IOException {
        if (dir.exists()) {
            throw new IOException("The output folder " + dir.getAbsolutePath() + " already exists");
        }
        if (!dir.mkdir()) {
            throw new IOException("Fail to create the folder : " + dir.getAbsolutePath());
        }
        File genomeDirectory = new File(dir, this.genome);
        if (!genomeDirectory.mkdir()) {
            throw new IOException("Fail to create the folder : " + dir.getAbsolutePath());
        }
        this.writeHubFile(dir, date);
        this.writeGenomeFile(dir);
        this.writeTrackDb(genomeDirectory, design, nameMapBigWig, nameMapBigBed);
    }

    private void writeHubFile(File dir, String date) throws IOException {
        try (FileWriter w = new FileWriter(new File(dir, "hub.txt"), Charset.defaultCharset());){
            w.write("hub " + date + "_" + this.shortLabel + "\n");
            w.write("shortLabel " + this.shortLabel + "\n");
            w.write("longLabel " + this.longLabel + "\n");
            w.write("genomesFile genomes.txt\n");
            w.write("email " + this.email + "\n");
        }
    }

    private void writeGenomeFile(File dir) throws IOException {
        try (FileWriter w = new FileWriter(new File(dir, "genomes.txt"), Charset.defaultCharset());){
            w.write("genome " + this.genome + "\n");
            w.write("trackDb ./" + this.genome + "/trackDb.txt");
        }
    }

    private void writeTrackDb(File genomeDirectory, Design design, Map<String, Data> nameMapBigWig, Map<String, Data> nameMapBigBed) throws IOException {
        int priorityTrack = 1;
        StringBuilder sb = new StringBuilder();
        for (Experiment e : design.getExperiments()) {
            if (this.multiWIG) {
                priorityTrack = this.addMultiWigTrackDbHeader(sb, e, priorityTrack);
            }
            for (ExperimentSample expSam : e.getExperimentSamples()) {
                if (nameMapBigWig.get(expSam.getSample().getName()) == null) continue;
                if (this.multiWIG) {
                    this.addMultiWigTrackDbSample(sb, e, expSam, nameMapBigWig);
                    continue;
                }
                priorityTrack = this.addTrackDbStandardSample(sb, e, expSam, nameMapBigWig, priorityTrack);
            }
            for (ExperimentSample expSam : e.getExperimentSamples()) {
                if (nameMapBigBed.get(expSam.getSample().getName()) == null) continue;
                priorityTrack = this.addTrackDbSample(sb, e, expSam, nameMapBigBed, priorityTrack);
            }
        }
        try (FileWriter writer = new FileWriter(new File(genomeDirectory, "trackDb.txt"), Charset.defaultCharset());){
            writer.write(sb.toString());
        }
    }

    private int addMultiWigTrackDbHeader(StringBuilder sb, Experiment e, int priorityTrack) {
        sb.append("track ");
        sb.append(e.getName());
        sb.append("\ncontainer multiWig");
        sb.append("\nshortLabel ");
        sb.append(e.getName());
        sb.append("\nlongLabel ");
        sb.append(e.getName());
        sb.append("\ntype bigWig");
        sb.append("\nconfigurable on");
        sb.append("\naggregate transparentOverlay");
        sb.append("\nshowSubtrackColorOnUi on");
        sb.append("\nvisibility full");
        sb.append("\nautoScale off");
        sb.append("\nviewLimits 0:1");
        sb.append("\nmaxHeightPixels 50:50:11");
        sb.append("\npriority ");
        sb.append(priorityTrack);
        sb.append('\n');
        return priorityTrack + 1;
    }

    private void addMultiWigTrackDbSample(StringBuilder sb, Experiment experiment, ExperimentSample sample, Map<String, Data> nameMapBigWig) {
        sb.append("\ttrack ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append('_');
        sb.append(experiment.getName());
        sb.append('\n');
        sb.append("\tparent ");
        sb.append(experiment.getName());
        sb.append('\n');
        sb.append("\tbigDataUrl ");
        sb.append(this.server);
        sb.append(this.bigDataUrl);
        sb.append(nameMapBigWig.get(sample.getSample().getName()).getDataFilename());
        sb.append('\n');
        sb.append("\tshortLabel ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append('\n');
        sb.append("\tlongLabel ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append('_');
        sb.append(experiment.getName());
        sb.append('\n');
        sb.append("\ttype bigWig\n");
        if (DesignUtils.getReference(sample).equals("true")) {
            sb.append("\tcolor 210,210,210\n");
        } else {
            sb.append("\tcolor 244,195,165\n");
        }
        sb.append('\n');
    }

    private int addTrackDbSample(StringBuilder sb, Experiment experiment, ExperimentSample sample, Map<String, Data> nameMapBigBed, int priorityTrack) {
        sb.append("track ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append('_');
        sb.append(experiment.getName());
        sb.append("_Peak");
        sb.append('\n');
        sb.append("bigDataUrl ");
        sb.append(this.server);
        sb.append(this.bigDataUrl);
        sb.append(nameMapBigBed.get(sample.getSample().getName()).getDataFilename());
        sb.append('\n');
        sb.append("shortLabel ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append("_Peak");
        sb.append('\n');
        sb.append("longLabel ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append('_');
        sb.append(experiment.getName());
        sb.append("_Peak");
        sb.append('\n');
        sb.append("type bigBed\n");
        sb.append("visibility dense\n");
        sb.append("autoScale off\n");
        sb.append("color 90,90,255\n");
        sb.append("priority ");
        sb.append(priorityTrack);
        sb.append('\n');
        sb.append('\n');
        return priorityTrack + 1;
    }

    private int addTrackDbStandardSample(StringBuilder sb, Experiment experiment, ExperimentSample sample, Map<String, Data> nameMapBigWig, int priorityTrack) {
        sb.append("track ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append('_');
        sb.append(experiment.getName());
        sb.append('\n');
        sb.append("bigDataUrl ");
        sb.append(this.server);
        sb.append(this.bigDataUrl);
        sb.append(nameMapBigWig.get(sample.getSample().getName()).getDataFilename());
        sb.append('\n');
        sb.append("shortLabel ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append('\n');
        sb.append("longLabel ");
        sb.append(DesignUtils.getCondition(sample));
        sb.append('_');
        sb.append(DesignUtils.getRepTechGroup(sample));
        sb.append('_');
        sb.append(experiment.getName());
        sb.append('\n');
        sb.append("type bigWig\n");
        sb.append("visibility full\n");
        sb.append("autoScale off\n");
        sb.append("viewLimits 0:1\n");
        if (DesignUtils.getReference(sample).equals("true")) {
            sb.append("color 210,210,210\n");
        } else {
            sb.append("color 244,195,165\n");
        }
        sb.append("priority ");
        sb.append(priorityTrack);
        sb.append('\n');
        sb.append('\n');
        return priorityTrack + 1;
    }
}

