/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq.peakcalling;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.chipseq.ChIPSeqDataFormats;
import fr.ens.biologie.genomique.eoulsan.requirements.DockerRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanDockerManager;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

@LocalOnly
public class DeepToolsModule
extends AbstractModule {
    private static final String MODULE_NAME = "deeptools";
    private static final String DEEPTOOLS_DEFAULT_DOCKER_IMAGE = "genomicpariscentre/deeptools:2.2.4";
    private Requirement requirement;
    private String dockerImage = "genomicpariscentre/deeptools:2.2.4";

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "This step runs QC tools from the DeepTools suite.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("inputpeak", true, ChIPSeqDataFormats.PEAK);
        builder.addPort("inputbamlist", true, DataFormats.MAPPER_RESULTS_BAM);
        builder.addPort("inputbailist", true, DataFormats.MAPPER_RESULTS_INDEX_BAI);
        return builder.create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block6: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "docker.image": {
                    this.dockerImage = p.getStringValue().trim();
                    if (!this.dockerImage.isEmpty()) continue block6;
                    Modules.badParameterValue(context, p, "The docker image name is empty");
                    continue block6;
                }
            }
            Modules.unknownParameter(context, p);
        }
        this.requirement = DockerRequirement.newDockerRequirement(this.dockerImage, true);
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.singleton(this.requirement);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data peaksData = context.getInputData(ChIPSeqDataFormats.PEAK);
        Design design = context.getWorkflow().getDesign();
        HashMap<String, Data> nameMapPEAK = new HashMap<String, Data>();
        for (Data anInputData : peaksData.getListElements()) {
            String name = anInputData.getMetadata().getSampleName();
            nameMapPEAK.put(name, anInputData);
            for (Experiment experiment : design.getExperiments()) {
                for (ExperimentSample expSam : experiment.getExperimentSamples()) {
                    if (nameMapPEAK.get(expSam.getSample().getName()) == null) continue;
                    nameMapPEAK.remove(name);
                    nameMapPEAK.put(experiment.getName(), anInputData);
                }
            }
        }
        ArrayList<String> bamFileNames = new ArrayList<String>();
        ArrayList<CallSite> bamFileLabels = new ArrayList<CallSite>();
        Data mappedData = context.getInputData(DataFormats.MAPPER_RESULTS_BAM);
        HashMap<String, Data> nameMapBAM = new HashMap<String, Data>();
        for (Data anInputData : mappedData.getListElements()) {
            String name = anInputData.getMetadata().getSampleName();
            nameMapBAM.put(name, anInputData);
        }
        Data data = context.getInputData(DataFormats.MAPPER_RESULTS_INDEX_BAI);
        HashMap<String, Data> nameMapBAI = new HashMap<String, Data>();
        for (Data anInputData : data.getListElements()) {
            String name = anInputData.getMetadata().getSampleName();
            nameMapBAI.put(name, anInputData);
        }
        for (Experiment e : design.getExperiments()) {
            DockerImageInstance process;
            block20: for (ExperimentSample expSam : e.getExperimentSamples()) {
                EoulsanLogger.getLogger().info(String.format("BAM Experiment %s - Condition %s - RepTechGroup %s", e.getName(), DesignUtils.getCondition(expSam), DesignUtils.getRepTechGroup(expSam)));
                if (nameMapBAM.get(expSam.getSample().getName()) == null) continue;
                String bamFileName = ((Data)nameMapBAM.get(expSam.getSample().getName())).getDataFilename();
                bamFileNames.add(bamFileName);
                bamFileLabels.add((CallSite)((Object)(DesignUtils.getCondition(expSam) + DesignUtils.getRepTechGroup(expSam))));
                for (ExperimentSample expSam2 : e.getExperimentSamples()) {
                    if (nameMapBAI.get(expSam.getSample().getName()) == null || !DesignUtils.getCondition(expSam2).equals(DesignUtils.getCondition(expSam)) || !DesignUtils.getRepTechGroup(expSam2).equals(DesignUtils.getRepTechGroup(expSam))) continue;
                    EoulsanLogger.getLogger().info("BAI File: " + ((Data)nameMapBAI.get(expSam.getSample().getName())).getDataFilename());
                    try {
                        DataFile oldName = new DataFile(((Data)nameMapBAI.get(expSam.getSample().getName())).getDataFilename());
                        DataFile newName = new DataFile(bamFileName + ".bai");
                        EoulsanLogger.getLogger().info("DataFile newName = " + newName);
                        if (newName.exists()) continue block20;
                        EoulsanLogger.getLogger().info("DataFile BAI : " + oldName);
                        oldName.symlink(newName);
                        continue block20;
                    }
                    catch (IOException err) {
                        err.printStackTrace();
                        EoulsanLogger.getLogger().severe(err.getMessage());
                        return status.createTaskResult();
                    }
                }
            }
            try {
                process = EoulsanDockerManager.getInstance().createImageInstance(this.dockerImage);
            }
            catch (IOException err) {
                return status.createTaskResult(err);
            }
            ArrayList<Object> cmd1multibamSummary = new ArrayList<Object>();
            cmd1multibamSummary.add("multiBamSummary");
            cmd1multibamSummary.add("bins");
            cmd1multibamSummary.add("--bamfiles");
            cmd1multibamSummary.addAll(bamFileNames);
            cmd1multibamSummary.add("--labels");
            cmd1multibamSummary.addAll(bamFileLabels);
            String multiBamSummaryOutput = "multiBamSummary_readCounts_" + e.getName() + "%s.npz";
            cmd1multibamSummary.add("-o");
            cmd1multibamSummary.add(multiBamSummaryOutput);
            cmd1multibamSummary.add("--outRawCounts");
            cmd1multibamSummary.add("multiBamSummary_readCounts_" + e.getName() + "%s.tab");
            File stderrFile1 = new File("dockerMultiBAMSummary_global_" + e.getName() + ".err");
            File stdoutFile1 = new File("dockerMultiBAMSummary_global_" + e.getName() + ".out");
            try {
                int exitValue1 = process.execute(cmd1multibamSummary, context.getStepOutputDirectory().toFile(), context.getLocalTempDirectory(), stdoutFile1, stderrFile1, new File[0]);
                ProcessUtils.throwExitCodeException(exitValue1, Joiner.on((char)' ').join(cmd1multibamSummary));
            }
            catch (IOException err) {
                return status.createTaskResult(err);
            }
            ArrayList<Object> cmd2bamCorrelate = new ArrayList<Object>();
            cmd2bamCorrelate.add("plotCorrelation");
            cmd2bamCorrelate.add("--whatToPlot");
            cmd2bamCorrelate.add("heatmap");
            cmd2bamCorrelate.add("--plotNumbers");
            cmd2bamCorrelate.add("-in");
            cmd2bamCorrelate.add(multiBamSummaryOutput);
            cmd2bamCorrelate.add("--corMethod");
            cmd2bamCorrelate.add("spearman");
            cmd2bamCorrelate.add("--colorMap");
            cmd2bamCorrelate.add("Blues");
            cmd2bamCorrelate.add("--zMin");
            cmd2bamCorrelate.add("0");
            cmd2bamCorrelate.add("--zMax");
            cmd2bamCorrelate.add("1");
            cmd2bamCorrelate.add("-o");
            cmd2bamCorrelate.add("bamcorrelatebins_output_report_" + e.getName() + ".pdf");
            File stderrFile2 = new File("dockerPlotCorrelation_global_" + e.getName() + ".err");
            File stdoutFile2 = new File("dockerPlotCorrelation_global_" + e.getName() + ".out");
            try {
                int exitValue2 = process.execute(cmd2bamCorrelate, context.getStepOutputDirectory().toFile(), context.getLocalTempDirectory(), stdoutFile2, stderrFile2, new File[0]);
                ProcessUtils.throwExitCodeException(exitValue2, Joiner.on((char)' ').join(cmd2bamCorrelate));
            }
            catch (IOException err) {
                return status.createTaskResult(err);
            }
            if (nameMapPEAK.containsKey(e.getName())) {
                ArrayList<Object> cmd3multibamSummary = new ArrayList<Object>();
                cmd3multibamSummary.add("multiBamSummary");
                cmd3multibamSummary.add("BED-file");
                cmd3multibamSummary.add("--BED");
                cmd3multibamSummary.add(((Data)nameMapPEAK.get(e.getName())).getDataFilename());
                cmd3multibamSummary.add("--bamfiles");
                cmd3multibamSummary.addAll(bamFileNames);
                cmd3multibamSummary.add("--labels");
                cmd3multibamSummary.addAll(bamFileLabels);
                String multiBamSummaryOutput2 = "multiBamSummary_peaks_readCounts_" + e.getName() + "%s.npz";
                cmd3multibamSummary.add("-o");
                cmd3multibamSummary.add(multiBamSummaryOutput2);
                cmd3multibamSummary.add("--outRawCounts");
                cmd3multibamSummary.add("multiBamSummary_peaks_readCounts_" + e.getName() + ".tab");
                File stderrFile3 = new File("dockerMultiBAMSummary_peak_" + e.getName() + ".err");
                File stdoutFile3 = new File("dockerMultiBAMSummary_peak_" + e.getName() + ".out");
                try {
                    int exitValue3 = process.execute(cmd3multibamSummary, context.getStepOutputDirectory().toFile(), context.getLocalTempDirectory(), stdoutFile3, stderrFile3, new File[0]);
                    ProcessUtils.throwExitCodeException(exitValue3, Joiner.on((char)' ').join(cmd3multibamSummary));
                }
                catch (IOException err) {
                    return status.createTaskResult(err);
                }
                ArrayList<Object> cmd4bamCorrelate = new ArrayList<Object>();
                cmd4bamCorrelate.add("plotCorrelation");
                cmd4bamCorrelate.add("--whatToPlot");
                cmd4bamCorrelate.add("heatmap");
                cmd4bamCorrelate.add("--plotNumbers");
                cmd4bamCorrelate.add("-in");
                cmd4bamCorrelate.add(multiBamSummaryOutput2);
                cmd4bamCorrelate.add("--corMethod");
                cmd4bamCorrelate.add("spearman");
                cmd4bamCorrelate.add("--colorMap");
                cmd4bamCorrelate.add("Reds");
                cmd4bamCorrelate.add("--zMin");
                cmd4bamCorrelate.add("0");
                cmd4bamCorrelate.add("--zMax");
                cmd4bamCorrelate.add("1");
                cmd4bamCorrelate.add("-o");
                cmd4bamCorrelate.add("bamcorrelatepeaks_output_report_" + e.getName() + ".pdf");
                File stderrFile4 = new File("dockerPlotCorrelation_peak_" + e.getName() + ".err");
                File stdoutFile4 = new File("dockerPlotCorrelation_peak_" + e.getName() + ".out");
                try {
                    int exitValue4 = process.execute(cmd4bamCorrelate, context.getStepOutputDirectory().toFile(), context.getLocalTempDirectory(), stdoutFile4, stderrFile4, new File[0]);
                    ProcessUtils.throwExitCodeException(exitValue4, Joiner.on((char)' ').join(cmd4bamCorrelate));
                }
                catch (IOException err) {
                    return status.createTaskResult(err);
                }
            }
            ArrayList<Object> cmd5bamFingerprint = new ArrayList<Object>();
            cmd5bamFingerprint.add("plotFingerprint");
            cmd5bamFingerprint.add("--bamfiles");
            cmd5bamFingerprint.addAll(bamFileNames);
            cmd5bamFingerprint.add("--labels");
            cmd5bamFingerprint.addAll(bamFileLabels);
            cmd5bamFingerprint.add("--plotFile");
            cmd5bamFingerprint.add("bamfingerprint_output_report_" + e.getName() + ".pdf");
            cmd5bamFingerprint.add("--plotFileFormat");
            cmd5bamFingerprint.add("pdf");
            File stderrFile5 = new File("dockerFingerPrint_" + e.getName() + ".err");
            File stdoutFile5 = new File("dockerFingerPrint_" + e.getName() + ".out");
            try {
                int exitValue5 = process.execute(cmd5bamFingerprint, context.getStepOutputDirectory().toFile(), context.getLocalTempDirectory(), stdoutFile5, stderrFile5, new File[0]);
                ProcessUtils.throwExitCodeException(exitValue5, Joiner.on((char)' ').join(cmd5bamFingerprint));
            }
            catch (IOException err) {
                return status.createTaskResult(err);
            }
        }
        return status.createTaskResult();
    }
}

