/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq.peakcalling;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.chipseq.ChIPSeqDataFormats;
import fr.ens.biologie.genomique.eoulsan.requirements.DockerRequirement;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanDockerManager;
import fr.ens.biologie.genomique.eoulsan.util.ProcessUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import fr.ens.biologie.genomique.kenetre.util.process.DockerImageInstance;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

@LocalOnly
public class MACS2Module
extends AbstractModule {
    private static final String CALLER_NAME = "MACS2";
    private static final String CALLER_EXECUTABLE = "macs2";
    protected static final String COUNTER_GROUP = "peak_calling";
    private boolean isBroad = false;
    private String genomeSize = "hs";
    private double qvalue = 0.0;
    private double pvalue = 0.0;
    private boolean makeBdg = false;
    private String extraArgs = "";
    private boolean isPairedEnd = false;
    private Requirement requirement;
    final String dockerImage = "genomicpariscentre/macs2:latest";

    @Override
    public String getName() {
        return CALLER_EXECUTABLE;
    }

    @Override
    public String getDescription() {
        return "This step performs peak calling using macs2.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("input", true, DataFormats.MAPPER_RESULTS_BAM);
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        OutputPortsBuilder builder = new OutputPortsBuilder();
        builder.addPort("outputr", true, ChIPSeqDataFormats.MACS2_RMODEL);
        builder.addPort("outputgap", true, ChIPSeqDataFormats.GAPPED_PEAK);
        builder.addPort("outputxls", true, ChIPSeqDataFormats.PEAK_XLS);
        builder.addPort("outputpeak", true, ChIPSeqDataFormats.PEAK);
        return builder.create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        for (Parameter p : stepParameters) {
            EoulsanLogger.getLogger().info("MACS2 parameter: " + p.getName() + " : " + p.getStringValue());
            if ("is.broadpeak".equals(p.getName())) {
                this.isBroad = p.getBooleanValue();
                continue;
            }
            if ("genome.size".equals(p.getName())) {
                this.genomeSize = p.getStringValue();
                continue;
            }
            if ("q.value".equals(p.getName())) {
                this.qvalue = p.getDoubleValue();
                continue;
            }
            if ("p.value".equals(p.getName())) {
                this.pvalue = p.getDoubleValue();
                continue;
            }
            if ("make.bedgraph".equals(p.getName())) {
                this.makeBdg = p.getBooleanValue();
                continue;
            }
            if ("extra.args".equals(p.getName())) {
                this.extraArgs = p.getStringValue();
                continue;
            }
            if ("is.paired.end".equals(p.getName())) {
                this.isPairedEnd = p.getBooleanValue();
                continue;
            }
            throw new EoulsanException("Unknown parameter for " + this.getName() + " step: " + p.getName());
        }
        if (this.pvalue != 0.0 && this.qvalue != 0.0) {
            EoulsanLogger.getLogger().warning("As p-value threshold is provided, q-value threshold will be ignored by macs2.");
        }
        if (this.pvalue == 0.0 && this.qvalue == 0.0) {
            EoulsanLogger.getLogger().warning("Neither p-value nor q-value threshold was provided. Macs2 defaults to q-value thresold = 0.01.");
            this.qvalue = 0.01;
        }
        this.requirement = DockerRequirement.newDockerRequirement("genomicpariscentre/macs2:latest", true);
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.singleton(this.requirement);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_BAM);
        Design design = context.getWorkflow().getDesign();
        Data rModelDataList = context.getOutputData(ChIPSeqDataFormats.MACS2_RMODEL, "rmodellist");
        Data gappedPeakDataList = context.getOutputData(ChIPSeqDataFormats.GAPPED_PEAK, "gappedpeaklist");
        Data peakXlsDataList = context.getOutputData(ChIPSeqDataFormats.PEAK_XLS, "peakxlslist");
        Data peakDataList = context.getOutputData(ChIPSeqDataFormats.PEAK, "peaklist");
        if (!inData.isList() || inData.getListElements().size() < 2) {
            EoulsanLogger.getLogger().severe("Not enough data to run MACS2. Need at least one control and one sample.");
            return status.createTaskResult();
        }
        HashMap<String, Data> nameMap = new HashMap<String, Data>(inData.getListElements().size() / 2);
        for (Data anInputData : inData.getListElements()) {
            String name = anInputData.getMetadata().getSampleName();
            nameMap.put(name, anInputData);
        }
        String refSampleName = null;
        for (Experiment e : design.getExperiments()) {
            for (ExperimentSample expSam : e.getExperimentSamples()) {
                if (!nameMap.containsKey(expSam.getSample().getName()) || !DesignUtils.getReference(expSam).equals("true")) continue;
                refSampleName = expSam.getSample().getName();
                break;
            }
            if (refSampleName == null) {
                EoulsanLogger.getLogger().warning("No control for experiment : " + e.getName());
            }
            for (ExperimentSample expSam2 : e.getExperimentSamples()) {
                DataFile tmpPeakFile;
                DataFile tmpPeakXlsFile;
                DataFile tmpGappedPeakFile;
                if (!nameMap.containsKey(expSam2.getSample().getName())) {
                    EoulsanLogger.getLogger().info("Skipping empty sample after merge : " + expSam2.getSample().getName());
                    continue;
                }
                if (refSampleName.equals(expSam2.getSample().getName())) {
                    EoulsanLogger.getLogger().info("Skipping control file.");
                    continue;
                }
                ArrayList<String> commandLine = new ArrayList<String>();
                String sampleName = ((Data)nameMap.get(expSam2.getSample().getName())).getName();
                EoulsanLogger.getLogger().info("sampleName: " + sampleName);
                File sampleFile = ((Data)nameMap.get(expSam2.getSample().getName())).getDataFile().toFile();
                File refFile = null;
                commandLine.add(CALLER_EXECUTABLE);
                commandLine.add("callpeak");
                commandLine.add("-t");
                commandLine.add(sampleFile.getAbsolutePath());
                if (refSampleName != null) {
                    commandLine.add("-c");
                    refFile = ((Data)nameMap.get(refSampleName)).getDataFile().toFile();
                    commandLine.add(refFile.getAbsolutePath());
                }
                if (this.isPairedEnd) {
                    commandLine.add("-f");
                    commandLine.add("BAMPE");
                } else {
                    commandLine.add("-f");
                    commandLine.add("BAM");
                }
                if (this.pvalue != 0.0) {
                    commandLine.add("--pvalue");
                    commandLine.add(String.format("%f", this.pvalue));
                } else {
                    commandLine.add("--qvalue");
                    commandLine.add(String.format("%f", this.qvalue));
                }
                String prefixOutputFiles = String.format("macs2_ouput_%s", expSam2.getSample().getName().replaceAll("[^a-zA-Z0-9]", ""));
                commandLine.add("--name");
                commandLine.add(String.format("%s", prefixOutputFiles));
                commandLine.add("--gsize");
                commandLine.add(String.format("%s", this.genomeSize));
                if (this.isBroad) {
                    commandLine.add("--broad");
                }
                if (this.makeBdg) {
                    commandLine.add("--bdg");
                }
                if (!this.extraArgs.trim().isEmpty()) {
                    commandLine.addAll(StringUtils.splitShellCommandLine((String)this.extraArgs));
                }
                String commandLine2 = Joiner.on((String)" ").join(commandLine);
                File stdoutFile = new File(context.getStepOutputDirectory().toFile(), "macs2.out");
                File stderrFile = new File(context.getStepOutputDirectory().toFile(), "macs2.err");
                EoulsanLogger.getLogger().info("Run command line : " + commandLine2);
                try {
                    DockerImageInstance process = EoulsanDockerManager.getInstance().createImageInstance("genomicpariscentre/macs2:latest");
                    int exitValue = process.execute(commandLine, context.getStepOutputDirectory().toFile(), context.getLocalTempDirectory(), stdoutFile, stderrFile, new File[]{sampleFile, refFile});
                    ProcessUtils.throwExitCodeException(exitValue, Joiner.on((char)' ').join(commandLine));
                }
                catch (IOException err) {
                    return status.createTaskResult(err);
                }
                Data rModelData = rModelDataList.addDataToList(expSam2.getSample().getName().replaceAll("[^a-zA-Z0-9]", "") + "R");
                rModelData.getMetadata().set(((Data)nameMap.get(expSam2.getSample().getName())).getMetadata());
                Data gappedPeakData = gappedPeakDataList.addDataToList(expSam2.getSample().getName().replaceAll("[^a-zA-Z0-9]", "") + "GP");
                gappedPeakData.getMetadata().set(((Data)nameMap.get(expSam2.getSample().getName())).getMetadata());
                Data peakXlsData = peakXlsDataList.addDataToList(expSam2.getSample().getName().replaceAll("[^a-zA-Z0-9]", "") + "Xls");
                peakXlsData.getMetadata().set(((Data)nameMap.get(expSam2.getSample().getName())).getMetadata());
                Data peakData = peakDataList.addDataToList(expSam2.getSample().getName().replaceAll("[^a-zA-Z0-9]", "") + "Peak");
                peakData.getMetadata().set(((Data)nameMap.get(expSam2.getSample().getName())).getMetadata());
                DataFile sampleDataFolder = context.getStepOutputDirectory();
                DataFile tmpRmodelFile = new DataFile(sampleDataFolder, prefixOutputFiles + "_model.r");
                if (tmpRmodelFile.exists()) {
                    tmpRmodelFile.toFile().renameTo(rModelData.getDataFile().toFile());
                }
                if ((tmpGappedPeakFile = new DataFile(sampleDataFolder, prefixOutputFiles + "_peaks.gappedPeak")).exists()) {
                    tmpGappedPeakFile.toFile().renameTo(gappedPeakData.getDataFile().toFile());
                }
                if ((tmpPeakXlsFile = new DataFile(sampleDataFolder, prefixOutputFiles + "_peaks.xls")).exists()) {
                    tmpPeakXlsFile.toFile().renameTo(peakXlsData.getDataFile().toFile());
                }
                if (!(tmpPeakFile = this.isBroad ? new DataFile(sampleDataFolder, prefixOutputFiles + "_peaks.broadPeak") : new DataFile(sampleDataFolder, prefixOutputFiles + "_peaks.narrowPeak")).exists()) continue;
                tmpPeakFile.toFile().renameTo(peakData.getDataFile().toFile());
            }
        }
        return status.createTaskResult();
    }
}

