/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.chipseq.qc;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.mapping.MappingCounters;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import fr.ens.biologie.genomique.kenetre.util.Version;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

@LocalOnly
public class CountSplicedReadsModule
extends AbstractModule {
    private static final String STEP_NAME = "countspliced";
    protected static final String COUNTER_GROUP = "sam_stats";

    @Override
    public String getName() {
        return STEP_NAME;
    }

    @Override
    public String getDescription() {
        return "This step performs a quality control by counting spliced mapped reads.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        if (!stepParameters.isEmpty()) {
            throw new EoulsanException("Unknown parameter(s) for " + this.getName() + " step.");
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Data inData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
        DataFile samFile = inData.getDataFile();
        EoulsanLogger.getLogger().info("Counting entries in SAM file: " + samFile);
        LocalReporter reporter = new LocalReporter();
        try {
            SamReader reader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)samFile.open()));
            int recordCount = 0;
            int splicedRecords = 0;
            boolean pairedEnd = false;
            block2: for (SAMRecord record : reader) {
                if (recordCount == 0) {
                    pairedEnd = record.getReadPairedFlag();
                }
                ++recordCount;
                String cigar = record.getCigarString();
                for (int i = 0; i < cigar.length(); ++i) {
                    if (cigar.charAt(i) != 'N') continue;
                    ++splicedRecords;
                    continue block2;
                }
            }
            reader.close();
            EoulsanLogger.getLogger().info("Spliced SAM entries : " + splicedRecords);
            EoulsanLogger.getLogger().info("All SAM entries : " + recordCount);
            if (pairedEnd) {
                reporter.setCounter(COUNTER_GROUP, MappingCounters.INPUT_ALIGNMENTS_COUNTER.counterName(), (long)(recordCount / 2));
                reporter.setCounter(COUNTER_GROUP, MappingCounters.OUTPUT_FILTERED_ALIGNMENTS_COUNTER.counterName(), 1L);
                reporter.setCounter(COUNTER_GROUP, MappingCounters.OUTPUT_FILTERED_ALIGNMENTS_COUNTER.counterName(), (long)(splicedRecords / 2));
            } else {
                reporter.setCounter(COUNTER_GROUP, MappingCounters.INPUT_ALIGNMENTS_COUNTER.counterName(), (long)recordCount);
                reporter.setCounter(COUNTER_GROUP, MappingCounters.OUTPUT_FILTERED_ALIGNMENTS_COUNTER.counterName(), 1L);
                reporter.setCounter(COUNTER_GROUP, MappingCounters.OUTPUT_FILTERED_ALIGNMENTS_COUNTER.counterName(), (long)splicedRecords);
            }
            status.setDescription("Count entries in SAM file (" + inData.getName() + ", " + samFile.getName() + ")");
            status.setCounters((Reporter)reporter, COUNTER_GROUP);
            EoulsanLogger.getLogger().info(reporter.countersValuesToString(COUNTER_GROUP, " (" + inData.getName() + ", " + samFile.getName() + ") "));
        }
        catch (IOException ioe) {
            EoulsanLogger.getLogger().severe("Could not open SAM file (" + inData.getName() + ", " + samFile.getName() + ")");
            return status.createTaskResult();
        }
        return status.createTaskResult();
    }
}

