/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.diffana;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.Experiment;
import fr.ens.biologie.genomique.eoulsan.design.ExperimentSample;
import fr.ens.biologie.genomique.eoulsan.design.Sample;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.Normalization;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiffAna
extends Normalization {
    private static final String DISPERSION_ESTIMATION = "/DESeq1/dispersionEstimation.Rnw";
    private static final String ANADIFF_WITH_REFERENCE = "/DESeq1/anadiffWithReference.Rnw";
    private static final String ANADIFF_WITHOUT_REFERENCE = "/DESeq1/anadiffWithoutReference.Rnw";
    private DispersionMethod dispEstMethod;
    private DispersionFitType dispEstFitType;
    private DispersionSharingMode dispEstSharingMode;

    @Override
    protected String generateScript(Experiment experiment, TaskContext context) throws EoulsanException {
        String comparison = experiment.getMetadata().getComparisons();
        if (comparison != null && !comparison.trim().isEmpty()) {
            throw new EoulsanException("The diffana step do not actually handle the comparison property of an experiment");
        }
        HashMap<String, List<Integer>> conditionsMap = new HashMap<String, List<Integer>>();
        ArrayList<Integer> rSampleIds = new ArrayList<Integer>();
        ArrayList<String> rSampleNames = new ArrayList<String>();
        ArrayList<String> rCondNames = new ArrayList<String>();
        ArrayList<String> rRepTechGroup = new ArrayList<String>();
        int i = 0;
        for (Sample s : experiment.getSamples()) {
            List<Integer> index;
            String condition = DesignUtils.getCondition(experiment, s);
            if (condition == null) {
                throw new EoulsanException("No condition field found in design file.");
            }
            if ("".equals(condition)) {
                throw new EoulsanException("No value for condition in sample: " + s.getName() + " (" + s.getId() + ")");
            }
            String repTechGroup = DesignUtils.getRepTechGroup(experiment, s);
            if (repTechGroup != null && !"".equals(repTechGroup)) {
                rRepTechGroup.add(repTechGroup);
            }
            if (!conditionsMap.containsKey(condition)) {
                index = new ArrayList();
                conditionsMap.put(condition, index);
            } else {
                index = (List)conditionsMap.get(condition);
            }
            index.add(i);
            rSampleIds.add(s.getNumber());
            rSampleNames.add(s.getName());
            rCondNames.add(condition);
            ++i;
        }
        this.checkRepTechGroupCoherence(rRepTechGroup, rCondNames);
        String pdfTitle = this.escapeUnderScore(experiment.getName()) + " differential analysis";
        String filePrefix = "diffana_" + this.escapeUnderScore(experiment.getName());
        StringBuilder sb = this.generateRnwpreamble(experiment.getSamples(), pdfTitle, filePrefix);
        this.replaceRtgNA(rRepTechGroup, rSampleNames);
        this.writeReferenceField(experiment, sb);
        this.generateSampleNamePart(rSampleNames, sb);
        this.generateSampleIdsPart(rSampleIds, sb);
        this.generateExpressionFileNamesPart(sb);
        this.generateRepTechGroupPart(rRepTechGroup, sb);
        this.generateConditionPart(rCondNames, sb);
        sb.append("# projectPath : path of count files directory\n");
        sb.append("projectPath <- \"\"\n");
        sb.append("# outPath path of the outputs\n");
        sb.append("outPath <- \"./\"\n");
        sb.append("projectName <- \"");
        sb.append(experiment.getName());
        sb.append("\"\n@\n\n");
        sb.append(this.readStaticScript("/DESeq1/targetCreation.Rnw"));
        sb.append("\\section{Analysis}\n\n");
        sb.append("<<beginAnalysis>>=\n");
        sb.append("target$counts <- deleteUnexpressedGene(target$counts)\n");
        if (this.isTechnicalReplicates(rRepTechGroup)) {
            sb.append("target <- poolTechRep(target)\n\n");
        }
        sb.append("target <- sortTarget(target)\n");
        sb.append("countDataSet <- normDESeq(target$counts, target$condition)\n");
        sb.append("@\n");
        String dispersionEstimation = this.readStaticScript(DISPERSION_ESTIMATION);
        if (!(this.isBiologicalReplicates(conditionsMap, rCondNames, rRepTechGroup) || this.dispEstMethod == DispersionMethod.BLIND && this.dispEstSharingMode == DispersionSharingMode.FIT_ONLY)) {
            throw new EoulsanException("There is no replicates in this experiment, you have to use disp_est_method=blind and disp_est_sharingMode=fit-only in diffana parameters");
        }
        dispersionEstimation = dispersionEstimation.replace("${METHOD}", this.dispEstMethod.getName());
        dispersionEstimation = dispersionEstimation.replace("${SHARINGMODE}", this.dispEstSharingMode.getName());
        dispersionEstimation = dispersionEstimation.replace("${FITTYPE}", this.dispEstFitType.getName());
        sb.append(dispersionEstimation);
        if (this.dispEstMethod.equals((Object)DispersionMethod.PER_CONDITION)) {
            ArrayList<String> passedConditionName = new ArrayList<String>();
            for (String cond : rCondNames) {
                if (passedConditionName.indexOf(cond) != -1) continue;
                sb.append("<<dispersionPlot_");
                sb.append(cond);
                sb.append(", fig=TRUE>>=\n");
                sb.append("fitInfo <- fitInfo(countDataSet, name = \"");
                sb.append(cond);
                sb.append("\")\n");
                sb.append("plotDispEsts(countDataSet, fitInfo, \"");
                sb.append(cond);
                sb.append("\")\n");
                sb.append("@\n");
                passedConditionName.add(cond);
            }
        } else {
            sb.append("<<dispersionPlot, fig=TRUE>>=\n");
            sb.append("fitInfo <- fitInfo(countDataSet)\n");
            sb.append("plotDispEsts(countDataSet, fitInfo)\n");
            sb.append("@\n");
        }
        String anadiffPart = "";
        anadiffPart = this.isReference(experiment) ? this.readStaticScript(ANADIFF_WITH_REFERENCE) : this.readStaticScript(ANADIFF_WITHOUT_REFERENCE);
        anadiffPart = anadiffPart.replace("${METHOD}", this.dispEstMethod.getName());
        sb.append(anadiffPart);
        sb.append("\\end{document}");
        return sb.toString();
    }

    private boolean isBiologicalReplicates(Map<String, List<Integer>> conditionsMap, List<String> rCondNames, List<String> rRepTechGroup) {
        for (String condition : rCondNames) {
            List<Integer> condPos = conditionsMap.get(condition);
            for (int i = 0; i < condPos.size() - 1; ++i) {
                int pos1 = condPos.get(i);
                int pos2 = condPos.get(i + 1);
                if (rRepTechGroup.get(pos1).equals(rRepTechGroup.get(pos2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReference(Experiment experiment) {
        if (experiment == null || experiment.getSamples().isEmpty()) {
            return false;
        }
        if (DesignUtils.containsReferenceField(experiment)) {
            for (ExperimentSample es : experiment.getExperimentSamples()) {
                String ref = DesignUtils.getReference(es);
                if (DesignUtils.referenceValueToInt(ref, null) != 1) continue;
                return true;
            }
            return false;
        }
        String refExp = experiment.getMetadata().getReference();
        if (refExp != null) {
            for (ExperimentSample es : experiment.getExperimentSamples()) {
                String condition = DesignUtils.getCondition(es);
                if (!refExp.equals(condition)) continue;
                return true;
            }
        }
        return false;
    }

    private void writeReferenceField(Experiment experiment, StringBuilder sb) throws EoulsanException {
        String refExp = experiment.getMetadata().getReference();
        String refValue = null;
        block5: for (ExperimentSample es : experiment.getExperimentSamples()) {
            int ref = DesignUtils.referenceValueToInt(DesignUtils.getReference(es), refExp);
            switch (ref) {
                case -1: {
                    throw new EoulsanException("Reference value lower than 0 and not handled by the Diffana step (sample: " + es.getSample().getId() + ")");
                }
                case 0: {
                    continue block5;
                }
                case 1: {
                    String newRefValue = DesignUtils.getCondition(es);
                    if (newRefValue == null) continue block5;
                    newRefValue = newRefValue.trim();
                    if (refValue != null && !refValue.equals(newRefValue)) {
                        throw new EoulsanException("Found a reference value (" + newRefValue + ") that is not the current reference value (" + refValue + ") in the Diffana step (sample: " + es.getSample().getId() + ")");
                    }
                    refValue = newRefValue;
                    continue block5;
                }
            }
            throw new EoulsanException("Reference value greater than 1 and not handled by the Diffana step (sample: " + es.getSample().getId() + ")");
        }
        if (refValue != null) {
            sb.append("ref <- \"");
            sb.append(refValue);
            sb.append("\"\n\n");
        }
    }

    public DiffAna(RExecutor executor, Design design, DispersionMethod dispEstMethod, DispersionSharingMode dispEstSharingMode, DispersionFitType dispEstFitType) throws EoulsanException {
        super(executor, design);
        if (dispEstMethod == null || dispEstFitType == null || dispEstSharingMode == null) {
            throw new NullPointerException("dispersion estimation fit type or method or sharing mode is null");
        }
        this.dispEstMethod = dispEstMethod;
        this.dispEstFitType = dispEstFitType;
        this.dispEstSharingMode = dispEstSharingMode;
    }

    public static enum DispersionFitType {
        PARAMETRIC("parametric"),
        LOCAL("local");

        private final String name;

        public String getName() {
            return this.name;
        }

        public static DispersionFitType getDispEstFitTypeFromName(String name) {
            if (name == null) {
                return null;
            }
            String lowerName = name.trim().toLowerCase();
            for (DispersionFitType deft : DispersionFitType.values()) {
                if (!deft.getName().toLowerCase().equals(lowerName)) continue;
                return deft;
            }
            return null;
        }

        private DispersionFitType(String name) {
            this.name = name;
        }
    }

    public static enum DispersionSharingMode {
        FIT_ONLY("fit-only"),
        MAXIMUM("maximum"),
        GENE_EST_ONLY("gene-est-only");

        private final String name;

        public String getName() {
            return this.name;
        }

        public static DispersionSharingMode getDispEstSharingModeFromName(String name) {
            if (name == null) {
                return null;
            }
            String lowerName = name.trim().toLowerCase();
            for (DispersionSharingMode desm : DispersionSharingMode.values()) {
                if (!desm.getName().toLowerCase().equals(lowerName)) continue;
                return desm;
            }
            return null;
        }

        private DispersionSharingMode(String name) {
            this.name = name;
        }
    }

    public static enum DispersionMethod {
        POOLED("pooled"),
        PER_CONDITION("per-condition"),
        BLIND("blind");

        private final String name;

        public String getName() {
            return this.name;
        }

        public static DispersionMethod getDispEstMethodFromName(String name) {
            if (name == null) {
                return null;
            }
            String lowerName = name.trim().toLowerCase();
            for (DispersionMethod dem : DispersionMethod.values()) {
                if (!dem.getName().toLowerCase().equals(lowerName)) continue;
                return dem;
            }
            return null;
        }

        private DispersionMethod(String method) {
            this.name = method;
        }
    }
}

