/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.diffana;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.DiffAna;
import fr.ens.biologie.genomique.eoulsan.modules.diffana.RModuleCommonConfiguration;
import fr.ens.biologie.genomique.eoulsan.requirements.Requirement;
import fr.ens.biologie.genomique.eoulsan.util.r.RExecutor;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@LocalOnly
public class DiffAnaModule
extends AbstractModule {
    private static final String DISP_EST_METHOD_PARAMETER_NAME = "disp.est.method";
    private static final String DISP_EST_FIT_TYPE_PARAMETER_NAME = "disp.est.fit.type";
    private static final String DISP_EST_SHARING_MODE_PARAMETER_NAME = "disp.est.sharing.mode";
    private static final String MODULE_NAME = "diffana";
    private DiffAna.DispersionMethod dispEstMethod = DiffAna.DispersionMethod.POOLED;
    private DiffAna.DispersionFitType dispEstFitType = DiffAna.DispersionFitType.LOCAL;
    private DiffAna.DispersionSharingMode dispEstSharingMode = DiffAna.DispersionSharingMode.MAXIMUM;
    private final Set<Requirement> requirements = new HashSet<Requirement>();
    private RExecutor executor;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public String getDescription() {
        return "This class compute the differential analysis for the experiment.";
    }

    @Override
    public InputPorts getInputPorts() {
        return new InputPortsBuilder().addPort("input", true, DataFormats.EXPRESSION_RESULTS_TSV).create();
    }

    @Override
    public Set<Requirement> getRequirements() {
        return Collections.unmodifiableSet(this.requirements);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            Design design = context.getWorkflow().getDesign();
            DiffAna diffana = new DiffAna(this.executor, design, this.dispEstMethod, this.dispEstSharingMode, this.dispEstFitType);
            diffana.run(context, context.getInputData(DataFormats.EXPRESSION_RESULTS_TSV));
            return status.createTaskResult();
        }
        catch (EoulsanException e) {
            return status.createTaskResult(e, "Error while analysis data: " + e.getMessage());
        }
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        HashSet<Parameter> parameters = new HashSet<Parameter>(stepParameters);
        this.executor = RModuleCommonConfiguration.parseRExecutorParameter(context, parameters, this.requirements, "genomicpariscentre/deseq:1.8.3");
        block10: for (Parameter p : parameters) {
            switch (p.getName()) {
                case "disp.est.method": {
                    this.dispEstMethod = DiffAna.DispersionMethod.getDispEstMethodFromName(p.getStringValue());
                    if (this.dispEstMethod != null) continue block10;
                    Modules.badParameterValue(context, p, "Unknown dispersion estimation method");
                    continue block10;
                }
                case "disp.est.fit.type": {
                    this.dispEstFitType = DiffAna.DispersionFitType.getDispEstFitTypeFromName(p.getStringValue());
                    if (this.dispEstFitType != null) continue block10;
                    Modules.badParameterValue(context, p, "Unknown dispersion estimation fitType");
                    continue block10;
                }
                case "disp.est.sharing.mode": {
                    this.dispEstSharingMode = DiffAna.DispersionSharingMode.getDispEstSharingModeFromName(p.getStringValue());
                    if (this.dispEstSharingMode != null) continue block10;
                    Modules.badParameterValue(context, p, "Unknown dispersion estimation sharing mode");
                    continue block10;
                }
            }
            Modules.unknownParameter(context, p);
        }
        EoulsanLogger.getLogger().info("In " + this.getName() + ", dispersion estimation method=" + this.dispEstMethod.getName());
        EoulsanLogger.getLogger().info("In " + this.getName() + ", dispersion estimation sharing mode=" + this.dispEstSharingMode.getName());
        EoulsanLogger.getLogger().info("In " + this.getName() + ", dispersion estimation fit type=" + this.dispEstFitType.getName());
    }
}

