/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.diffana;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.annotations.RequiresAllPreviousSteps;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.ParallelizationMode;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanTranslatorUtils;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import fr.ens.biologie.genomique.kenetre.translator.TranslatorUtils;
import fr.ens.biologie.genomique.kenetre.translator.io.ODSTranslatorOutputFormat;
import fr.ens.biologie.genomique.kenetre.translator.io.TSVTranslatorOutputFormat;
import fr.ens.biologie.genomique.kenetre.translator.io.TranslatorOutputFormat;
import fr.ens.biologie.genomique.kenetre.translator.io.XLSXTranslatorOutputFormat;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@LocalOnly
@RequiresAllPreviousSteps
public class DiffanaResultsAnnotationModule
extends AbstractModule {
    public static final String MODULE_NAME = "diffanaresultsannotation";
    private static final DataFormat DEFAULT_FORMAT = DataFormats.ANNOTATED_EXPRESSION_RESULTS_TSV;
    private static final String DEFAULT_FILE_INPUT_GLOB_PATTERN = "{diffana_*.tsv,deseq2_*.tsv}";
    private final Map<String, DataFormat> outputFormats = new HashMap<String, DataFormat>();
    private PathMatcher pathMatcher;
    private String outputPrefix;
    private boolean useAdditionalAnnotationFile = true;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "This module add annotation to diffana files.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        if (this.useAdditionalAnnotationFile) {
            return InputPortsBuilder.singleInputPort(DataFormats.ADDITIONAL_ANNOTATION_TSV);
        }
        return InputPortsBuilder.noInputPort();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.noOutputPort();
    }

    @Override
    public ParallelizationMode getParallelizationMode() {
        Collection<DataFormat> formats = this.outputFormats.values();
        if (formats.contains(DataFormats.ANNOTATED_EXPRESSION_RESULTS_ODS) || formats.contains(DataFormats.ANNOTATED_EXPRESSION_RESULTS_XLSX)) {
            return ParallelizationMode.OWN_PARALLELIZATION;
        }
        return ParallelizationMode.STANDARD;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        String pattern = DEFAULT_FILE_INPUT_GLOB_PATTERN;
        this.outputPrefix = context.getCurrentStep().getId() + "_";
        block26: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "annotationfile": {
                    Modules.removedParameter(context, p);
                    break;
                }
                case "use.additional.annotation.file": {
                    this.useAdditionalAnnotationFile = p.getBooleanValue();
                    break;
                }
                case "outputformat": {
                    Modules.renamedParameter(context, p, "output.format");
                }
                case "output.format": {
                    Iterator iterator = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)p.getValue()).iterator();
                    block27: while (iterator.hasNext()) {
                        String format;
                        switch (format = (String)iterator.next()) {
                            case "tsv": {
                                this.outputFormats.put(format, DataFormats.ANNOTATED_EXPRESSION_RESULTS_TSV);
                                continue block27;
                            }
                            case "ods": {
                                this.outputFormats.put(format, DataFormats.ANNOTATED_EXPRESSION_RESULTS_ODS);
                                continue block27;
                            }
                            case "xlsx": {
                                this.outputFormats.put(format, DataFormats.ANNOTATED_EXPRESSION_RESULTS_XLSX);
                                continue block27;
                            }
                        }
                        throw new EoulsanException("Unknown output format: " + format);
                    }
                    continue block26;
                }
                case "files": {
                    pattern = p.getStringValue();
                    break;
                }
                case "output.prefix": {
                    this.outputPrefix = p.getStringValue();
                    break;
                }
                default: {
                    Modules.unknownParameter(context, p);
                }
            }
        }
        if (this.outputFormats.isEmpty()) {
            this.outputFormats.put(DEFAULT_FORMAT.getDefaultExtension().substring(1), DEFAULT_FORMAT);
        }
        this.pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Translator translator;
        System.setProperty("javax.accessibility.assistive_technologies", "");
        DataFile linksFile = EoulsanTranslatorUtils.getLinksFileFromSettings(context.getSettings());
        try {
            if (this.useAdditionalAnnotationFile) {
                Data additionalAnnotationData = context.getInputData(DataFormats.ADDITIONAL_ANNOTATION_TSV);
                translator = EoulsanTranslatorUtils.loadTranslator(additionalAnnotationData.getDataFile(), linksFile);
            } else {
                translator = EoulsanTranslatorUtils.loadTranslator(linksFile);
            }
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        StringBuilder descriptionString = new StringBuilder();
        try {
            DataFile outputDir = context.getStepOutputDirectory();
            ArrayList<DataFile> files = new ArrayList<DataFile>();
            ArrayList<DataFile> filesToConvert = new ArrayList<DataFile>();
            context.getLogger().info("Search files in directory: " + context.getOutputDirectory());
            context.getLogger().info("Output directory: " + outputDir);
            for (DataFile f : context.getOutputDirectory().list()) {
                if (!f.exists()) continue;
                if (!f.getMetaData().isDir()) {
                    files.add(f);
                    continue;
                }
                if (!f.getName().endsWith("_output")) continue;
                files.addAll(f.list());
            }
            for (DataFile f : files) {
                if (!this.pathMatcher.matches(new File(f.getName()).toPath())) continue;
                filesToConvert.add(f);
            }
            HashSet<String> processedFilenames = new HashSet<String>();
            for (DataFile inFile : filesToConvert) {
                if (processedFilenames.contains(inFile.getName())) continue;
                processedFilenames.add(inFile.getName());
                for (Map.Entry<String, DataFormat> e : this.outputFormats.entrySet()) {
                    XLSXTranslatorOutputFormat of;
                    DataFile outFile;
                    DataFormat format = e.getValue();
                    String prefix = this.outputPrefix + StringUtils.filenameWithoutExtension((String)inFile.getName());
                    if (format == DataFormats.ANNOTATED_EXPRESSION_RESULTS_XLSX) {
                        outFile = new DataFile(outputDir, prefix + DataFormats.ANNOTATED_EXPRESSION_RESULTS_XLSX.getDefaultExtension());
                        DiffanaResultsAnnotationModule.checkIfFileExists(outFile, context);
                        of = new XLSXTranslatorOutputFormat(outFile.create(), context.getLocalTempDirectory());
                    } else if (format == DataFormats.ANNOTATED_EXPRESSION_RESULTS_ODS) {
                        outFile = new DataFile(outputDir, prefix + DataFormats.ANNOTATED_EXPRESSION_RESULTS_ODS.getDefaultExtension());
                        DiffanaResultsAnnotationModule.checkIfFileExists(outFile, context);
                        of = new ODSTranslatorOutputFormat(outFile.create());
                    } else {
                        outFile = new DataFile(outputDir, prefix + DataFormats.ANNOTATED_EXPRESSION_RESULTS_TSV.getDefaultExtension());
                        DiffanaResultsAnnotationModule.checkIfFileExists(outFile, context);
                        of = new TSVTranslatorOutputFormat(outFile.create());
                    }
                    TranslatorUtils.addTranslatorFields((InputStream)inFile.open(), (int)0, (Translator)translator, (TranslatorOutputFormat)of);
                    descriptionString.append("Convert ");
                    descriptionString.append(inFile);
                    descriptionString.append(" to ");
                    descriptionString.append(outFile);
                    descriptionString.append("\n");
                }
            }
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        status.setDescription(descriptionString.toString());
        return status.createTaskResult();
    }

    private static void checkIfFileExists(DataFile file, TaskContext context) throws IOException {
        if (file.exists()) {
            throw new IOException("Output file of the \"" + context.getCurrentStep().getId() + "\" already exists: " + file);
        }
    }
}

