/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.expression;

import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.CheckerModule;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.ExpressionCounter;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.ExpressionCounterService;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Set;

public abstract class AbstractExpressionModule
extends AbstractModule {
    public static final String MODULE_NAME = "expression";
    protected static final String COUNTER_GROUP = "expression";
    public static final String COUNTER_PARAMETER_NAME = "counter";
    public static final String FEATURES_FILE_FORMAT_PARAMETER_NAME = "features.file.format";
    public static final String OUTPUT_FILE_FORMAT_PARAMETER_NAME = "output.file.format";
    private static final String OLD_EOULSAN_COUNTER_NAME = "eoulsanCounter";
    private static final String OLD_REMOVE_AMBIGUOUS_CASES_PARAMETER_NAME = "removeambiguouscases";
    private static final String OLD_OVERLAP_MODE_PARAMETER_NAME = "overlapmode";
    private static final String OLD_GENOMIC_TYPE_PARAMETER_NAME = "genomictype";
    private static final String OLD_ATTRIBUTE_ID_PARAMETER_NAME = "attributeid";
    private static final String OLD_SPLIT_ATTRIBUTE_VALUES_PARAMETER_NAME = "splitattributevalues";
    private boolean gtfInputFormat;
    private boolean samOutputFormat;
    private ExpressionCounter counter;

    protected boolean isGTFInputFormat() {
        return this.gtfInputFormat;
    }

    protected boolean isSAMOutputFormat() {
        return this.samOutputFormat;
    }

    protected ExpressionCounter getExpressionCounter() {
        return this.counter;
    }

    @Override
    public String getName() {
        return "expression";
    }

    @Override
    public String getDescription() {
        return "This module compute the expression.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("alignments", DataFormats.MAPPER_RESULTS_SAM);
        builder.addPort("featuresannotation", this.gtfInputFormat ? DataFormats.ANNOTATION_GTF : DataFormats.ANNOTATION_GFF);
        builder.addPort("genomedescription", DataFormats.GENOME_DESC_TXT);
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        if (this.samOutputFormat) {
            return OutputPortsBuilder.singleOutputPort(DataFormats.MAPPER_RESULTS_SAM);
        }
        return OutputPortsBuilder.singleOutputPort(DataFormats.EXPRESSION_RESULTS_TSV);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        Parameter counterParameter = Modules.getParameter(stepParameters, COUNTER_PARAMETER_NAME);
        if (counterParameter == null) {
            Modules.invalidConfiguration(context, "No counter to use defined");
        }
        String counterName = counterParameter.getLowerStringValue();
        if (OLD_EOULSAN_COUNTER_NAME.toLowerCase().equals(counterName)) {
            EoulsanLogger.getLogger().warning("The eoulsanCounter counter support has been removed");
        }
        this.counter = (ExpressionCounter)ExpressionCounterService.getInstance().newService(counterName);
        if (this.counter == null) {
            Modules.invalidConfiguration(context, "Unknown counter: " + counterName);
        }
        this.counter.setLogger(context.getGenericLogger());
        if ("htseq-count".equals(counterName)) {
            for (Parameter p : stepParameters) {
                switch (p.getName()) {
                    case "genomictype": {
                        Modules.renamedParameter(context, p, "genomic.type", true);
                        break;
                    }
                    case "attributeid": {
                        Modules.renamedParameter(context, p, "attribute.id", true);
                        break;
                    }
                    case "overlapmode": {
                        Modules.renamedParameter(context, p, "overlap.mode", true);
                        break;
                    }
                    case "removeambiguouscases": {
                        Modules.renamedParameter(context, p, "remove.ambiguous.cases", true);
                        break;
                    }
                    case "splitattributevalues": {
                        Modules.renamedParameter(context, p, "split.attribute.values", true);
                    }
                }
            }
        }
        for (Parameter p : stepParameters) {
            block21 : switch (p.getName()) {
                case "counter": {
                    break;
                }
                case "features.file.format": {
                    switch (p.getLowerStringValue()) {
                        case "gtf": {
                            this.gtfInputFormat = true;
                            break block21;
                        }
                        case "gff": 
                        case "gff3": {
                            this.gtfInputFormat = false;
                            break block21;
                        }
                    }
                    Modules.badParameterValue(context, p, "Unknown annotation file format");
                    break;
                }
                case "output.file.format": {
                    switch (p.getLowerStringValue()) {
                        case "tsv": {
                            this.samOutputFormat = false;
                            break block21;
                        }
                        case "sam": {
                            this.samOutputFormat = true;
                            break block21;
                        }
                    }
                    Modules.badParameterValue(context, p, "Unknown output file format");
                    break;
                }
                default: {
                    try {
                        this.counter.setParameter(p.getName(), p.getValue());
                        break;
                    }
                    catch (KenetreException e) {
                        throw new EoulsanException("The invalid value (" + p.getValue() + ") for \"" + p.getName() + "\" parameter in the \"" + context.getCurrentStep().getId() + "\" step: " + e.getMessage(), e);
                    }
                }
            }
        }
        try {
            this.counter.checkConfiguration();
        }
        catch (KenetreException e) {
            throw new EoulsanException(e);
        }
        if (context.getRuntime().getMode() != AbstractEoulsanRuntime.EoulsanExecMode.CLUSTER_TASK) {
            CheckerModule.configureChecker(this.gtfInputFormat ? DataFormats.ANNOTATION_GTF : DataFormats.ANNOTATION_GFF, stepParameters);
        }
        EoulsanLogger.getLogger().info("In " + this.getName() + ", counter=" + this.counter.getName());
    }
}

