/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.expression;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.HadoopCompatible;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.ParallelizationMode;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.util.EoulsanTranslatorUtils;
import fr.ens.biologie.genomique.kenetre.translator.Translator;
import fr.ens.biologie.genomique.kenetre.translator.TranslatorUtils;
import fr.ens.biologie.genomique.kenetre.translator.io.ODSTranslatorOutputFormat;
import fr.ens.biologie.genomique.kenetre.translator.io.TSVTranslatorOutputFormat;
import fr.ens.biologie.genomique.kenetre.translator.io.TranslatorOutputFormat;
import fr.ens.biologie.genomique.kenetre.translator.io.XLSXTranslatorOutputFormat;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@HadoopCompatible
public class ExpressionResultsAnnotationModule
extends AbstractModule {
    public static final String MODULE_NAME = "expressionresultsannotation";
    public static final String COUNTER_GROUP = "expressionresultsannotation";
    private static final DataFormat DEFAULT_FORMAT = DataFormats.ANNOTATED_EXPRESSION_RESULTS_TSV;
    private final Map<String, DataFormat> outputFormats = new HashMap<String, DataFormat>();
    private boolean useAdditionalAnnotationFile = true;

    @Override
    public String getName() {
        return "expressionresultsannotation";
    }

    @Override
    public String getDescription() {
        return "This module add annotation to expression files";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("expressionfile", DataFormats.EXPRESSION_RESULTS_TSV, true);
        if (this.useAdditionalAnnotationFile) {
            builder.addPort("additionalannotation", DataFormats.ADDITIONAL_ANNOTATION_TSV, true);
        }
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        OutputPortsBuilder builder = new OutputPortsBuilder();
        for (Map.Entry<String, DataFormat> e : this.outputFormats.entrySet()) {
            builder.addPort(e.getKey() + "output", e.getValue());
        }
        return builder.create();
    }

    @Override
    public ParallelizationMode getParallelizationMode() {
        Collection<DataFormat> formats = this.outputFormats.values();
        if (EoulsanRuntime.getRuntime().getMode() == AbstractEoulsanRuntime.EoulsanExecMode.LOCAL && (formats.contains(DataFormats.ANNOTATED_EXPRESSION_RESULTS_ODS) || formats.contains(DataFormats.ANNOTATED_EXPRESSION_RESULTS_XLSX))) {
            return ParallelizationMode.OWN_PARALLELIZATION;
        }
        return ParallelizationMode.STANDARD;
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        block22: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "annotationfile": {
                    Modules.removedParameter(context, p);
                    break;
                }
                case "use.additional.annotation.file": {
                    this.useAdditionalAnnotationFile = p.getBooleanValue();
                    break;
                }
                case "outputformat": {
                    Modules.renamedParameter(context, p, "output.format");
                }
                case "output.format": {
                    Iterator iterator = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)p.getValue()).iterator();
                    block23: while (iterator.hasNext()) {
                        String format;
                        switch (format = (String)iterator.next()) {
                            case "tsv": {
                                this.outputFormats.put(format, DataFormats.ANNOTATED_EXPRESSION_RESULTS_TSV);
                                continue block23;
                            }
                            case "ods": {
                                this.outputFormats.put(format, DataFormats.ANNOTATED_EXPRESSION_RESULTS_ODS);
                                continue block23;
                            }
                            case "xlsx": {
                                this.outputFormats.put(format, DataFormats.ANNOTATED_EXPRESSION_RESULTS_XLSX);
                                continue block23;
                            }
                        }
                        throw new EoulsanException("Unknown output format: " + format);
                    }
                    continue block22;
                }
                default: {
                    Modules.unknownParameter(context, p);
                }
            }
        }
        if (this.outputFormats.isEmpty()) {
            this.outputFormats.put(DEFAULT_FORMAT.getDefaultExtension().substring(1), DEFAULT_FORMAT);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        Translator translator;
        System.setProperty("javax.accessibility.assistive_technologies", "");
        DataFile linksFile = EoulsanTranslatorUtils.getLinksFileFromSettings(context.getSettings());
        try {
            if (this.useAdditionalAnnotationFile) {
                Data additionalAnnotationData = context.getInputData(DataFormats.ADDITIONAL_ANNOTATION_TSV);
                translator = EoulsanTranslatorUtils.loadTranslator(additionalAnnotationData.getDataFile(), linksFile);
            } else {
                translator = EoulsanTranslatorUtils.loadTranslator(linksFile);
            }
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        StringBuilder resultString = new StringBuilder();
        try {
            Data inData = context.getInputData(DataFormats.EXPRESSION_RESULTS_TSV);
            DataFile inFile = inData.getDataFile();
            for (Map.Entry<String, DataFormat> e : this.outputFormats.entrySet()) {
                DataFormat format = e.getValue();
                Data outData = context.getOutputData(format, inData);
                DataFile outFile = outData.getDataFile();
                Object of = format == DataFormats.ANNOTATED_EXPRESSION_RESULTS_XLSX ? new XLSXTranslatorOutputFormat(outFile.create(), context.getLocalTempDirectory()) : (format == DataFormats.ANNOTATED_EXPRESSION_RESULTS_ODS ? new ODSTranslatorOutputFormat(outFile.create()) : new TSVTranslatorOutputFormat(outFile.create()));
                TranslatorUtils.addTranslatorFields((InputStream)inFile.open(), (int)0, (Translator)translator, (TranslatorOutputFormat)of);
                resultString.append("Convert ");
                resultString.append(inFile);
                resultString.append(" to ");
                resultString.append(outFile);
                resultString.append('\n');
            }
        }
        catch (IOException e) {
            return status.createTaskResult(e);
        }
        status.setDescription(resultString.toString());
        return status.createTaskResult();
    }
}

