/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.expression;

import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.ExpressionCounter;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FinalExpressionFeaturesCreator {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private ExpressionCounter counter;
    private final Map<String, ExpressionFeature> expressionResults = new HashMap<String, ExpressionFeature>();

    public void initializeExpressionResults() {
        this.expressionResults.clear();
        HashMap emptyMap = new HashMap();
        this.counter.addZeroCountFeatures(emptyMap);
        for (String id : emptyMap.keySet()) {
            this.expressionResults.put(id, new ExpressionFeature(id));
        }
    }

    public void loadPreResults(File preResultFile) throws IOException {
        this.loadPreResults(FileUtils.createInputStream((File)preResultFile));
    }

    public void loadPreResults(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, CHARSET));
        String[] tab = new String[2];
        String line = null;
        while ((line = br.readLine()) != null) {
            StringUtils.fastSplit((String)line, (String[])tab);
            String id = tab[0];
            int alignmentCount = Integer.parseInt(tab[1]);
            if (!this.expressionResults.containsKey(id)) continue;
            this.expressionResults.get(id).setExpressionResult(alignmentCount);
        }
        br.close();
    }

    public void saveFinalResults(File resultFile) throws IOException {
        this.saveFinalResults(FileUtils.createOutputStream((File)resultFile));
    }

    public void saveFinalResults(OutputStream os) throws IOException {
        ArrayList<ExpressionFeature> list = new ArrayList<ExpressionFeature>(this.expressionResults.values());
        Collections.sort(list);
        OutputStreamWriter osw = new OutputStreamWriter(os, CHARSET);
        osw.write("Id\tCount\n");
        for (ExpressionFeature ef : list) {
            osw.write(ef.toString() + "\n");
        }
        osw.close();
    }

    public FinalExpressionFeaturesCreator(ExpressionCounter counter) {
        if (counter == null) {
            throw new NullPointerException("counter argument is null.");
        }
        this.counter = counter;
    }

    private static final class ExpressionFeature
    implements Comparable<ExpressionFeature> {
        private final String id;
        private int alignmentCount = 0;

        public void setExpressionResult(int alignmentCount) {
            this.alignmentCount = alignmentCount;
        }

        @Override
        public int compareTo(ExpressionFeature o) {
            if (o == null) {
                return 1;
            }
            int diff = this.id.compareTo(o.id);
            if (diff != 0) {
                return diff;
            }
            return o.alignmentCount - this.alignmentCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionFeature)) {
                return false;
            }
            ExpressionFeature et = (ExpressionFeature)o;
            return Utils.equal((Object)this.id, (Object)et.id) && this.alignmentCount == et.alignmentCount;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.alignmentCount);
        }

        public String toString() {
            return this.id + "\t" + this.alignmentCount;
        }

        public ExpressionFeature(String id) {
            if (id == null) {
                throw new NullPointerException("Identifier to add is null");
            }
            this.id = id;
        }
    }
}

