/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.expression.hadoop;

import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.modules.expression.ExpressionCounterCounter;
import fr.ens.biologie.genomique.eoulsan.modules.expression.hadoop.ExpressionHadoopModule;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopReporterIncrementer;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.PathUtils;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.SAMUtils;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.ExpressionCounter;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class ExpressionMapper
extends Mapper<Text, Text, Text, LongWritable> {
    private ExpressionCounter counter;
    private String counterGroup;
    private final SAMLineParser parser = new SAMLineParser(new SAMFileHeader());
    private final Pattern recordSplitterPattern = Pattern.compile("\u00a3");
    private final List<SAMRecord> samRecords = new ArrayList<SAMRecord>();
    private ReporterIncrementer reporter;
    private final Text outKey = new Text();
    private final LongWritable outValue = new LongWritable(1L);

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        EoulsanLogger.initConsoleHandler();
        EoulsanLogger.getLogger().info("Start of setup()");
        Configuration conf = context.getConfiguration();
        this.counterGroup = conf.get(CommonHadoop.COUNTER_GROUP_KEY);
        if (this.counterGroup == null) {
            throw new IOException("No counter group defined");
        }
        this.reporter = new HadoopReporterIncrementer((TaskInputOutputContext)context);
        URI[] localCacheFiles = context.getCacheFiles();
        this.counter = ExpressionMapper.initCounterAndParser(conf, this.parser, localCacheFiles);
        EoulsanLogger.getLogger().info("End of setup()");
    }

    static ExpressionCounter initCounterAndParser(Configuration conf, SAMLineParser parser, URI[] localCacheFiles) throws IOException {
        try {
            if (localCacheFiles == null || localCacheFiles.length == 0) {
                throw new IOException("Unable to retrieve genome index");
            }
            if (localCacheFiles.length > 1) {
                throw new IOException("Retrieve more than one file in distributed cache");
            }
            EoulsanLogger.getLogger().info("Genome index compressed file (from distributed cache): " + localCacheFiles[0]);
            if (localCacheFiles == null || localCacheFiles.length == 0) {
                throw new IOException("Unable to retrieve annotation index");
            }
            if (localCacheFiles.length > 1) {
                throw new IOException("Retrieve more than one file in distributed cache");
            }
            ExpressionCounter counter = ExpressionMapper.loadSerializedCounter(PathUtils.createInputStream(new Path(localCacheFiles[0]), conf));
            String genomeDescFile = conf.get(ExpressionHadoopModule.GENOME_DESC_PATH_KEY);
            if (genomeDescFile == null) {
                throw new IOException("No genome desc file set");
            }
            GenomeDescription genomeDescription = GenomeDescription.load((InputStream)PathUtils.createInputStream(new Path(genomeDescFile), conf));
            parser.getFileHeader().setSequenceDictionary(SAMUtils.newSAMSequenceDictionary((GenomeDescription)genomeDescription));
            return counter;
        }
        catch (IOException e) {
            EoulsanLogger.getLogger().severe("Error while loading annotation data in Mapper: " + e.getMessage());
            throw new IOException(e);
        }
    }

    public void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String line = value.toString();
        if (line.length() > 0 && line.charAt(0) == '@') {
            return;
        }
        this.samRecords.clear();
        try {
            for (String field : this.recordSplitterPattern.split(line)) {
                this.samRecords.add(this.parser.parseLine(field));
            }
            if (this.samRecords.isEmpty() || this.samRecords.size() > 2) {
                throw new EoulsanException("Invalid number of SAM record(s) found in the entry: " + this.samRecords.size());
            }
            Map counts = this.counter.count(this.samRecords, this.reporter, this.counterGroup);
            for (Map.Entry e : counts.entrySet()) {
                this.outKey.set((String)e.getKey());
                this.outValue.set((long)((Integer)e.getValue()).intValue());
                context.write((Object)this.outKey, (Object)this.outValue);
            }
        }
        catch (EoulsanException | KenetreException | SAMFormatException e) {
            context.getCounter(this.counterGroup, ExpressionCounterCounter.INVALID_SAM_ENTRIES_COUNTER.counterName()).increment(1L);
            EoulsanLogger.getLogger().info("Invalid SAM output entry: " + e.getMessage() + " line='" + line + "'");
        }
    }

    public void cleanup(Mapper.Context context) throws IOException {
    }

    private static ExpressionCounter loadSerializedCounter(InputStream in) throws IOException {
        ExpressionCounter expressionCounter;
        if (in == null) {
            throw new NullPointerException("is argument cannot be null");
        }
        ObjectInputStream ois = new ObjectInputStream(in);
        try {
            expressionCounter = (ExpressionCounter)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Unable to load data.");
            }
        }
        ois.close();
        return expressionCounter;
    }
}

