/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.expression.local;

import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.expression.AbstractExpressionModule;
import fr.ens.biologie.genomique.eoulsan.modules.expression.ExpressionCounterUtils;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.expressioncounter.ExpressionCounter;
import fr.ens.biologie.genomique.kenetre.bio.io.TSVCountsWriter;
import fr.ens.biologie.genomique.kenetre.util.LocalReporter;
import fr.ens.biologie.genomique.kenetre.util.Reporter;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

@LocalOnly
public class ExpressionLocalModule
extends AbstractExpressionModule {
    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            Data featuresAnnotationData = context.getInputData(this.isGTFInputFormat() ? DataFormats.ANNOTATION_GTF : DataFormats.ANNOTATION_GFF);
            Data alignmentData = context.getInputData(DataFormats.MAPPER_RESULTS_SAM);
            Data genomeDescriptionData = context.getInputData(DataFormats.GENOME_DESC_TXT);
            Data expressionData = context.getOutputData(this.isSAMOutputFormat() ? DataFormats.MAPPER_RESULTS_SAM : DataFormats.EXPRESSION_RESULTS_TSV, alignmentData);
            ExpressionCounter counter = this.getExpressionCounter();
            LocalReporter reporter = new LocalReporter();
            DataFile annotationFile = featuresAnnotationData.getDataFile();
            DataFile alignmentFile = alignmentData.getDataFile();
            DataFile genomeDescFile = genomeDescriptionData.getDataFile();
            DataFile expressionFile = expressionData.getDataFile();
            ExpressionCounterUtils.init(counter, genomeDescFile, annotationFile, this.isGTFInputFormat());
            String sampleCounterHeader = "Expression computation with " + counter.getName() + " (" + alignmentData.getName() + ", " + alignmentFile.getName() + ", " + annotationFile.getName() + ", " + counter.toString() + ")";
            status.setDescription(sampleCounterHeader);
            if (this.isSAMOutputFormat()) {
                Map result = counter.count(alignmentFile.open(), expressionFile.create(), context.getLocalTempDirectory(), (ReporterIncrementer)reporter, "expression");
            } else {
                Map<String, Integer> result = ExpressionCounterUtils.count(counter, alignmentFile, (ReporterIncrementer)reporter, "expression");
                counter.addZeroCountFeatures(result);
                try (TSVCountsWriter writer = new TSVCountsWriter(expressionFile.create());){
                    writer.write(result);
                }
            }
            status.setCounters((Reporter)reporter, "expression");
            return status.createTaskResult();
        }
        catch (FileNotFoundException e) {
            return status.createTaskResult(e, "File not found: " + e.getMessage());
        }
        catch (IOException e) {
            return status.createTaskResult(e, "Error while computing expression: " + e.getMessage());
        }
        catch (KenetreException e) {
            return status.createTaskResult(e, "Error while reading the annotation file: " + e.getMessage());
        }
    }
}

