/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.fastqc;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Sequence;

public class EmptyFileQC
extends AbstractQCModule {
    private final String filename;

    public String description() {
        return "Calculates some basic statistics about the file";
    }

    public boolean ignoreFilteredSequences() {
        return false;
    }

    public JPanel getResultsPanel() {
        JPanel returnPanel = new JPanel();
        returnPanel.setLayout(new BorderLayout());
        returnPanel.add((Component)new JLabel("Basic sequence stats", 0), "North");
        ResultsTable model = new ResultsTable();
        returnPanel.add((Component)new JScrollPane(new JTable(model)), "Center");
        return returnPanel;
    }

    public void reset() {
    }

    public String name() {
        return "Basic Statistics";
    }

    public void processSequence(Sequence sequence) {
    }

    public boolean raisesError() {
        return true;
    }

    public boolean raisesWarning() {
        return false;
    }

    public boolean ignoreInReport() {
        return false;
    }

    public void makeReport(HTMLReportArchive report) throws XMLStreamException, IOException {
        super.writeTable(report, (TableModel)new ResultsTable());
    }

    public EmptyFileQC(DataFile file) {
        this.filename = file.getName();
    }

    private class ResultsTable
    extends AbstractTableModel {
        private final String[] rowNames = new String[]{"Filename", "Total Sequences"};

        private ResultsTable() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.rowNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.rowNames[rowIndex];
                }
                case 1: {
                    switch (rowIndex) {
                        case 0: {
                            return EmptyFileQC.this.filename;
                        }
                        case 1: {
                            return "0";
                        }
                    }
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Measure";
                }
                case 1: {
                    return "Value";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }
    }
}

