/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.fastqc;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.HadoopCompatible;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.fastqc.CounterSequenceFile;
import fr.ens.biologie.genomique.eoulsan.modules.fastqc.EmptyFileQC;
import fr.ens.biologie.genomique.eoulsan.modules.fastqc.FastQCRuntimePatcher;
import fr.ens.biologie.genomique.eoulsan.modules.fastqc.FastqSequenceFile;
import fr.ens.biologie.genomique.eoulsan.modules.fastqc.SAMSequenceFile;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import uk.ac.babraham.FastQC.Modules.AbstractQCModule;
import uk.ac.babraham.FastQC.Modules.AdapterContent;
import uk.ac.babraham.FastQC.Modules.BasicStats;
import uk.ac.babraham.FastQC.Modules.KmerContent;
import uk.ac.babraham.FastQC.Modules.NContent;
import uk.ac.babraham.FastQC.Modules.OverRepresentedSeqs;
import uk.ac.babraham.FastQC.Modules.PerBaseQualityScores;
import uk.ac.babraham.FastQC.Modules.PerBaseSequenceContent;
import uk.ac.babraham.FastQC.Modules.PerSequenceGCContent;
import uk.ac.babraham.FastQC.Modules.PerSequenceQualityScores;
import uk.ac.babraham.FastQC.Modules.PerTileQualityScores;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Modules.SequenceLengthDistribution;
import uk.ac.babraham.FastQC.Report.HTMLReportArchive;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;

@HadoopCompatible
public class FastQCModule
extends AbstractModule {
    private static final String MODULE_NAME = "fastqc";
    private static final String INPUT_FORMAT_PARAMETER_NAME = "input.format";
    public static final String FASTQC_KMER_SIZE_PARAMETER_NAME = "fastqc.kmer.size";
    public static final String FASTQC_NOGROUP_PARAMETER_NAME = "fastqc.nogroup";
    public static final String FASTQC_EXPGROUP_PARAMETER_NAME = "fastqc.expgroup";
    public static final String FASTQC_CASAVA_PARAMETER_NAME = "fastqc.casava";
    public static final String FASTQC_NOFILTER_PARAMETER_NAME = "fastqc.nofilter";
    private DataFormat inputFormat = DataFormats.READS_FASTQ;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "This module launch FastQC on FASTQ or SAM files and generate an html report";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        if (this.inputFormat == DataFormats.READS_FASTQ) {
            builder.addPort("input", DataFormats.READS_FASTQ);
        } else {
            builder.addPort("input", DataFormats.MAPPER_RESULTS_SAM);
        }
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        OutputPortsBuilder builder = new OutputPortsBuilder();
        builder.addPort("htmlreport", DataFormats.FASTQC_REPORT_HTML);
        builder.addPort("zipreport", DataFormats.FASTQC_REPORT_ZIP);
        return builder.create();
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        System.setProperty("java.awt.headless", "true");
        System.setProperty("fastqc.unzip", "true");
        System.setProperty("javax.accessibility.assistive_technologies", "");
        block16: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "input.format": {
                    DataFormat format = DataFormatRegistry.getInstance().getDataFormatFromNameOrAlias(p.getLowerStringValue());
                    if (!DataFormats.MAPPER_RESULTS_SAM.equals(format) && !DataFormats.READS_FASTQ.equals(format)) {
                        Modules.badParameterValue(context, p, "Unknown or format not supported as input format for FastQC");
                    }
                    this.inputFormat = format;
                    continue block16;
                }
                case "fastqc.kmer.size": {
                    System.setProperty("fastqc.kmer_size", "" + p.getIntValueGreaterOrEqualsTo(1));
                    continue block16;
                }
                case "fastqc.nogroup": {
                    System.setProperty(FASTQC_NOGROUP_PARAMETER_NAME, "" + p.getBooleanValue());
                    continue block16;
                }
                case "fastqc.expgroup": {
                    System.setProperty(FASTQC_EXPGROUP_PARAMETER_NAME, "" + p.getBooleanValue());
                    continue block16;
                }
                case "fastqc.casava": {
                    System.setProperty(FASTQC_CASAVA_PARAMETER_NAME, "" + p.getBooleanValue());
                    continue block16;
                }
                case "fastqc.nofilter": {
                    System.setProperty(FASTQC_NOFILTER_PARAMETER_NAME, "" + p.getBooleanValue());
                    continue block16;
                }
            }
            Modules.unknownParameter(context, p);
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        int i;
        try {
            FastQCRuntimePatcher.patchFastQC();
        }
        catch (EoulsanException e1) {
            return status.createTaskResult(e1);
        }
        Data inData = context.getInputData(this.inputFormat);
        Data htmlOutData = context.getOutputData(DataFormats.FASTQC_REPORT_HTML, inData);
        Data zipOutData = context.getOutputData(DataFormats.FASTQC_REPORT_ZIP, inData);
        ArrayList<DataFile> inputFiles = new ArrayList<DataFile>();
        if (inData.getFormat().getMaxFilesCount() > 1) {
            for (i = 0; i < inData.getDataFileCount(); ++i) {
                inputFiles.add(inData.getDataFile(i));
            }
        } else {
            inputFiles.add(inData.getDataFile());
        }
        try {
            i = 0;
            for (DataFile inputFile : inputFiles) {
                DataFile htmlReportFile = htmlOutData.getDataFile(i);
                DataFile zipReportFile = zipOutData.getDataFile(i++);
                this.processFile(inputFile, this.inputFormat == DataFormats.READS_FASTQ, htmlReportFile, zipReportFile, context.getLocalTempDirectory(), status);
            }
            return status.createTaskResult();
        }
        catch (SequenceFormatException e) {
            return status.createTaskResult(e, "Error with sequence file format: " + e.getMessage());
        }
        catch (IOException e) {
            return status.createTaskResult(e, "Error while parsing file: " + e.getMessage());
        }
        catch (XMLStreamException e) {
            return status.createTaskResult(e, "Error while writing final report: " + e.getMessage());
        }
    }

    private void processFile(DataFile inputFile, boolean fastqFormat, DataFile htmlOutputFile, DataFile zipOutputFile, File tmpDir, TaskStatus status) throws SequenceFormatException, IOException, XMLStreamException {
        status.setDescription("Process sequence of " + inputFile + " for FastQC");
        CounterSequenceFile seqFile = fastqFormat ? new FastqSequenceFile(inputFile) : new SAMSequenceFile(inputFile);
        OverRepresentedSeqs os = new OverRepresentedSeqs();
        ArrayList<AbstractQCModule> modules = new ArrayList<AbstractQCModule>(Arrays.asList(new BasicStats(), new PerBaseQualityScores(), new PerTileQualityScores(), new PerSequenceQualityScores(), new PerBaseSequenceContent(), new PerSequenceGCContent(), new NContent(), new SequenceLengthDistribution(), os.duplicationLevelModule(), os, new AdapterContent(), new KmerContent()));
        this.processSequences(modules, seqFile);
        ArrayList<AbstractQCModule> reportModules = seqFile.getCount() > 0L ? modules : Collections.singletonList(new EmptyFileQC(inputFile));
        status.setDescription("Create FastQC report on " + inputFile + " in " + htmlOutputFile.getName());
        this.createReport(reportModules, seqFile, htmlOutputFile, zipOutputFile, tmpDir);
        modules.clear();
    }

    private void processSequences(List<AbstractQCModule> modules, SequenceFile seqFile) throws SequenceFormatException {
        while (seqFile.hasNext()) {
            Sequence seq = seqFile.next();
            for (QCModule qCModule : modules) {
                qCModule.processSequence(seq);
            }
        }
    }

    private void createReport(List<AbstractQCModule> modules, SequenceFile seqFile, DataFile htmlReportFile, DataFile zipOutputFile, File tempDirectory) throws IOException, XMLStreamException {
        String reportExtension = DataFormats.FASTQC_REPORT_HTML.getDefaultExtension();
        File reportTempFile = File.createTempFile("reportfile-", reportExtension, tempDirectory);
        new HTMLReportArchive(seqFile, modules.toArray(new QCModule[0]), reportTempFile);
        String baseFilename = StringUtils.filenameWithoutExtension((String)reportTempFile.getName());
        File zipDir = new File(reportTempFile.getParentFile(), baseFilename);
        File zipFile = new File(zipDir.getParentFile(), baseFilename + ".zip");
        if (!zipFile.delete()) {
            EoulsanLogger.getLogger().warning("Unable to remove original FastQC output zip file: " + zipFile);
        }
        FastQCModule.zipDirectory(zipDir, zipFile, StringUtils.filenameWithoutExtension((String)htmlReportFile.getName()));
        if (!FileUtils.recursiveDelete((File)zipDir)) {
            EoulsanLogger.getLogger().warning("Unable to remove FastQC output directory: " + zipDir);
        }
        DataFiles.copy(new DataFile(reportTempFile), htmlReportFile);
        DataFiles.copy(new DataFile(zipFile), zipOutputFile);
        if (!zipFile.delete()) {
            EoulsanLogger.getLogger().warning("Unable to remove rezipped FastQC output zip file: " + zipFile);
        }
        if (!reportTempFile.delete()) {
            EoulsanLogger.getLogger().warning("Unable to remove FastQC temporary output file: " + reportTempFile);
        }
    }

    private static void zipDirectory(File directory, File zipFile, String subdirName) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        FileUtils.zipFolder((File)directory, (String)(subdirName + "/"), (ZipOutputStream)out, (boolean)false);
        out.close();
    }
}

