/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.fastqc;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.imageio.ImageIO;
import uk.ac.babraham.FastQC.Modules.QCModule;
import uk.ac.babraham.FastQC.Report.HTMLReportArchiveNeigborClass;
import uk.ac.babraham.FastQC.Utilities.ImageToBase64;

public class FastQCRuntimePatcher {
    private static final String CLASS_NAME = "uk.ac.babraham.FastQC.Report.HTMLReportArchive";

    public static synchronized void patchFastQC() throws EoulsanException {
        try {
            ClassClassPath ccpath = new ClassClassPath(QCModule.class);
            ClassPool pool = ClassPool.getDefault();
            pool.insertClassPath((ClassPath)ccpath);
            CtClass cc = pool.get(CLASS_NAME);
            if (cc != null && !cc.isFrozen()) {
                CtMethod oldBase64ForIconMethod = cc.getDeclaredMethod("base64ForIcon");
                cc.removeMethod(oldBase64ForIconMethod);
                CtMethod newBase64ForIconMethod = CtNewMethod.make((String)"private String base64ForIcon (String path) {  return fr.ens.biologie.genomique.eoulsan.modules.fastqc.FastQCRuntimePatcher.base64ForIcon(path, this.getClass()); } ", (CtClass)cc);
                cc.addMethod(newBase64ForIconMethod);
                if (FastQCRuntimePatcher.isJavaModuleSystemAvailable()) {
                    cc.toClass(HTMLReportArchiveNeigborClass.class);
                } else {
                    cc.toClass();
                }
            }
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new EoulsanException(e);
        }
    }

    private static boolean isJavaModuleSystemAvailable() {
        String javaSpecVersion = System.getProperty("java.vm.specification.version");
        return javaSpecVersion.indexOf(46) == -1;
    }

    public static String base64ForIcon(String path, Class clazz) {
        try {
            BufferedImage b = ImageIO.read(clazz.getResourceAsStream("/Templates/" + path));
            return ImageToBase64.imageToBase64((BufferedImage)b);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "Failed";
        }
    }
}

