/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.fastqc;

import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.modules.fastqc.CounterSequenceFile;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import uk.ac.babraham.FastQC.Sequence.Sequence;
import uk.ac.babraham.FastQC.Sequence.SequenceFile;
import uk.ac.babraham.FastQC.Sequence.SequenceFormatException;

public class FastqSequenceFile
implements CounterSequenceFile {
    private final DataFile file;
    private final FastqReader reader;
    private long count;

    public File getFile() {
        return new File(this.file.getName());
    }

    public int getPercentComplete() {
        return 0;
    }

    public boolean hasNext() {
        return this.reader.hasNext();
    }

    public boolean isColorspace() {
        return false;
    }

    public String name() {
        return this.file.getName();
    }

    public Sequence next() throws SequenceFormatException {
        ReadSequence read = this.reader.next();
        ++this.count;
        return new Sequence((SequenceFile)this, read.getSequence(), read.getQuality(), read.getName());
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public FastqSequenceFile(DataFile fastqFile) throws IOException {
        Objects.requireNonNull(fastqFile, "file argument cannot be null");
        this.file = fastqFile;
        this.reader = new FastqReader(fastqFile.open());
    }
}

