/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.generators;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.data.MapperIndexDataFormat;
import fr.ens.biologie.genomique.eoulsan.data.storages.DataFileGenomeIndexStorage;
import fr.ens.biologie.genomique.eoulsan.data.storages.DataFileGenomeMapperIndexer;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstanceBuilder;
import fr.ens.biologie.genomique.kenetre.storage.GenomeIndexStorage;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GenomeMapperIndexGeneratorModule
extends AbstractModule {
    public static final String MODULE_NAME = "genericindexgenerator";
    private Mapper mapper;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "Generate Mapper index";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return new InputPortsBuilder().addPort("genome", DataFormats.GENOME_FASTA).addPort("genomedescription", DataFormats.GENOME_DESC_TXT).create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(new MapperIndexDataFormat(this.mapper));
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        if (stepParameters == null) {
            throw new EoulsanException("No parameters set in " + this.getName() + " generator");
        }
        block6: for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "mappername": {
                    String mapperName = p.getStringValue();
                    this.mapper = new MapperBuilder(mapperName).withLogger(EoulsanLogger.getGenericLogger()).build();
                    if (this.mapper != null) continue block6;
                    Modules.badParameterValue(MODULE_NAME, p, "Unknown mapper");
                    continue block6;
                }
            }
            Modules.unknownParameter(MODULE_NAME, p);
        }
    }

    static MapperInstance searchMapperVersionAndFlavor(Mapper mapper, TaskContext context) throws EoulsanException, IOException {
        int count = 0;
        String version = null;
        String flavor = null;
        for (Step step : context.getWorkflow().getSteps()) {
            if (!"mapreads".equals(step.getModuleName()) && !"filterandmap".equals(step.getModuleName())) continue;
            for (Parameter p : step.getParameters()) {
                switch (p.getName()) {
                    case "mapper.version": {
                        version = p.getStringValue();
                        break;
                    }
                    case "mapper.flavor": {
                        flavor = p.getStringValue();
                        break;
                    }
                }
            }
            ++count;
        }
        if (count > 1) {
            throw new EoulsanException("Found more than one mapping step in the workflow");
        }
        Mapper newMapper = new MapperBuilder(mapper).withTempDirectory(context.getLocalTempDirectory()).withExecutablesTempDirectory(context.getSettings().getExecutablesTempDirectoryFile()).build();
        return new MapperInstanceBuilder(newMapper).withMapperVersion(version).withMapperFlavor(flavor).withUseBundledBinaries(true).build();
    }

    static void execute(Mapper mapper, TaskContext context, String additionalArguments, Map<String, String> additionalDescription, int threadCount) throws IOException, EoulsanException {
        Objects.requireNonNull(mapper, "mapper argument cannot be null");
        Objects.requireNonNull(context, "context argument cannot be null");
        String args = additionalArguments != null ? additionalArguments : "";
        Map<String, String> descriptions = additionalDescription != null ? additionalDescription : Collections.emptyMap();
        Data genomeData = context.getInputData(DataFormats.GENOME_FASTA);
        Data genomeDescData = context.getInputData(DataFormats.GENOME_DESC_TXT);
        Data outData = context.getOutputData((DataFormat)new MapperIndexDataFormat(mapper), genomeData);
        DataFile genomeDataFile = genomeData.getDataFile();
        DataFile descDataFile = genomeDescData.getDataFile();
        GenomeDescription desc = GenomeDescription.load((InputStream)descDataFile.open());
        DataFile mapperIndexDataFile = outData.getDataFile();
        MapperInstance mapperInstance = GenomeMapperIndexGeneratorModule.searchMapperVersionAndFlavor(mapper, context);
        int threads = threadCount < 1 ? Runtime.getRuntime().availableProcessors() : threadCount;
        String genomeMapperIndexStoragePath = context.getSettings().getGenomeMapperIndexStoragePath();
        GenomeIndexStorage genomeIndexStorage = genomeMapperIndexStoragePath != null ? DataFileGenomeIndexStorage.getInstance(genomeMapperIndexStoragePath, EoulsanLogger.getGenericLogger()) : null;
        DataFileGenomeMapperIndexer indexer = new DataFileGenomeMapperIndexer(mapperInstance, args, descriptions, threads, genomeIndexStorage, context.getLocalTempDirectory(), EoulsanLogger.getGenericLogger());
        indexer.createIndex(genomeDataFile, desc, mapperIndexDataFile);
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            status.setProgressMessage(this.mapper.getName() + " index creation");
            GenomeMapperIndexGeneratorModule.execute(this.mapper, context, null, null, 0);
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }
}

