/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.generators;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.annotations.Generator;
import fr.ens.biologie.genomique.eoulsan.annotations.LocalOnly;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.Step;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskContext;
import fr.ens.biologie.genomique.eoulsan.core.TaskResult;
import fr.ens.biologie.genomique.eoulsan.core.TaskStatus;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFiles;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.data.MapperIndexDataFormat;
import fr.ens.biologie.genomique.eoulsan.data.protocols.DataProtocol;
import fr.ens.biologie.genomique.eoulsan.data.protocols.StorageDataProtocol;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.eoulsan.modules.generators.GenomeMapperIndexGeneratorModule;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperBuilder;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@LocalOnly
@Generator
public class STARIndexGeneratorModule
extends AbstractModule {
    public static final String MODULE_NAME = "starindexgenerator";
    private final Mapper mapper = new MapperBuilder("STAR").withLogger(EoulsanLogger.getGenericLogger()).build();
    private Integer overhang = null;
    private boolean gtfFile;
    private boolean gtfFormat;
    private String chrStartEndFilename;
    private String gtfFeatureExon;
    private String gtfTagExonParentTranscript;
    private Integer genomeSAindexNbases;
    private Integer genomeChrBinNbits;
    private boolean useExpressionStepParameters;
    private String indexerArguments;

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "Generate Mapper index";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        InputPortsBuilder builder = new InputPortsBuilder();
        builder.addPort("genome", DataFormats.GENOME_FASTA).addPort("genomedescription", DataFormats.GENOME_DESC_TXT);
        if (this.gtfFile) {
            builder.addPort("annotation", this.gtfFormat ? DataFormats.ANNOTATION_GTF : DataFormats.ANNOTATION_GFF);
        }
        return builder.create();
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(new MapperIndexDataFormat(this.mapper));
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        if (stepParameters == null) {
            throw new EoulsanException("No parameters set in " + this.getName() + " generator");
        }
        for (Parameter p : stepParameters) {
            block15 : switch (p.getName()) {
                case "overhang": {
                    this.overhang = p.getIntValueGreaterOrEqualsTo(1);
                    break;
                }
                case "gtf.file": {
                    Modules.renamedParameter(context, p, "use.gtf.file");
                }
                case "use.gtf.file": {
                    this.gtfFile = p.getBooleanValue();
                    break;
                }
                case "file.chr.start.end": {
                    this.chrStartEndFilename = p.getStringValue();
                    break;
                }
                case "gtf.feature.exon": {
                    this.gtfFeatureExon = p.getStringValue();
                    break;
                }
                case "gtf.tag.exon.parent.transcript": {
                    this.gtfTagExonParentTranscript = p.getStringValue();
                    break;
                }
                case "genome.sa.index.nbases": {
                    this.genomeSAindexNbases = p.getIntValueGreaterOrEqualsTo(0);
                    break;
                }
                case "genome.chr.bin.nbits": {
                    this.genomeChrBinNbits = p.getIntValueGreaterOrEqualsTo(0);
                    break;
                }
                case "use.expression.step.parameters": {
                    this.useExpressionStepParameters = p.getBooleanValue();
                    break;
                }
                case "indexer.arguments": {
                    this.indexerArguments = p.getStringValue();
                    break;
                }
                case "local.threads": {
                    Modules.removedParameter(context, p);
                    break;
                }
                case "max.local.threads": {
                    Modules.removedParameter(context, p);
                    break;
                }
                case "features.file.format": {
                    switch (p.getLowerStringValue()) {
                        case "gtf": {
                            this.gtfFormat = true;
                            break block15;
                        }
                        case "gff": 
                        case "gff3": {
                            this.gtfFormat = false;
                            break block15;
                        }
                    }
                    Modules.badParameterValue(context, p, "Unknown annotation file format");
                    break;
                }
                default: {
                    throw new EoulsanException("Unknown parameter for " + this.getName() + " step: " + p.getName());
                }
            }
        }
    }

    private void searchExpressionStepParameters(TaskContext context) throws EoulsanException {
        int count = 0;
        for (Step step : context.getWorkflow().getSteps()) {
            if (!"expression".equals(step.getModuleName())) continue;
            for (Parameter p : step.getParameters()) {
                switch (p.getName()) {
                    case "genomic.type": {
                        this.gtfFeatureExon = p.getStringValue();
                        break;
                    }
                    case "attribute.id": {
                        this.gtfTagExonParentTranscript = p.getStringValue();
                        break;
                    }
                }
            }
            ++count;
        }
        if (count == 0) {
            throw new EoulsanException("No expression step found in the workflow");
        }
        if (count > 1) {
            throw new EoulsanException("Found more than one expression step in the workflow");
        }
    }

    @Override
    public TaskResult execute(TaskContext context, TaskStatus status) {
        try {
            StringBuilder additionalArguments = new StringBuilder();
            HashMap<String, String> additionalDescription = new HashMap<String, String>();
            ArrayList<File> temporaryFiles = new ArrayList<File>();
            if (this.useExpressionStepParameters) {
                this.searchExpressionStepParameters(context);
            }
            if (this.gtfFile) {
                Data annotationData = context.getInputData(this.gtfFormat ? DataFormats.ANNOTATION_GTF : DataFormats.ANNOTATION_GFF);
                DataFile gffFile = annotationData.getDataFile();
                File gffFilePath = this.uncompressFileIfNecessary(context, temporaryFiles, gffFile);
                additionalArguments.append("--sjdbGTFfile");
                additionalArguments.append(' ');
                additionalArguments.append(gffFilePath.getAbsolutePath());
                additionalArguments.append(' ');
                additionalDescription.put("sjdbGTFfile", FileUtils.computeMD5Sum((File)gffFilePath));
            }
            if (this.overhang != null) {
                additionalArguments.append("--sjdbOverhang");
                additionalArguments.append(' ');
                additionalArguments.append(this.overhang.toString());
                additionalArguments.append(' ');
                additionalDescription.put("sjdbOverhang", this.overhang.toString());
            }
            if (this.gtfTagExonParentTranscript != null) {
                additionalArguments.append("--sjdbGTFtagExonParentTranscript");
                additionalArguments.append(' ');
                additionalArguments.append(this.gtfTagExonParentTranscript);
                additionalArguments.append(' ');
                additionalDescription.put("sjdbGTFtagExonParentTranscript", this.gtfTagExonParentTranscript);
            }
            if (this.gtfFeatureExon != null) {
                additionalArguments.append("--sjdbGTFfeatureExon");
                additionalArguments.append(' ');
                additionalArguments.append(this.gtfFeatureExon);
                additionalArguments.append(' ');
                additionalDescription.put("sjdbGTFfeatureExon", this.gtfFeatureExon);
            }
            if (this.chrStartEndFilename != null) {
                DataFile chrStartEndFile = new DataFile(this.chrStartEndFilename);
                if (!chrStartEndFile.exists()) {
                    throw new IOException("Unable to read chromosome startend file: " + chrStartEndFile);
                }
                File chrStartEndFilePath = this.uncompressFileIfNecessary(context, temporaryFiles, chrStartEndFile);
                additionalArguments.append("--sjdbFileChrStartEnd");
                additionalArguments.append(' ');
                additionalArguments.append(chrStartEndFilePath.getAbsolutePath());
                additionalArguments.append(' ');
                additionalDescription.put("sjdbFileChrStartEnd", FileUtils.computeMD5Sum((File)chrStartEndFilePath));
            }
            if (this.genomeSAindexNbases != null) {
                additionalArguments.append("--genomeSAindexNbases");
                additionalArguments.append(' ');
                additionalArguments.append(this.genomeSAindexNbases.toString());
                additionalArguments.append(' ');
                additionalDescription.put("genomeSAindexNbases", this.genomeSAindexNbases.toString());
            }
            if (this.genomeChrBinNbits != null) {
                additionalArguments.append("--genomeChrBinNbits");
                additionalArguments.append(' ');
                additionalArguments.append(this.genomeChrBinNbits.toString());
                additionalArguments.append(' ');
                additionalDescription.put("genomeChrBinNbits", this.genomeChrBinNbits.toString());
            }
            if (this.indexerArguments != null && !this.indexerArguments.isEmpty()) {
                additionalArguments.append(this.indexerArguments);
                additionalDescription.put("indexerArguments", this.indexerArguments);
            }
            status.setProgressMessage(this.mapper.getName() + " index creation");
            GenomeMapperIndexGeneratorModule.execute(this.mapper, context, additionalArguments.toString(), additionalDescription, context.getCurrentStep().getRequiredProcessors());
            for (File temporaryFile : temporaryFiles) {
                if (temporaryFile.delete()) continue;
                context.getLogger().warning("Cannot remove temporary file: " + temporaryFile);
            }
        }
        catch (EoulsanException | IOException e) {
            return status.createTaskResult(e);
        }
        return status.createTaskResult();
    }

    private File uncompressFileIfNecessary(TaskContext context, List<File> temporaryFiles, DataFile file) throws IOException {
        File result;
        Objects.requireNonNull(file, "file argument cannot be null");
        if (file.getCompressionType() != CompressionType.NONE || !file.isLocalFile()) {
            File uncompressedFile = this.uncompressFile(context, file);
            temporaryFiles.add(uncompressedFile);
            result = uncompressedFile;
        } else {
            result = file.toFile();
        }
        return result;
    }

    private File uncompressFile(TaskContext context, DataFile file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        DataProtocol protocol = file.getProtocol();
        DataFile realFile = protocol instanceof StorageDataProtocol ? ((StorageDataProtocol)protocol).getUnderLyingData(file) : file;
        File outputFile = Files.createTempFile(context.getLocalTempDirectory().toPath(), "starindexgenerator-", realFile.getExtension(), new FileAttribute[0]).toFile();
        context.getLogger().fine("Uncompress/copy " + realFile + " to " + outputFile);
        DataFiles.copy(realFile, new DataFile(outputFile));
        return outputFile;
    }
}

