/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.InputPorts;
import fr.ens.biologie.genomique.eoulsan.core.InputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.MultiReadFilter;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.MultiReadFilterBuilder;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.Map;
import java.util.Set;

public abstract class AbstractReadsFilterModule
extends AbstractModule {
    protected static final String MODULE_NAME = "filterreads";
    protected static final String COUNTER_GROUP = "reads_filtering";
    private Map<String, String> readsFiltersParameters;
    private int reducerTaskCount = -1;

    protected Map<String, String> getReadFilterParameters() {
        return this.readsFiltersParameters;
    }

    protected int getReducerTaskCount() {
        return this.reducerTaskCount;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "This step filters reads.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public InputPorts getInputPorts() {
        return InputPortsBuilder.singleInputPort(DataFormats.READS_FASTQ);
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.READS_FASTQ);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        try {
            MultiReadFilterBuilder filterBuilder = new MultiReadFilterBuilder(context.getGenericLogger());
            block8: for (Parameter p : stepParameters) {
                AbstractReadsFilterModule.checkDeprecatedParameter(context, p);
                switch (p.getName()) {
                    case "hadoop.reducer.task.count": {
                        this.reducerTaskCount = p.getIntValueGreaterOrEqualsTo(1);
                        continue block8;
                    }
                }
                filterBuilder.addParameter(p.getName(), p.getStringValue());
            }
            filterBuilder.getReadFilter();
            this.readsFiltersParameters = filterBuilder.getParameters();
        }
        catch (KenetreException e) {
            throw new EoulsanException(e);
        }
    }

    static void checkDeprecatedParameter(StepConfigurationContext context, Parameter parameter) throws EoulsanException {
        if (parameter == null) {
            return;
        }
        switch (parameter.getName()) {
            case "lengthThreshold": {
                Modules.renamedParameter(context, parameter, "trim.length.threshold", true);
            }
            case "qualityThreshold": {
                Modules.renamedParameter(context, parameter, "quality.threshold", true);
            }
            case "pairend.accept.pairend": {
                Modules.renamedParameter(context, parameter, "pairedend.accept.paired.end", true);
            }
            case "pairend.accept.singlend": {
                Modules.renamedParameter(context, parameter, "pairedend.accept.single.end", true);
            }
            case "trim.length.threshold": {
                Modules.renamedParameter(context, parameter, "trimpolynend\" and \"length");
                break;
            }
        }
    }

    protected MultiReadFilter getReadFilter(GenericLogger logger, ReporterIncrementer incrementer, String counterGroup) throws EoulsanException {
        try {
            return new MultiReadFilterBuilder(logger, this.readsFiltersParameters).getReadFilter(incrementer, counterGroup);
        }
        catch (KenetreException e) {
            throw new EoulsanException(e);
        }
    }
}

