/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.modules.mapping;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.core.Modules;
import fr.ens.biologie.genomique.eoulsan.core.OutputPorts;
import fr.ens.biologie.genomique.eoulsan.core.OutputPortsBuilder;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.AbstractModule;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.Mapper;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperBuilder;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstanceBuilder;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.util.Set;

public abstract class AbstractReadsMapperModule
extends AbstractModule {
    public static final String MODULE_NAME = "mapreads";
    protected static final String COUNTER_GROUP = "reads_mapping";
    protected static final String READS_PORT_NAME = "reads";
    protected static final String MAPPER_INDEX_PORT_NAME = "mapperindex";
    protected static final String GENOME_DESCRIPTION_PORT_NAME = "genomedescription";
    public static final String MAPPER_NAME_PARAMETER_NAME = "mapper";
    public static final String MAPPER_VERSION_PARAMETER_NAME = "mapper.version";
    public static final String MAPPER_FLAVOR_PARAMETER_NAME = "mapper.flavor";
    public static final String USE_BUNDLED_BINARIES_PARAMETER_NAME = "mapper.use.bundled.binares";
    public static final String MAPPER_DOCKER_IMAGE_PARAMETER_NAME = "mapper.docker.image";
    public static final String MAPPER_ARGUMENTS_PARAMETER_NAME = "mapper.arguments";
    public static final String HADOOP_THREADS_PARAMETER_NAME = "hadoop.threads";
    public static final String LOCAL_THREADS_PARAMETER_NAME = "local.threads";
    public static final String MAX_LOCAL_THREADS_PARAMETER_NAME = "max.local.threads";
    public static final int HADOOP_TIMEOUT = 3600000;
    static final int DEFAULT_MAPPER_REQUIRED_MEMORY = 8192;
    private Mapper mapper;
    private String mapperVersion = "";
    private String mapperFlavor = "";
    private String mapperDockerImage = "";
    private boolean useBundledBinaries = true;
    private String mapperArguments;
    private int reducerTaskCount = -1;
    private int hadoopThreads;
    private int localThreads;
    private int maxLocalThreads;
    private int hadoopMapperRequiredMemory = 8192;

    protected String getMapperName() {
        return this.mapper.getName();
    }

    protected String getMapperVersion() {
        return this.mapperVersion;
    }

    protected String getMapperFlavor() {
        return this.mapperFlavor;
    }

    protected boolean isUseBundledBinaries() {
        return this.useBundledBinaries;
    }

    protected String getMapperDockerImage() {
        return this.mapperDockerImage;
    }

    protected String getMapperArguments() {
        return this.mapperArguments;
    }

    protected int getMapperLocalThreads() {
        return Common.getThreadsNumber(this.localThreads, this.maxLocalThreads);
    }

    protected int getMapperHadoopThreads() {
        return this.hadoopThreads;
    }

    protected int getMapperHadoopMemoryRequired() {
        return this.hadoopMapperRequiredMemory;
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    protected int getReducerTaskCount() {
        return this.reducerTaskCount;
    }

    @Override
    public String getName() {
        return MODULE_NAME;
    }

    @Override
    public String getDescription() {
        return "This step filters reads.";
    }

    @Override
    public Version getVersion() {
        return Globals.APP_VERSION;
    }

    @Override
    public OutputPorts getOutputPorts() {
        return OutputPortsBuilder.singleOutputPort(DataFormats.MAPPER_RESULTS_SAM);
    }

    @Override
    public void configure(StepConfigurationContext context, Set<Parameter> stepParameters) throws EoulsanException {
        String mapperName = null;
        block26: for (Parameter p : stepParameters) {
            AbstractReadsMapperModule.checkDeprecatedParameter(context, p);
            switch (p.getName()) {
                case "mapper": {
                    mapperName = p.getStringValue();
                    continue block26;
                }
                case "mapper.version": {
                    this.mapperVersion = p.getStringValue();
                    continue block26;
                }
                case "mapper.flavor": {
                    this.mapperFlavor = p.getStringValue();
                    continue block26;
                }
                case "mapper.use.bundled.binares": {
                    this.useBundledBinaries = p.getBooleanValue();
                    continue block26;
                }
                case "mapper.docker.image": {
                    this.mapperDockerImage = p.getStringValue();
                    continue block26;
                }
                case "mapper.arguments": {
                    this.mapperArguments = p.getStringValue();
                    continue block26;
                }
                case "hadoop.threads": {
                    this.hadoopThreads = p.getIntValueGreaterOrEqualsTo(1);
                    continue block26;
                }
                case "local.threads": {
                    this.localThreads = p.getIntValueGreaterOrEqualsTo(1);
                    continue block26;
                }
                case "max.local.threads": {
                    this.maxLocalThreads = p.getIntValueGreaterOrEqualsTo(1);
                    continue block26;
                }
                case "hadoop.reducer.task.count": {
                    this.reducerTaskCount = p.getIntValueGreaterOrEqualsTo(1);
                    continue block26;
                }
            }
            Modules.unknownParameter(context, p);
        }
        if (mapperName == null) {
            Modules.invalidConfiguration(context, "No mapper set");
        }
        try {
            this.mapper = new MapperBuilder(mapperName).withLogger(EoulsanLogger.getGenericLogger()).withApplicationName("Eoulsan").withApplicationVersion(Globals.APP_VERSION_STRING).withTempDirectory(EoulsanRuntime.getSettings().getTempDirectoryFile()).withExecutablesTempDirectory(EoulsanRuntime.getSettings().getExecutablesTempDirectoryFile()).build();
            if (this.mapper == null) {
                Modules.invalidConfiguration(context, "Unknown mapper: " + mapperName);
            }
            new MapperInstanceBuilder(this.mapper).withMapperVersion(this.mapperVersion).withMapperFlavor(this.mapperFlavor).withUseBundledBinaries(true).withDockerImage(this.mapperDockerImage).build();
            if (this.mapper.isIndexGeneratorOnly()) {
                Modules.invalidConfiguration(context, "The selected mapper can only be used for index generation: " + mapperName);
            }
        }
        catch (IOException e) {
            throw new EoulsanException(e);
        }
        int requiredMemory = context.getCurrentStep().getRequiredMemory();
        if (requiredMemory > 0) {
            this.hadoopMapperRequiredMemory = requiredMemory;
        }
        EoulsanLogger.getLogger().info("In " + this.getName() + ", mapper=" + this.mapper.getName() + " (version: " + this.mapperVersion + ")");
        EoulsanLogger.getLogger().info("In " + this.getName() + ", mapperarguments=" + this.mapperArguments);
    }

    static void checkDeprecatedParameter(StepConfigurationContext context, Parameter parameter) throws EoulsanException {
        if (parameter == null) {
            return;
        }
        switch (parameter.getName()) {
            case "mapperarguments": {
                Modules.renamedParameter(context, parameter, MAPPER_ARGUMENTS_PARAMETER_NAME, true);
            }
            case "mapper": {
                if (!"soap".equals(parameter.getLowerStringValue())) break;
                Modules.badParameterValue(context, parameter, "The SOAP mapper support has been removed from Eoulsan");
                break;
            }
            case "hadoop.mapper.required.memory": {
                Modules.badParameterValue(context, parameter, "The " + parameter.getName() + " parameter no more exists. Use instead the \"requiredMemory\" attribute of the step tag to define the amount of memory required by the mapper in Hadoop mode.");
                break;
            }
        }
    }
}

